/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.capability;

import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.common.capability.IPlayerRecipeData;
import top.theillusivec4.polymorph.client.recipe.RecipesWidget;
import top.theillusivec4.polymorph.common.capability.AbstractRecipeData;

public class PlayerRecipeData
extends AbstractRecipeData<Player>
implements IPlayerRecipeData {
    private AbstractContainerMenu containerMenu;

    public PlayerRecipeData(Player pOwner) {
        super(pOwner);
    }

    @Override
    public <T extends Recipe<C>, C extends Container> Optional<T> getRecipe(RecipeType<T> pType, C pInventory, Level pWorld, List<T> pRecipes) {
        Optional<T> maybeRecipe = super.getRecipe(pType, pInventory, pWorld, pRecipes);
        if (this.getContainerMenu() == ((Player)this.getOwner()).f_36096_) {
            this.syncPlayerRecipeData();
        }
        this.setContainerMenu(null);
        return maybeRecipe;
    }

    @Override
    public void selectRecipe(@Nonnull Recipe<?> pRecipe) {
        super.selectRecipe(pRecipe);
        this.syncPlayerRecipeData();
    }

    private void syncPlayerRecipeData() {
        if (this.getOwner() instanceof ServerPlayer) {
            PolymorphApi.common().getPacketDistributor().sendPlayerSyncS2C((ServerPlayer)this.getOwner(), this.getRecipesList(), this.getSelectedRecipe().map(Recipe::m_6423_).orElse(null));
        }
    }

    @Override
    public void sendRecipesListToListeners(boolean pEmpty) {
        if (this.getContainerMenu() == ((Player)this.getOwner()).f_36096_) {
            Pair packetData = pEmpty ? new Pair(new TreeSet(), null) : this.getPacketData();
            Player player = (Player)this.getOwner();
            if (player.f_19853_.m_5776_()) {
                RecipesWidget.get().ifPresent(widget -> widget.setRecipesList((Set)packetData.getFirst(), (ResourceLocation)packetData.getSecond()));
            } else if (player instanceof ServerPlayer) {
                PolymorphApi.common().getPacketDistributor().sendRecipesListS2C((ServerPlayer)player, (SortedSet)packetData.getFirst(), (ResourceLocation)packetData.getSecond());
            }
        }
    }

    @Override
    public Set<ServerPlayer> getListeners() {
        Player player = (Player)this.getOwner();
        if (player instanceof ServerPlayer) {
            return Collections.singleton((ServerPlayer)player);
        }
        return new HashSet<ServerPlayer>();
    }

    @Override
    public void setContainerMenu(AbstractContainerMenu containerMenu) {
        this.containerMenu = containerMenu;
    }

    @Override
    public AbstractContainerMenu getContainerMenu() {
        return this.containerMenu;
    }
}

