/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsbridges.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungsbridges.YungsBridgesCommon;
import com.yungnickyoung.minecraft.yungsbridges.world.processor.ITemplateFeatureProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public abstract class AbstractTemplateFeature<C extends FeatureConfiguration>
extends Feature<C> {
    protected List<ITemplateFeatureProcessor> processors = this.useProcessors();

    public AbstractTemplateFeature(Codec<C> codec) {
        super(codec);
    }

    protected StructureTemplate createTemplate(ResourceLocation id, WorldGenLevel level, Random rand, BlockPos pos) {
        return this.createTemplateWithPlacement(id, level, rand, pos, new StructurePlaceSettings());
    }

    protected StructureTemplate createTemplateWithPlacement(ResourceLocation id, WorldGenLevel level, Random rand, BlockPos cornerPos, StructurePlaceSettings placement) {
        Optional templateOptional = level.m_6018_().m_8875_().m_163774_(id);
        if (templateOptional.isEmpty()) {
            YungsBridgesCommon.LOGGER.warn("Failed to create invalid feature {}", (Object)id);
            return null;
        }
        StructureTemplate template = (StructureTemplate)templateOptional.get();
        BlockPos centerPos = cornerPos.m_142082_(template.m_163801_().m_123341_() / 2, 0, template.m_163801_().m_123343_() / 2);
        template.m_74536_((ServerLevelAccessor)level, cornerPos, centerPos, placement, rand, 2);
        this.processors.forEach(processor -> processor.processTemplate(template, level, rand, cornerPos, centerPos, placement));
        return template;
    }

    protected List<ITemplateFeatureProcessor> useProcessors() {
        return new ArrayList<ITemplateFeatureProcessor>();
    }
}

