/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.progressivebosses.setup.Config;
import insane96mcp.progressivebosses.utils.DifficultyHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Resistances & Vulnerabilities", description="Handles the Damage Resistances and Vulnerabilities")
public class ResistancesFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> meleeDamageReductionAboveHalfHealthConfig;
    private final ForgeConfigSpec.ConfigValue<Double> maxMeleeDamageReductionAboveHalfHealthConfig;
    private final ForgeConfigSpec.ConfigValue<Double> meleeDamageReductionBelowHalfHealthConfig;
    private final ForgeConfigSpec.ConfigValue<Double> maxMeleeDamageReductionBelowHalfHealthConfig;
    private final ForgeConfigSpec.ConfigValue<Double> magicDamageBonusConfig;
    public double meleeDamageReductionAboveHalfHealth = 0.24;
    public double maxMeleeDamageReductionAboveHalfHealth = 0.24;
    public double meleeDamageReductionBelowHalfHealth = 0.48;
    public double maxMeleeDamageReductionBelowHalfHealth = 0.48;
    public double magicDamageBonus = 250.0;

    public ResistancesFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.meleeDamageReductionAboveHalfHealthConfig = Config.builder.comment("Percentage Melee Damage Reduction (at max difficulty) while the Wither is above half health.").defineInRange("Melee Damage reduction above half health", this.meleeDamageReductionAboveHalfHealth, 0.0, 1.0);
        this.maxMeleeDamageReductionAboveHalfHealthConfig = Config.builder.comment("Cap for 'Melee Damage reduction above half health'").defineInRange("Max Melee Damage reduction before half health", this.maxMeleeDamageReductionAboveHalfHealth, 0.0, 1.0);
        this.meleeDamageReductionBelowHalfHealthConfig = Config.builder.comment("Percentage Melee Damage Reduction (at max difficulty) as the Wither drops below half health.").defineInRange("Melee Damage reduction below half health", this.meleeDamageReductionBelowHalfHealth, 0.0, 1.0);
        this.maxMeleeDamageReductionBelowHalfHealthConfig = Config.builder.comment("Cap for 'Melee Damage Reduction below half health'").defineInRange("Max Melee Damage reduction below half health", this.maxMeleeDamageReductionBelowHalfHealth, 0.0, 1.0);
        this.magicDamageBonusConfig = Config.builder.comment("Bonus magic damage based off missing health. 250 means that every 250 missing health the damage will be amplified by 100%. E.g. The first Wither (with 300 max health) is at 50 health (so it's missing 250hp), on magic damage he will receive 'magic_damage * (missing_health / magic_damage_bonus + 1)' = 'magic_damage * (250 / 250 + 1)' = 'magic_damage * 2'.").defineInRange("Magic Damage Bonus", this.magicDamageBonus, 0.0, 1024.0);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.meleeDamageReductionAboveHalfHealth = (Double)this.meleeDamageReductionAboveHalfHealthConfig.get();
        this.maxMeleeDamageReductionAboveHalfHealth = (Double)this.maxMeleeDamageReductionAboveHalfHealthConfig.get();
        this.meleeDamageReductionBelowHalfHealth = (Double)this.meleeDamageReductionBelowHalfHealthConfig.get();
        this.maxMeleeDamageReductionBelowHalfHealth = (Double)this.maxMeleeDamageReductionBelowHalfHealthConfig.get();
        this.magicDamageBonus = (Double)this.magicDamageBonusConfig.get();
    }

    @SubscribeEvent
    public void onWitherDamage(LivingDamageEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)entity;
        if (!(this.meleeDamageReductionBelowHalfHealth != 0.0 && this.maxMeleeDamageReductionBelowHalfHealth != 0.0 || this.meleeDamageReductionAboveHalfHealth != 0.0 && this.maxMeleeDamageReductionAboveHalfHealth != 0.0 || this.magicDamageBonus != 0.0)) {
            return;
        }
        if (event.getSource().m_19387_() && this.magicDamageBonus > 0.0) {
            double missingHealth = wither.m_21233_() - wither.m_21223_();
            event.setAmount(event.getAmount() * (float)(missingHealth / this.magicDamageBonus + 1.0));
        }
        if (event.getSource().m_7640_() != event.getSource().m_7639_()) {
            return;
        }
        float damageReduction = !wither.m_7090_() ? (float)Math.min(this.maxMeleeDamageReductionAboveHalfHealth, this.meleeDamageReductionAboveHalfHealth * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)wither)) : (float)Math.min(this.maxMeleeDamageReductionBelowHalfHealth, this.meleeDamageReductionBelowHalfHealth * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)wither));
        if ((double)damageReduction == 0.0) {
            return;
        }
        event.setAmount(event.getAmount() * (1.0f - damageReduction));
    }
}

