/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.progressivebosses.module.wither.dispenser.WitherSkullDispenseBehavior;
import insane96mcp.progressivebosses.setup.Config;
import insane96mcp.progressivebosses.utils.DifficultyHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Misc", description="Handles various small features, such as the explosion")
public class MiscFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> explosionPowerBonusConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> explosionCausesFireAtDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> fasterBlockBreakingConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> biggerBlockBreakingConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> ignoreWitherProofBlocksConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> witherNetherOnlyConfig;
    public double explosionPowerBonus = 8.0;
    public int explosionCausesFireAtDifficulty = -1;
    public boolean fasterBlockBreaking = true;
    public boolean biggerBlockBreaking = true;
    public boolean ignoreWitherProofBlocks = false;
    public boolean witherNetherOnly = false;
    private boolean behaviourRegistered = false;

    public MiscFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.explosionPowerBonusConfig = Config.builder.comment("How much explosion power (after the invulnerability) will the Wither have at max difficulty. Explosion Radius is capped to 13. Base Wither Explosion Power is 7.0. Setting this to 0 will not increase the Wither Explosion Power.").defineInRange("Explosion Power Bonus", this.explosionPowerBonus, 0.0, 8.0);
        this.explosionCausesFireAtDifficultyConfig = Config.builder.comment("At this difficulty the Wither Explosion will cause fire. Set to -1 to disable.").defineInRange("Explosion Causes Fire at Difficulty", this.explosionCausesFireAtDifficulty, -1, Integer.MAX_VALUE);
        this.fasterBlockBreakingConfig = Config.builder.comment("The Wither will no longer wait 1.0 seconds before breaking blocks when he's hit, instead just 0.5s").define("Faster Breaking Blocks", this.fasterBlockBreaking);
        this.biggerBlockBreakingConfig = Config.builder.comment("The Wither will break even blocks below him when hit.").define("Bigger Breaking Blocks", this.biggerBlockBreaking);
        this.ignoreWitherProofBlocksConfig = Config.builder.comment("If true the Wither will break even blocks that are witherproof. Unbreakable blocks will still be unbreakable, so it's really useful with other mods as in vanilla Wither Proof Blocks are all the unbreakable blocks.").define("Ignore Witherproof Blocks", this.ignoreWitherProofBlocks);
        this.witherNetherOnlyConfig = Config.builder.comment("The wither can only be spawned in the Nether.\nNote that this feature completely disables Wither Skulls from begin placed nearby Soul Sand when not in the Nether or when on the Nether Roof.\nRequires Minecraft restart.").define("Wither Nether Only", this.witherNetherOnly);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.explosionPowerBonus = (Double)this.explosionPowerBonusConfig.get();
        this.explosionCausesFireAtDifficulty = (Integer)this.explosionCausesFireAtDifficultyConfig.get();
        this.fasterBlockBreaking = (Boolean)this.fasterBlockBreakingConfig.get();
        this.biggerBlockBreaking = (Boolean)this.biggerBlockBreakingConfig.get();
        this.ignoreWitherProofBlocks = (Boolean)this.ignoreWitherProofBlocksConfig.get();
        this.witherNetherOnly = (Boolean)this.witherNetherOnlyConfig.get();
        if (this.witherNetherOnly && !this.behaviourRegistered) {
            DispenserBlock.m_52672_((ItemLike)Items.f_42679_, (DispenseItemBehavior)new WitherSkullDispenseBehavior());
            this.behaviourRegistered = true;
        }
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!this.biggerBlockBreaking) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)entity;
        if (!wither.m_6084_()) {
            return;
        }
        if (wither.f_31429_ == 1) {
            --wither.f_31429_;
            if (ForgeEventFactory.getMobGriefingEvent((Level)wither.f_19853_, (Entity)wither)) {
                int i1 = Mth.m_14107_((double)wither.m_20186_());
                int l1 = Mth.m_14107_((double)wither.m_20185_());
                int i2 = Mth.m_14107_((double)wither.m_20189_());
                boolean flag = false;
                int yOffsetLow = -1;
                if (wither.m_7090_()) {
                    yOffsetLow = 0;
                }
                for (int k2 = -1; k2 <= 1; ++k2) {
                    for (int l2 = -1; l2 <= 1; ++l2) {
                        for (int j = yOffsetLow; j <= 4; ++j) {
                            int i3 = l1 + k2;
                            int k = i1 + j;
                            int l = i2 + l2;
                            BlockPos blockpos = new BlockPos(i3, k, l);
                            BlockState blockstate = wither.f_19853_.m_8055_(blockpos);
                            if (!this.canWitherDestroy(wither, blockpos, blockstate) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)wither, (BlockPos)blockpos, (BlockState)blockstate)) continue;
                            flag = wither.f_19853_.m_46953_(blockpos, true, (Entity)wither) || flag;
                        }
                    }
                }
                if (flag) {
                    wither.f_19853_.m_5898_(null, 1022, wither.m_142538_(), 0);
                }
            }
        }
    }

    private boolean canWitherDestroy(WitherBoss wither, BlockPos pos, BlockState state) {
        if (this.ignoreWitherProofBlocks) {
            return !state.m_60795_() && state.m_60800_((BlockGetter)wither.f_19853_, pos) >= 0.0f;
        }
        return state.canEntityDestroy((BlockGetter)wither.f_19853_, pos, (Entity)wither);
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Start event) {
        WitherBoss wither;
        block7: {
            block6: {
                Entity entity;
                if (!this.isEnabled() || this.explosionCausesFireAtDifficulty == -1 && this.explosionPowerBonus == 0.0 || !((entity = event.getExplosion().getExploder()) instanceof WitherBoss)) break block6;
                wither = (WitherBoss)entity;
                if (event.getExplosion().f_46017_ == 7.0f) break block7;
            }
            return;
        }
        CompoundTag tags = wither.getPersistentData();
        float difficulty = tags.m_128457_("progressivebosses:difficulty");
        if (difficulty <= 0.0f) {
            return;
        }
        float explosionPower = (float)((double)event.getExplosion().f_46017_ + this.explosionPowerBonus * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)wither));
        if (explosionPower > 13.0f) {
            explosionPower = 13.0f;
        }
        event.getExplosion().f_46017_ = explosionPower;
        if (this.explosionCausesFireAtDifficulty > -1) {
            event.getExplosion().f_46009_ = difficulty >= (float)this.explosionCausesFireAtDifficulty;
        }
    }

    @SubscribeEvent
    public void onWitherDamage(LivingHurtEvent event) {
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!this.fasterBlockBreaking) {
            return;
        }
        if (!event.getEntity().m_6084_()) {
            return;
        }
        LivingEntity livingEntity = event.getEntityLiving();
        if (!(livingEntity instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)livingEntity;
        wither.f_31429_ = 10;
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getItemStack().m_41720_() == Items.f_42679_ && !this.canPlaceSkull(event.getWorld(), event.getPos().m_141952_(event.getFace().m_122436_()))) {
            event.setCanceled(true);
        }
    }

    public boolean canPlaceSkull(Level world, BlockPos pos) {
        if (!this.witherNetherOnly) {
            return true;
        }
        boolean isNether = world.m_46472_() == Level.f_46429_;
        boolean hasSoulSandNearby = false;
        for (Direction dir : Direction.values()) {
            if (!world.m_8055_(pos.m_141952_(dir.m_122436_())).m_60734_().equals(Blocks.f_50135_) && !world.m_8055_(pos.m_141952_(dir.m_122436_())).m_60734_().equals(Blocks.f_50136_)) continue;
            hasSoulSandNearby = true;
            break;
        }
        return isNether && pos.m_123342_() <= 127 || !hasSoulSandNearby;
    }
}

