/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories.tag;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.util.MatrixUtils;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.plugin.client.categories.tag.TagNodeWidget;
import me.shedaniel.rei.plugin.common.displays.tag.TagNode;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;

public class ValueTagNodeWidget<S, T>
extends TagNodeWidget<S, T> {
    private final Rectangle bounds;
    private final List<Widget> widgets;
    private final WidgetWithBounds widget;
    private final List<? extends GuiEventListener> children;
    private final Rectangle overflowBounds;

    public ValueTagNodeWidget(TagNode<S> node, Function<Holder<S>, EntryStack<T>> mapper, Rectangle overflowBounds) {
        this.overflowBounds = overflowBounds;
        HolderSet<S> holders = node.getValue();
        int width = Math.min(4, holders.m_203632_());
        int height = Math.max((int)Math.ceil((double)holders.m_203632_() * 1.0 / (double)width), 1);
        this.bounds = new Rectangle(0, 0, 16 * width + 12, 16 * height + 12);
        Panel background = Widgets.createRecipeBase(this.bounds.clone()).rendering((Predicate<Panel>)Predicates.alwaysTrue());
        Panel slotBackground = Widgets.createSlotBase(new Rectangle(5, 5, 16 * width + 2, 16 * height + 2));
        int i = 0;
        this.widgets = new ArrayList<Widget>();
        this.widgets.add(background);
        this.widgets.add(slotBackground);
        for (Holder holder : holders) {
            int x = i % width;
            int y = i / width;
            Slot slot = Widgets.createSlot(new Rectangle(x * 16 + 5, y * 16 + 5, 18, 18)).entry(mapper.apply(holder)).disableBackground();
            this.widgets.add(slot);
            ++i;
        }
        this.widget = Widgets.withTranslate(Widgets.concat(this.widgets), $ -> Matrix4f.m_27653_((float)this.getBounds().x, (float)this.getBounds().y, (float)0.0f));
        this.children = Collections.singletonList(this.widget);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void m_6305_(PoseStack poses, int mouseX, int mouseY, float delta) {
        Rectangle bounds = this.getBounds();
        if (this.overflowBounds.intersects(MatrixUtils.transform(poses.m_85850_().m_85861_(), bounds))) {
            poses.m_85836_();
            poses.m_85837_((double)bounds.x, (double)bounds.y, 0.0);
            Point mouse = new Point(mouseX - bounds.x, mouseY - bounds.y);
            for (Widget widget : this.widgets) {
                if (widget instanceof WidgetWithBounds) {
                    WidgetWithBounds withBounds = (WidgetWithBounds)widget;
                    if (!this.overflowBounds.intersects(MatrixUtils.transform(poses.m_85850_().m_85861_(), withBounds.getBounds()))) continue;
                }
                widget.m_6305_(poses, mouse.x, mouse.y, delta);
            }
            poses.m_85849_();
        }
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.children;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        for (GuiEventListener element : this.m_6702_()) {
            if (!element.m_6348_(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        for (GuiEventListener element : this.m_6702_()) {
            if (!element.m_7933_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }
}

