/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.mixin.forge;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.plugin.common.displays.tag.TagNodes;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Tag.Builder.class})
public class MixinTagBuilder<T> {
    @Shadow
    @Final
    private List<Tag.BuilderEntry> f_13302_;

    @Inject(method={"build"}, at={@At(value="RETURN")})
    private void load(Function<ResourceLocation, Tag<T>> tagResolver, Function<ResourceLocation, T> valueResolver, CallbackInfoReturnable<Either<Collection<Tag.BuilderEntry>, Tag<T>>> cir) {
        Tag tag = ((Either)cir.getReturnValue()).right().orElse(null);
        if (tag != null) {
            String currentTagDirectory = TagNodes.CURRENT_TAG_DIR.get();
            if (currentTagDirectory == null) {
                return;
            }
            ResourceKey<? extends Registry<?>> resourceKey = TagNodes.TAG_DIR_MAP.get(currentTagDirectory);
            if (resourceKey == null) {
                return;
            }
            Map<Tag<?>, TagNodes.RawTagData> dataMap = TagNodes.RAW_TAG_DATA_MAP.get(currentTagDirectory);
            if (dataMap == null) {
                return;
            }
            ArrayList<ResourceLocation> otherElements = new ArrayList<ResourceLocation>();
            ArrayList<ResourceLocation> otherTags = new ArrayList<ResourceLocation>();
            for (Tag.BuilderEntry builderEntry : this.f_13302_) {
                Object apply;
                Tag.Entry entry = builderEntry.f_13338_();
                if (entry instanceof Tag.OptionalTagEntry) {
                    Tag.OptionalTagEntry tagEntry = (Tag.OptionalTagEntry)entry;
                    apply = tagResolver.apply(tagEntry.f_13373_);
                    if (apply == null) continue;
                    otherTags.add(tagEntry.f_13373_);
                    continue;
                }
                apply = builderEntry.f_13338_();
                if (apply instanceof Tag.TagEntry) {
                    Tag.TagEntry tagEntry = (Tag.TagEntry)apply;
                    apply = tagResolver.apply(tagEntry.f_13383_);
                    if (apply == null) continue;
                    otherTags.add(tagEntry.f_13383_);
                    continue;
                }
                apply = builderEntry.f_13338_();
                if (apply instanceof Tag.OptionalElementEntry) {
                    Tag.OptionalElementEntry tagEntry = (Tag.OptionalElementEntry)apply;
                    apply = valueResolver.apply(tagEntry.f_13363_);
                    if (apply == null) continue;
                    otherElements.add(tagEntry.f_13363_);
                    continue;
                }
                apply = builderEntry.f_13338_();
                if (!(apply instanceof Tag.ElementEntry)) continue;
                Tag.ElementEntry tagEntry = (Tag.ElementEntry)apply;
                apply = valueResolver.apply(tagEntry.f_13349_);
                if (apply == null) continue;
                otherElements.add(tagEntry.f_13349_);
            }
            dataMap.put(tag, new TagNodes.RawTagData(CollectionUtils.distinctToList(otherElements), CollectionUtils.distinctToList(otherTags)));
        }
    }
}

