/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument.type;

import java.util.Locale;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.gui.config.SearchMode;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.FormattingUtils;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import net.minecraft.util.Unit;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public final class TextArgumentType
extends ArgumentType<Unit, String> {
    private static final TooltipContext CONTEXT = TooltipContext.of(new Point(), (TooltipFlag)TooltipFlag.Default.NORMAL, true);

    @Override
    public String getName() {
        return "text";
    }

    @Override
    @Nullable
    public String getPrefix() {
        return "";
    }

    @Override
    public SearchMode getSearchMode() {
        return SearchMode.ALWAYS;
    }

    @Override
    public String cacheData(EntryStack<?> stack) {
        return FormattingUtils.stripFormatting(stack.asFormattedText(CONTEXT).getString()).toLowerCase(Locale.ROOT);
    }

    @Override
    public void matches(String value, EntryStack<?> stack, Unit filterData, ArgumentType.ResultSink sink) {
        sink.testString(value);
    }

    @Override
    public Unit prepareSearchFilter(String searchText) {
        return null;
    }
}

