/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.screen;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.config.DisplayPanelLocation;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZonesProvider;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.InteractionResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class ExclusionZonesImpl
implements ExclusionZones {
    private static final Comparator<? super Rectangle> RECTANGLE_COMPARER = Comparator.comparingLong(Rectangle::hashCode);
    private long lastArea = -1L;
    private final Multimap<Class<?>, Function<Screen, Collection<Rectangle>>> list = HashMultimap.create();

    @Override
    public <R extends Screen> boolean isHandingScreen(Class<R> screen) {
        return Screen.class.isAssignableFrom(screen);
    }

    @Override
    public double getPriority() {
        return -5.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InteractionResult isInZone(double mouseX, double mouseY) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        Class<?> screenClass = screen.getClass();
        Multimap<Class<?>, Function<Screen, Collection<Rectangle>>> multimap = this.list;
        synchronized (multimap) {
            for (Map.Entry collectionEntry : this.list.asMap().entrySet()) {
                if (!((Class)collectionEntry.getKey()).isAssignableFrom(screenClass)) continue;
                for (Function listSupplier : (Collection)collectionEntry.getValue()) {
                    for (Rectangle zone : (Collection)listSupplier.apply(screen)) {
                        if (!zone.contains(mouseX, mouseY)) continue;
                        return InteractionResult.FAIL;
                    }
                }
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean shouldRecalculateArea(DisplayPanelLocation location, Rectangle rectangle) {
        long current = this.currentHashCode(location);
        if (this.lastArea == current) {
            return false;
        }
        this.lastArea = current;
        return true;
    }

    private long currentHashCode(DisplayPanelLocation location) {
        return this.areasHashCode(this.getExclusionZones(Minecraft.m_91087_().f_91080_, false));
    }

    @Override
    @Deprecated
    public List<Rectangle> getExclusionZones(Class<?> currentScreenClass, boolean sort) {
        return this.getExclusionZones(currentScreenClass, Minecraft.m_91087_().f_91080_, sort);
    }

    @Override
    public List<Rectangle> getExclusionZones(Screen screen, boolean sort) {
        if (screen == null) {
            return Lists.newArrayList();
        }
        return this.getExclusionZones(screen.getClass(), screen, sort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Rectangle> getExclusionZones(Class<?> screenClass, Screen screen, boolean sort) {
        if (screen == null || !screenClass.isAssignableFrom(screen.getClass())) {
            return Lists.newArrayList();
        }
        ArrayList rectangles = Lists.newArrayList();
        Multimap<Class<?>, Function<Screen, Collection<Rectangle>>> multimap = this.list;
        synchronized (multimap) {
            for (Map.Entry collectionEntry : this.list.asMap().entrySet()) {
                if (!((Class)collectionEntry.getKey()).isAssignableFrom(screenClass)) continue;
                for (Function listSupplier : (Collection)collectionEntry.getValue()) {
                    rectangles.addAll((Collection)listSupplier.apply(screen));
                }
            }
        }
        if (sort) {
            rectangles.sort(RECTANGLE_COMPARER);
        }
        return rectangles;
    }

    @Override
    public int getZonesCount() {
        return this.list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void register(Class<? extends T> screenClass, ExclusionZonesProvider<? extends T> provider) {
        Multimap<Class<?>, Function<Screen, Collection<Rectangle>>> multimap = this.list;
        synchronized (multimap) {
            this.list.put(screenClass, screen -> provider.provide(screen));
        }
        InternalLogger.getInstance().debug("Added exclusion zones provider: %s for %s", provider, screenClass.getName());
        if (!PluginManager.areAnyReloading()) {
            InternalLogger.getInstance().warn("Detected ExclusionZonesImpl modification at runtime, this may cause issues, a single ExclusionZonesProvider can dynamically provide boundaries instead!", new RuntimeException());
        }
    }

    private long areasHashCode(List<Rectangle> exclusionZones) {
        int hashCode = 31;
        for (Rectangle e : exclusionZones) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }
}

