/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.favorites;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import net.minecraft.network.chat.TranslatableComponent;

public class FavoritesEntriesManager {
    public static final FavoritesEntriesManager INSTANCE = new FavoritesEntriesManager();

    private Stream<FavoriteEntry> getDefaultFavorites() {
        return StreamSupport.stream(FavoriteEntryType.registry().sections().spliterator(), false).flatMap(section -> section.getDefaultEntries().stream());
    }

    public List<FavoriteEntry> getFavorites() {
        ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
        List defaultFavorites = this.getDefaultFavorites().collect(Collectors.toList());
        defaultFavorites.removeAll(config.getHiddenFavoriteEntries());
        ArrayList<FavoriteEntry> favorites = new ArrayList<FavoriteEntry>(config.getConfigFavoriteEntries());
        defaultFavorites.removeAll(favorites);
        favorites.addAll(0, defaultFavorites);
        favorites.removeIf(FavoriteEntry::isInvalid);
        return favorites;
    }

    public void remove(FavoriteEntry entry) {
        FavoritesListWidget widget;
        ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
        config.getConfigFavoriteEntries().remove(entry);
        if (this.getDefaultFavorites().anyMatch(e -> e.equals(entry)) && !config.getHiddenFavoriteEntries().contains(entry)) {
            config.getHiddenFavoriteEntries().add(entry);
            widget = ScreenOverlayImpl.getFavoritesListWidget();
            if (widget != null) {
                Supplier<Rectangle> buttonBounds = widget.togglePanelButton::getBounds;
                ScreenOverlayImpl.getInstance().getHintsContainer().addHint(12, () -> new Point(((Rectangle)buttonBounds.get()).getCenterX(), ((Rectangle)buttonBounds.get()).getCenterY()), "text.rei.hint.favorites.discover", List.of(new TranslatableComponent("text.rei.hint.favorites.discover")));
            }
        }
        ConfigManager.getInstance().saveConfig();
        widget = ScreenOverlayImpl.getFavoritesListWidget();
        if (widget != null) {
            widget.updateSearch();
        }
    }

    public void add(FavoriteEntry entry) {
        ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
        List<FavoriteEntry> defaultFavorites = this.getDefaultFavorites().toList();
        config.getConfigFavoriteEntries().remove(entry);
        if (CollectionUtils.anyMatch(defaultFavorites, e -> e.equals(entry)) && !config.getHiddenFavoriteEntries().contains(entry)) {
            config.getHiddenFavoriteEntries().add(entry);
        }
        for (int i = defaultFavorites.size() - 1; i >= 0; --i) {
            FavoriteEntry e2 = defaultFavorites.get(i);
            if (config.getConfigFavoriteEntries().contains(e2) || config.getHiddenFavoriteEntries().contains(e2)) continue;
            config.getConfigFavoriteEntries().add(0, e2);
        }
        config.getHiddenFavoriteEntries().remove(entry);
        if (!CollectionUtils.anyMatch(defaultFavorites, e -> e.equals(entry))) {
            config.getConfigFavoriteEntries().add(entry);
        }
        ConfigManager.getInstance().saveConfig();
        FavoritesListWidget widget = ScreenOverlayImpl.getFavoritesListWidget();
        if (widget != null) {
            widget.updateSearch();
        }
    }

    public void setEntries(List<FavoriteEntry> entries) {
        List defaultFavorites = this.getDefaultFavorites().collect(Collectors.toList());
        ArrayList hiddenDefaultFavorites = new ArrayList(defaultFavorites);
        hiddenDefaultFavorites.removeAll(entries);
        ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
        config.getHiddenFavoriteEntries().clear();
        config.getHiddenFavoriteEntries().addAll(hiddenDefaultFavorites);
        config.getConfigFavoriteEntries().clear();
        config.getConfigFavoriteEntries().addAll(entries);
        ConfigManager.getInstance().saveConfig();
        FavoritesListWidget widget = ScreenOverlayImpl.getFavoritesListWidget();
        if (widget != null) {
            widget.updateSearch();
        }
    }

    public List<FavoriteEntry> asListView() {
        return new AbstractList<FavoriteEntry>(){

            @Override
            public FavoriteEntry get(int index) {
                return FavoritesEntriesManager.this.getFavorites().get(index);
            }

            @Override
            public int size() {
                return FavoritesEntriesManager.this.getFavorites().size();
            }

            @Override
            public void add(int index, FavoriteEntry entry) {
                FavoritesEntriesManager.this.add(entry);
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof FavoriteEntry) {
                    FavoritesEntriesManager.this.remove((FavoriteEntry)o);
                    return true;
                }
                return false;
            }
        };
    }
}

