/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.basewidgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Arrow;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;

public final class ArrowWidget
extends Arrow {
    private Rectangle bounds;
    private double animationDuration = -1.0;
    private NumberAnimator<Float> darkBackgroundAlpha = ValueAnimator.ofFloat().withConvention(() -> Float.valueOf(REIRuntime.getInstance().isDarkThemeEnabled() ? 1.0f : 0.0f), ValueAnimator.typicalTransitionTime()).asFloat();

    public ArrowWidget(Rectangle bounds) {
        this.bounds = new Rectangle(Objects.requireNonNull(bounds));
    }

    @Override
    public double getAnimationDuration() {
        return this.animationDuration;
    }

    @Override
    public void setAnimationDuration(double animationDurationMS) {
        this.animationDuration = animationDurationMS;
        if (this.animationDuration <= 0.0) {
            this.animationDuration = -1.0;
        }
    }

    @ApiStatus.Internal
    public void setDarkBackgroundAlpha(NumberAnimator<Float> darkBackgroundAlpha) {
        this.darkBackgroundAlpha = darkBackgroundAlpha;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.darkBackgroundAlpha.update((double)delta);
        this.renderBackground(matrices, false, 1.0f);
        if (((Float)this.darkBackgroundAlpha.value()).floatValue() > 0.0f) {
            this.renderBackground(matrices, true, ((Float)this.darkBackgroundAlpha.value()).floatValue());
        }
    }

    public void renderBackground(PoseStack matrices, boolean dark, float alpha) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.m_157456_((int)0, (ResourceLocation)REIRuntime.getInstance().getDefaultDisplayTexture(dark));
        RenderSystem.m_69478_();
        RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)0);
        RenderSystem.m_69405_((int)770, (int)771);
        if (this.getAnimationDuration() > 0.0) {
            int width = Mth.m_14165_((double)((double)System.currentTimeMillis() / (this.animationDuration / 24.0) % 24.0));
            this.m_93228_(matrices, this.getX() + width, this.getY(), 106 + width, 91, 24 - width, 17);
            this.m_93228_(matrices, this.getX(), this.getY(), 82, 91, width, 17);
        } else {
            this.m_93228_(matrices, this.getX(), this.getY(), 106, 91, 24, 17);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public List<? extends GuiEventListener> m_6702_() {
        return Collections.emptyList();
    }
}

