/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.FloatingPoint;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCoreClient;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.impl.client.gui.widget.DelegateWidgetWithTranslate;

public class OverflowWidget
extends DelegateWidgetWithTranslate {
    private final Rectangle bounds;
    private final NumberAnimator<Float> scale;
    private final ValueAnimator<FloatingPoint> translate;
    private final ValueAnimator<FloatingPoint> velocity;
    private boolean dragging;

    public OverflowWidget(Rectangle bounds, WidgetWithBounds widget) {
        super(widget, Matrix4f::new);
        this.bounds = bounds;
        this.scale = ValueAnimator.ofFloat().setAs(1.0f);
        this.translate = ValueAnimator.ofFloatingPoint().setAs((Object)new FloatingPoint((double)((float)(-widget.getBounds().width) / 2.0f), (double)((float)(-bounds.height) / 2.0f)));
        this.velocity = ValueAnimator.ofFloatingPoint().setAs((Object)new FloatingPoint(0.0, 0.0));
    }

    @Override
    protected Matrix4f translate() {
        FloatingPoint translate = (FloatingPoint)this.translate.value();
        float scale = 1.0f / Math.max(this.scale.floatValue(), 0.001f);
        Matrix4f matrix = Matrix4f.m_27653_((float)((float)this.bounds.getCenterX() + (float)translate.x * scale), (float)((float)this.bounds.getCenterY() + (float)translate.y * scale), (float)0.0f);
        matrix.m_27644_(Matrix4f.m_27632_((float)scale, (float)scale, (float)1.0f));
        return matrix;
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        Rectangle widgetBounds = ((WidgetWithBounds)this.delegate()).getBounds();
        this.scale.update((double)delta);
        this.scale.setTarget(ScrollingContainer.handleBounceBack((double)((double)((Float)this.scale.target()).floatValue() - 0.78), (double)((double)Math.min((float)widgetBounds.width * 1.0f / (float)this.getBounds().width, (float)widgetBounds.height * 1.0f / (float)this.getBounds().height) - 0.78), (float)delta, (double)0.001) + 0.78);
        this.translate.update((double)delta);
        for (int i = 0; i < 3; ++i) {
            this.translate.setAs((Object)new FloatingPoint(ScrollingContainer.handleBounceBack((double)(((FloatingPoint)this.translate.target()).x + (double)widgetBounds.width - (double)((float)(this.getBounds().width / 2) * ((Float)this.scale.value()).floatValue())), (double)((float)widgetBounds.width - (float)this.getBounds().width * ((Float)this.scale.value()).floatValue()), (float)delta, (double)1.0E-4) - (double)((float)widgetBounds.width - (float)(this.getBounds().width / 2) * ((Float)this.scale.value()).floatValue()), ScrollingContainer.handleBounceBack((double)(((FloatingPoint)this.translate.target()).y + (double)widgetBounds.height - (double)((float)(this.getBounds().height / 2) * ((Float)this.scale.value()).floatValue())), (double)((float)widgetBounds.height - (float)this.getBounds().height * ((Float)this.scale.value()).floatValue()), (float)delta, (double)1.0E-4) - (double)((float)widgetBounds.height - (float)(this.getBounds().height / 2) * ((Float)this.scale.value()).floatValue())));
        }
        if (!RoughlyEnoughItemsCoreClient.isLeftMousePressed) {
            this.translate.setAs((Object)new FloatingPoint(((FloatingPoint)this.translate.value()).x + ((FloatingPoint)this.velocity.value()).x, ((FloatingPoint)this.translate.value()).y + ((FloatingPoint)this.velocity.value()).y));
        }
        this.velocity.update((double)delta);
        this.velocity.setTo((Object)new FloatingPoint(ScrollingContainer.handleBounceBack((double)((FloatingPoint)this.velocity.target()).x, (double)0.0, (float)delta, (double)1.0E-4), ScrollingContainer.handleBounceBack((double)((FloatingPoint)this.velocity.target()).y, (double)0.0, (float)delta, (double)1.0E-4)), ConfigObject.getInstance().isReducedMotion() ? 0L : 20L);
        try (CloseableScissors scissors = OverflowWidget.scissor(poseStack, this.bounds);){
            boolean containsMouse = this.bounds.contains(mouseX, mouseY);
            if (containsMouse) {
                super.m_6305_(poseStack, mouseX, mouseY, delta);
            } else {
                super.m_6305_(poseStack, Integer.MAX_VALUE, Integer.MAX_VALUE, delta);
            }
        }
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        return this.getBounds().contains(mouseX, mouseY);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.containsMouse(mouseX, mouseY)) {
            this.scale.setTo((double)((Float)this.scale.target()).floatValue() + amount * (double)-0.2f, ConfigObject.getInstance().isReducedMotion() ? 0L : 300L);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.containsMouse(mouseX, mouseY)) {
            if (button == 0) {
                this.dragging = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.dragging && button == 0) {
            this.dragging = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging && button == 0) {
            double newXTranslate = ((FloatingPoint)this.translate.target()).x;
            double newYTranslate = ((FloatingPoint)this.translate.target()).y;
            this.translate.setAs((Object)new FloatingPoint(newXTranslate += deltaX * this.scale.doubleValue(), newYTranslate += deltaY * this.scale.doubleValue()));
            this.velocity.setAs((Object)new FloatingPoint(deltaX * this.scale.doubleValue(), deltaY * this.scale.doubleValue()));
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }
}

