/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen.collapsible;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.animator.ProgressValueAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.config.collapsible.CollapsibleConfigManager;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.screen.collapsible.CollapsibleEntriesScreen;
import me.shedaniel.rei.impl.client.gui.text.TextTransformations;
import me.shedaniel.rei.impl.client.gui.widget.BatchedEntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class CollapsibleEntryWidget
extends WidgetWithBounds {
    private final boolean custom;
    private final ResourceLocation id;
    private final Component component;
    private final Collection<Slot> stacks;
    private final CollapsibleConfigManager.CollapsibleConfigObject configObject;
    private final ProgressValueAnimator<Boolean> idDrawer = ValueAnimator.ofBoolean();
    private final ProgressValueAnimator<Boolean> modIdDrawer = ValueAnimator.ofBoolean();
    private final Button toggleButton;
    @Nullable
    private final Button deleteButton;
    @Nullable
    private final Button configureButton;
    private final ScrollingContainer scroller = new ScrollingContainer(){

        public Rectangle getBounds() {
            return new Rectangle(CollapsibleEntryWidget.this.x + CollapsibleEntryWidget.this.width / 2 - 8 * CollapsibleEntryWidget.this.rowSize, CollapsibleEntryWidget.this.y + 37, 16 * CollapsibleEntryWidget.this.rowSize, CollapsibleEntryWidget.this.height - 40);
        }

        public int getMaxScrollHeight() {
            return Math.max(0, Mth.m_184652_((int)CollapsibleEntryWidget.this.stacks.size(), (int)CollapsibleEntryWidget.this.rowSize) * 16) + 24;
        }
    };
    private int x;
    private int y;
    private int width;
    private int height;
    private int rowSize;

    public CollapsibleEntryWidget(boolean custom, ResourceLocation id, Component component, Collection<EntryStack<?>> stacks, CollapsibleConfigManager.CollapsibleConfigObject configObject, Runnable markDirty) {
        this.custom = custom;
        this.id = id;
        this.component = component;
        this.stacks = CollectionUtils.map(stacks, stack -> Widgets.createSlot(new Rectangle(0, 0, 16, 16)).entry((EntryStack<?>)stack).disableBackground());
        this.configObject = configObject;
        this.toggleButton = new Button(0, 0, 20, 20, (Component)new TranslatableComponent("text.rei.collapsible.entries.toggle"), button -> {
            if (this.configObject.disabledGroups.contains(this.id)) {
                this.configObject.disabledGroups.remove(this.id);
            } else {
                this.configObject.disabledGroups.add(this.id);
            }
        });
        this.toggleButton.m_93674_(this.font.m_92852_((FormattedText)this.toggleButton.m_6035_()) + 8);
        if (this.custom) {
            this.deleteButton = new Button(0, 0, 20, 20, (Component)new TranslatableComponent("text.rei.collapsible.entries.delete"), button -> {
                this.configObject.customGroups.removeIf(customEntry -> customEntry.id.equals((Object)this.id));
                markDirty.run();
            });
            this.deleteButton.m_93674_(this.font.m_92852_((FormattedText)this.deleteButton.m_6035_()) + 8);
            this.configureButton = new Button(0, 0, 20, 20, Component.m_130674_(null), button -> CollapsibleEntriesScreen.setupCustom(this.id, this.component.getString(), new ArrayList(stacks), this.configObject, markDirty)){

                protected void m_7906_(PoseStack matrices, Minecraft client, int mouseX, int mouseY) {
                    super.m_7906_(matrices, client, mouseX, mouseY);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)InternalTextures.CHEST_GUI_TEXTURE);
                    this.m_93228_(matrices, this.f_93620_ + 3, this.f_93621_ + 3, 0, 0, 14, 14);
                }
            };
        } else {
            this.deleteButton = null;
            this.configureButton = null;
        }
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setWidth(int width) {
        if (this.width != width) {
            this.width = width;
            this.rowSize = Math.max(1, (width - 6) / 16);
            this.height = Math.min(42 + Math.max(Mth.m_184652_((int)this.stacks.size(), (int)this.rowSize) * 16 + 24, 24), 170);
        }
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void m_6305_(PoseStack poses, int mouseX, int mouseY, float delta) {
        Rectangle lineBounds;
        this.scroller.updatePosition(delta);
        this.idDrawer.update((double)delta);
        this.modIdDrawer.update((double)delta);
        Rectangle bounds = this.getBounds();
        this.m_93179_(poses, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), -8947849, -8947849);
        this.m_93179_(poses, bounds.x + 1, bounds.y + 1, bounds.getMaxX() - 1, bounds.getMaxY() - 1, -16777216, -16777216);
        int y = bounds.y + 4;
        if (y + 9 >= 30 && y < this.minecraft.f_91080_.f_96544_) {
            this.renderTextScrolling(poses, this.component, bounds.x + 4, y, bounds.width - 8, -2236963);
        }
        if ((y += 13) + 9 >= 30 && y < this.minecraft.f_91080_.f_96544_) {
            lineBounds = new Rectangle(bounds.x + 4, y, bounds.width - 8, 9);
            this.idDrawer.setTo((Object)lineBounds.contains(mouseX, mouseY), ConfigObject.getInstance().isReducedMotion() ? 0L : 400L);
            try (CloseableScissors scissors = CollapsibleEntryWidget.scissor(poses, lineBounds);){
                poses.m_85836_();
                poses.m_85837_(0.0, -this.idDrawer.progress() * 10.0, 0.0);
                this.font.m_92763_(poses, (Component)new TranslatableComponent("text.rei.collapsible.entries.count", new Object[]{"" + this.stacks.size()}), (float)(bounds.x + 4), (float)y, -5592406);
                boolean enabled = !this.configObject.disabledGroups.contains(this.id);
                TranslatableComponent sideText = new TranslatableComponent("text.rei.collapsible.entries.enabled." + enabled);
                this.font.m_92763_(poses, (Component)sideText, (float)(bounds.getMaxX() - 4 - this.font.m_92852_((FormattedText)sideText)), (float)y, enabled ? -581566635 : -570469035);
                this.renderTextScrolling(poses, (Component)new TextComponent(this.id.toString()), bounds.x + 4, y + 10, bounds.width - 8, -8947849);
                poses.m_85849_();
            }
        }
        if ((y += 10) + 9 >= 30 && y < this.minecraft.f_91080_.f_96544_) {
            lineBounds = new Rectangle(bounds.x + 4, y, bounds.width - 8, 9);
            this.modIdDrawer.setTo((Object)lineBounds.contains(mouseX, mouseY), ConfigObject.getInstance().isReducedMotion() ? 0L : 400L);
            int xo = this.font.m_92763_(poses, (Component)new TranslatableComponent("text.rei.collapsible.entries.source").m_130946_(" "), (float)(bounds.x + 4), (float)y, -5592406);
            try (CloseableScissors scissors = CollapsibleEntryWidget.scissor(poses, lineBounds);){
                poses.m_85836_();
                if (this.custom) {
                    this.renderTextScrolling(poses, TextTransformations.applyRainbow(new TranslatableComponent("text.rei.collapsible.entries.source.custom").m_7532_(), xo - 1, y), xo - 1, y, bounds.getWidth() - 8, -5592406);
                } else {
                    poses.m_85837_(0.0, -this.modIdDrawer.progress() * 10.0, 0.0);
                    this.renderTextScrolling(poses, (Component)new TextComponent(ClientHelper.getInstance().getModFromModId(this.id.m_135827_())), xo - 1, y, bounds.getMaxX() - 4 - (xo - 1), -8947849);
                    this.renderTextScrolling(poses, (Component)new TextComponent(this.id.m_135827_().toString()), xo - 1, y + 10, bounds.getMaxX() - 4 - (xo - 1), -8947849);
                }
                poses.m_85849_();
            }
        }
        this.renderStacks(poses, mouseX, mouseY, delta, bounds, y);
        bounds.y = this.y;
        poses.m_85836_();
        poses.m_85837_(0.0, 0.0, 400.0);
        this.toggleButton.f_93620_ = bounds.getMaxX() - 4 - this.toggleButton.m_5711_();
        this.toggleButton.f_93621_ = bounds.getMaxY() - 4 - this.toggleButton.m_93694_();
        this.toggleButton.m_6305_(poses, mouseX, mouseY, delta);
        if (this.toggleButton.m_5953_((double)mouseX, (double)mouseY)) {
            ScreenOverlayImpl.getInstance().clearTooltips();
        }
        if (this.custom) {
            this.deleteButton.f_93620_ = this.toggleButton.f_93620_ - 2 - this.deleteButton.m_5711_();
            this.deleteButton.f_93621_ = bounds.getMaxY() - 4 - this.deleteButton.m_93694_();
            this.deleteButton.m_6305_(poses, mouseX, mouseY, delta);
            if (this.deleteButton.m_5953_((double)mouseX, (double)mouseY)) {
                ScreenOverlayImpl.getInstance().clearTooltips();
            }
            this.configureButton.f_93620_ = this.deleteButton.f_93620_ - 2 - this.configureButton.m_5711_();
            this.configureButton.f_93621_ = bounds.getMaxY() - 4 - this.configureButton.m_93694_();
            this.configureButton.m_6305_(poses, mouseX, mouseY, delta);
            if (this.configureButton.m_5953_((double)mouseX, (double)mouseY)) {
                ScreenOverlayImpl.getInstance().clearTooltips();
            }
        }
        poses.m_85849_();
    }

    private void renderStacks(PoseStack poses, int mouseX, int mouseY, float delta, Rectangle bounds, int y) {
        poses.m_85836_();
        try (CloseableScissors outerScissors = CollapsibleEntryWidget.scissor(poses, new Rectangle(bounds.x, y, bounds.width, bounds.getMaxY() - 3 - y));){
            y = bounds.y + 37 - this.scroller.scrollAmountInt();
            int x = bounds.getCenterX() - 8 * this.rowSize;
            int xIndex = 0;
            poses.m_85837_(0.0, 0.0, 100.0);
            BatchedEntryRendererManager<EntryWidget> manager = new BatchedEntryRendererManager<EntryWidget>();
            for (Slot stack : this.stacks) {
                if (y + 16 >= 30 && y + 16 >= bounds.y + 37) {
                    stack.getBounds().setBounds(x + 16 * xIndex - 1, y - 1, 18, 18);
                    manager.add((EntryWidget)stack);
                }
                if (++xIndex < this.rowSize) continue;
                xIndex = 0;
                if ((y += 16) < bounds.getMaxY() && y < this.minecraft.f_91080_.f_96544_) continue;
                break;
            }
            try (CloseableScissors scissors = CollapsibleEntryWidget.scissor(poses, new Rectangle(x, bounds.y + 37, 16 * this.rowSize, bounds.getMaxY() - 4 - (bounds.y + 37)));){
                manager.render(poses, mouseX, mouseY, delta);
            }
            poses.m_85837_(0.0, 0.0, 300.0);
            if (this.stacks.size() > this.rowSize * 3) {
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder buffer = tesselator.m_85915_();
                RenderSystem.m_69472_();
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                RenderSystem.m_157427_(GameRenderer::m_172811_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Matrix4f matrix = poses.m_85850_().m_85861_();
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                buffer.m_85982_(matrix, (float)(this.x + 1), (float)(this.y + this.height - 1), 0.0f).m_193479_(-16777216).m_5752_();
                buffer.m_85982_(matrix, (float)(this.x + this.width - 1), (float)(this.y + this.height - 1), 0.0f).m_193479_(-16777216).m_5752_();
                buffer.m_85982_(matrix, (float)(this.x + this.width - 1), (float)(this.y + this.height - 40), 0.0f).m_193479_(0).m_5752_();
                buffer.m_85982_(matrix, (float)(this.x + 1), (float)(this.y + this.height - 40), 0.0f).m_193479_(0).m_5752_();
                tesselator.m_85914_();
                RenderSystem.m_69493_();
                RenderSystem.m_69461_();
            }
        }
        poses.m_85849_();
    }

    private void renderTextScrolling(PoseStack poses, Component text, int x, int y, int width, int color) {
        this.renderTextScrolling(poses, text.m_7532_(), x, y, width, color);
    }

    private void renderTextScrolling(PoseStack poses, FormattedCharSequence text, int x, int y, int width, int color) {
        try (CloseableScissors scissors = CollapsibleEntryWidget.scissor(poses, new Rectangle(x, y, width, y + 9));){
            int textWidth = this.font.m_92724_(text);
            if (textWidth > width) {
                poses.m_85836_();
                float textX = (float)(System.currentTimeMillis() % (long)((textWidth + 10) * textWidth / 3)) / (float)textWidth * 3.0f;
                poses.m_85837_((double)(-textX), 0.0, 0.0);
                this.font.m_92744_(poses, text, (float)(x + width - textWidth - 10), (float)y, color);
                this.font.m_92744_(poses, text, (float)(x + width), (float)y, color);
                poses.m_85849_();
            } else {
                this.font.m_92744_(poses, text, (float)x, (float)y, color);
            }
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.scroller.getMaxScroll() > 0 && this.scroller.getBounds().contains(mouseX, mouseY) && (amount < 0.0 || this.scroller.scrollAmountInt() != 0) && (amount > 0.0 || this.scroller.scrollAmountInt() != this.scroller.getMaxScroll())) {
            this.scroller.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
            return true;
        }
        return false;
    }

    public List<? extends GuiEventListener> m_6702_() {
        if (this.custom) {
            return List.of(this.toggleButton, this.deleteButton, this.configureButton);
        }
        return List.of(this.toggleButton);
    }
}

