/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.performance;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.gui.widget.DynamicElementListWidget;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.modules.entries.ToggleMenuEntry;
import me.shedaniel.rei.impl.client.gui.screen.ScreenWithMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DisplayRegistryInfoScreen
extends ScreenWithMenu {
    private Runnable onClose;
    private ListWidget list;
    private SortType sortType = SortType.ID;

    public DisplayRegistryInfoScreen(Runnable onClose) {
        super((Component)new TranslatableComponent("text.rei.display_registry_analysis"));
        this.onClose = onClose;
    }

    public void m_7856_() {
        MutableComponent backText = new TextComponent("\u21a9 ").m_7220_((Component)new TranslatableComponent("gui.back"));
        this.m_142416_((GuiEventListener)new Button(4, 4, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)backText) + 10, 20, (Component)backText, button -> {
            this.onClose.run();
            this.onClose = null;
        }));
        TranslatableComponent text = new TranslatableComponent("text.rei.sort");
        Rectangle bounds = new Rectangle(this.f_96543_ - 4 - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text) - 10, 4, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text) + 10, 20);
        this.m_142416_((GuiEventListener)new Button(bounds.x, bounds.y, bounds.width, bounds.height, (Component)text, button -> this.setMenu(new Menu(bounds, CollectionUtils.map(SortType.values(), type -> ToggleMenuEntry.of((Component)new TranslatableComponent("text.rei.sort.by", new Object[]{type.name().toLowerCase(Locale.ROOT)}), () -> false, o -> {
            this.closeMenu();
            this.sortType = type;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        })), false))));
        this.list = new ListWidget();
        this.list.addItem(new EntryImpl((Component)new TextComponent("Total Displays"), DisplayRegistry.getInstance().displaySize()));
        this.sort(DisplayRegistry.getInstance().getAll().entrySet().stream()).forEach(entry -> this.list.addItem(new EntryImpl((CategoryIdentifier)entry.getKey(), ((List)entry.getValue()).size())));
        this.m_7787_((GuiEventListener)this.list);
    }

    private Stream<Map.Entry<CategoryIdentifier<?>, List<Display>>> sort(Stream<Map.Entry<CategoryIdentifier<?>, List<Display>>> stream) {
        return switch (this.sortType) {
            default -> throw new IncompatibleClassChangeError();
            case SortType.COUNT -> stream.sorted(Comparator.comparingInt(value -> ((List)value.getValue()).size()).reversed());
            case SortType.ID -> stream.sorted(Comparator.comparing(value -> ((CategoryIdentifier)value.getKey()).toString()));
        };
    }

    @Override
    public void m_6305_(PoseStack poses, int mouseX, int mouseY, float delta) {
        this.m_96626_(0);
        this.list.m_6305_(poses, mouseX, mouseY, delta);
        this.f_96547_.m_92744_(poses, this.f_96539_.m_7532_(), (float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2.0f, 12.0f, -1);
        super.m_6305_(poses, mouseX, mouseY, delta);
    }

    private static enum SortType {
        COUNT,
        ID;

    }

    private class ListWidget
    extends DynamicElementListWidget<ListEntry> {
        public ListWidget() {
            super(DisplayRegistryInfoScreen.this.f_96541_, DisplayRegistryInfoScreen.this.f_96543_, DisplayRegistryInfoScreen.this.f_96544_, 30, DisplayRegistryInfoScreen.this.f_96544_, GuiComponent.f_93096_);
        }

        public int getItemWidth() {
            return this.width;
        }

        public int addItem(ListEntry item) {
            return super.addItem((DynamicEntryListWidget.Entry)item);
        }

        protected int getScrollbarPosition() {
            return this.width - 6;
        }
    }

    public static class EntryImpl
    extends ListEntry {
        private final Component component;
        public final int count;

        public EntryImpl(CategoryIdentifier<?> identifier, int count) {
            this((Component)new TextComponent(identifier.getIdentifier().toString()), count);
        }

        public EntryImpl(Component component, int count) {
            this.component = component;
            this.count = count;
        }

        public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.m_91087_().f_91062_.m_92744_(matrices, this.component.m_7532_(), (float)x + 4.0f, (float)(y + 6), -1);
            FormattedCharSequence rightText = new TranslatableComponent("text.rei.display_registry_analysis.displays", new Object[]{this.count}).m_7532_();
            Minecraft.m_91087_().f_91062_.m_92744_(matrices, rightText, (float)x + (float)entryWidth - 6.0f - 8.0f - (float)Minecraft.m_91087_().f_91062_.m_92724_(rightText), (float)(y + 6), -1);
        }

        public int getItemHeight() {
            return 24;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }
    }

    public static abstract class ListEntry
    extends DynamicElementListWidget.ElementEntry<ListEntry> {
    }
}

