/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.dragging;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.FloatingDimension;
import me.shedaniel.math.FloatingPoint;
import me.shedaniel.math.FloatingRectangle;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCoreClient;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.drag.DraggableBoundsProvider;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponent;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProvider;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentVisitor;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.impl.client.gui.widget.LateRenderable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CurrentDraggingStack
extends Widget
implements LateRenderable,
DraggingContext<Screen> {
    private DraggableComponentProvider<Screen, ?> provider;
    private DraggableComponentVisitor<Screen> visitor;
    @Nullable
    private DraggableEntry entry;
    private final List<RenderBackEntry> backToOriginals = new ArrayList<RenderBackEntry>();
    private final Set<ShapeBounds> bounds = new HashSet<ShapeBounds>();

    public void set(DraggableComponentProvider<Screen, ?> provider, DraggableComponentVisitor<Screen> visitor) {
        this.provider = provider;
        this.visitor = visitor;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        Integer hash = null;
        boolean reducedMotion = ConfigObject.getInstance().isReducedMotion();
        if (this.entry != null) {
            if (!this.entry.dragging) {
                double requiredDistance;
                double yDistance;
                Point startPoint = this.entry.start;
                double xDistance = Math.abs(startPoint.x - mouseX);
                if (xDistance * xDistance + (yDistance = (double)Math.abs(startPoint.y - mouseY)) * yDistance > (requiredDistance = 8.0) * requiredDistance) {
                    this.entry.dragging = true;
                    this.entry.startDragging = Util.m_137550_();
                    this.entry.component.drag();
                }
            }
            if (this.entry.dragging) {
                matrices.m_85836_();
                matrices.m_85837_(0.0, 0.0, 600.0);
                this.entry.point.update((double)delta);
                this.entry.dimension.update((double)delta);
                int width = this.entry.component.getWidth();
                int height = this.entry.component.getHeight();
                Vec2 mouseStartOffset = this.entry.mouseStartOffset;
                this.entry.point.setTo((Object)new FloatingPoint((double)((float)mouseX - mouseStartOffset.f_82470_ * (float)width), (double)((float)mouseY - mouseStartOffset.f_82471_ * (float)height)), reducedMotion ? 0L : 30L);
                this.entry.dimension.setTo((Object)new FloatingDimension((double)width, (double)height), reducedMotion ? 0L : 700L);
                this.entry.component.render(matrices, this.getCurrentBounds(), mouseX, mouseY, delta);
                matrices.m_85849_();
                VoxelShape shape = this.entry.getBoundsProvider().bounds();
                ShapeBounds shapeBounds = new ShapeBounds(shape);
                shapeBounds.alpha.setTo(60, reducedMotion ? 0L : 300L);
                this.bounds.add(shapeBounds);
                hash = shapeBounds.hash;
            }
            if (!RoughlyEnoughItemsCoreClient.isLeftMousePressed) {
                this.drop();
            }
        }
        for (ShapeBounds bound : this.bounds) {
            if (hash != null && hash == bound.hash || (Double)bound.alpha.target() == 0.0) continue;
            bound.alpha.setTo(0, reducedMotion ? 0L : 300L);
        }
        Iterator<Object> iterator = this.bounds.iterator();
        while (iterator.hasNext()) {
            ShapeBounds bounds = iterator.next();
            bounds.update(delta);
            if ((Double)bounds.alpha.target() == 0.0 && (Double)bounds.alpha.value() <= 2.0) {
                iterator.remove();
                continue;
            }
            bounds.shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
                matrices.m_85836_();
                matrices.m_85837_(0.0, 0.0, 500.0);
                this.m_93179_(matrices, (int)x1, (int)y1, (int)x2, (int)y2, 0xFDFF6B | bounds.alpha.intValue() << 24, 0xFDFF6B | bounds.alpha.intValue() << 24);
                matrices.m_85849_();
            });
        }
        iterator = this.backToOriginals.iterator();
        while (iterator.hasNext()) {
            RenderBackEntry renderBackEntry = (RenderBackEntry)iterator.next();
            renderBackEntry.update(delta);
            FloatingRectangle value = (FloatingRectangle)renderBackEntry.bounds.value();
            FloatingRectangle target = (FloatingRectangle)renderBackEntry.bounds.target();
            if (value.width < 2.0 || value.height < 2.0 || Math.abs(value.x - target.x) <= 1.3 && Math.abs(value.y - target.y) <= 1.3 && Math.abs(value.width - target.width) <= 1.0 && Math.abs(value.height - target.height) <= 1.0) {
                iterator.remove();
                continue;
            }
            matrices.m_85836_();
            matrices.m_85837_(0.0, 0.0, 600.0);
            renderBackEntry.component.render(matrices, value.getBounds(), mouseX, mouseY, delta);
            matrices.m_85849_();
        }
    }

    public List<? extends GuiEventListener> m_6702_() {
        return Collections.emptyList();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        this.drop();
        DraggableComponent<?> hoveredStack = this.provider.getHovered(this, mouseX, mouseY);
        if (hoveredStack != null) {
            this.entry = new DraggableEntry(hoveredStack, new Point(mouseX, mouseY));
        }
        return false;
    }

    public boolean m_6348_(double d, double e, int i) {
        if (i != 0) {
            return false;
        }
        this.drop();
        return false;
    }

    public boolean m_7979_(double mouseX1, double mouseY1, int button, double mouseX2, double mouseY2) {
        return button == 0 && this.entry != null && this.entry.dragging;
    }

    public boolean drop() {
        if (this.entry != null && this.entry.dragging) {
            DraggedAcceptorResult result = this.visitor.acceptDragged(this, this.entry.component);
            this.entry.component.release(result);
            this.entry = null;
            return true;
        }
        this.entry = null;
        return false;
    }

    @Override
    public Screen getScreen() {
        return Minecraft.m_91087_().f_91080_;
    }

    @Override
    @Nullable
    public DraggableStack getCurrentStack() {
        DraggableComponent<?> dragged = this.getDragged();
        return dragged instanceof DraggableStack ? (DraggableStack)dragged : null;
    }

    @Override
    @Nullable
    public DraggableComponent<?> getDragged() {
        return this.entry != null && this.entry.dragging ? this.entry.component : null;
    }

    @Override
    @Nullable
    public Point getCurrentPosition() {
        if (!this.isDraggingComponent()) {
            return null;
        }
        Vec2 mouseStartOffset = this.entry.mouseStartOffset;
        FloatingPoint point = (FloatingPoint)this.entry.point.value();
        FloatingDimension dimension = (FloatingDimension)this.entry.dimension.value();
        return new Point(point.x + (double)mouseStartOffset.f_82470_ * dimension.width, point.y + (double)mouseStartOffset.f_82471_ * dimension.height);
    }

    @Override
    @Nullable
    public Rectangle getCurrentBounds() {
        if (!this.isDraggingComponent()) {
            return null;
        }
        FloatingPoint point = (FloatingPoint)this.entry.point.value();
        FloatingDimension dimension = (FloatingDimension)this.entry.dimension.value();
        return new Rectangle(point.x - dimension.width / 2.0, point.y - dimension.height / 2.0, dimension.width, dimension.height);
    }

    @Override
    public void renderBack(DraggableComponent<?> component, Point initialPosition, Supplier<Point> position) {
        if (ConfigObject.getInstance().isReducedMotion()) {
            return;
        }
        int width = component.getWidth();
        int height = component.getHeight();
        this.backToOriginals.add(new RenderBackEntry(component, new Rectangle(initialPosition.x - width / 2, initialPosition.y - height / 2, width, height), () -> {
            Point point = (Point)position.get();
            return new Rectangle(point.x, point.y, width, height);
        }));
    }

    @Override
    public void renderBack(DraggableComponent<?> component, Rectangle initialPosition, Supplier<Rectangle> bounds) {
        if (ConfigObject.getInstance().isReducedMotion()) {
            return;
        }
        this.backToOriginals.add(new RenderBackEntry(component, initialPosition, bounds));
    }

    private class DraggableEntry {
        private final DraggableComponent<?> component;
        private final Point start;
        private long startDragging = -1L;
        private final ValueAnimator<FloatingPoint> point;
        private final ValueAnimator<FloatingDimension> dimension;
        private final Vec2 mouseStartOffset;
        private boolean dragging = false;
        private DraggableBoundsProvider boundsProvider;

        private DraggableEntry(DraggableComponent<?> component, Point start) {
            this.component = component;
            this.start = start;
            FloatingRectangle floatingBounds = component.getOriginBounds(start).getFloatingBounds();
            this.point = ValueAnimator.ofFloatingPoint().setAs((Object)new FloatingPoint(floatingBounds.getCenterX(), floatingBounds.getCenterY()));
            this.dimension = ValueAnimator.ofFloatingDimension().setAs((Object)new FloatingDimension(floatingBounds.width, floatingBounds.height));
            this.mouseStartOffset = new Vec2((float)((double)start.x - ((FloatingPoint)this.point.value()).x) / (float)((FloatingDimension)this.dimension.value()).width, (float)((double)start.y - ((FloatingPoint)this.point.value()).y) / (float)((FloatingDimension)this.dimension.value()).height);
        }

        public DraggableBoundsProvider getBoundsProvider() {
            if (this.boundsProvider == null) {
                this.boundsProvider = DraggableBoundsProvider.concat(CurrentDraggingStack.this.visitor.getDraggableAcceptingBounds(CurrentDraggingStack.this, this.component).toList());
            }
            return this.boundsProvider;
        }
    }

    private static class ShapeBounds {
        private VoxelShape shape;
        private NumberAnimator<Double> alpha;
        private int hash;

        public ShapeBounds(VoxelShape shape) {
            this.shape = shape;
            this.alpha = ValueAnimator.ofDouble((double)0.0);
            this.hash = shape.m_83299_().hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ShapeBounds)) {
                return false;
            }
            ShapeBounds shapeBounds = (ShapeBounds)o;
            return this.hash == shapeBounds.hash;
        }

        public int hashCode() {
            return this.hash;
        }

        public void update(double delta) {
            this.alpha.update(delta);
        }
    }

    private static class RenderBackEntry {
        private final DraggableComponent<?> component;
        private final Supplier<Rectangle> position;
        private ValueAnimator<FloatingRectangle> bounds = ValueAnimator.ofFloatingRectangle();
        private int lastDestination = -1;

        public RenderBackEntry(DraggableComponent<?> component, Rectangle initialPosition, Supplier<Rectangle> position) {
            this.component = component;
            this.bounds.setAs((Object)new FloatingRectangle(initialPosition));
            this.position = position;
        }

        public Rectangle getPosition() {
            return this.position.get();
        }

        public void update(double delta) {
            this.bounds.update(delta);
            this.bounds.setTo((Object)new FloatingRectangle(this.getPosition()), ConfigObject.getInstance().isReducedMotion() ? 0L : 200L);
        }
    }
}

