/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.config.components;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.util.MatrixUtils;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.config.ConfigAccess;
import me.shedaniel.rei.impl.client.gui.config.REIConfigScreen;
import me.shedaniel.rei.impl.client.gui.config.options.CompositeOption;
import me.shedaniel.rei.impl.client.gui.config.options.ConfigUtils;
import me.shedaniel.rei.impl.client.gui.config.options.OptionValueEntry;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.modules.entries.ToggleMenuEntry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class ConfigOptionValueWidget {
    public static <T> WidgetWithBounds create(ConfigAccess access, CompositeOption<T> option, int width) {
        Font font = Minecraft.m_91087_().f_91062_;
        Component[] text = new Component[]{null};
        Consumer<Component> setText = t -> {
            if (access.getFocusedKeycode() == option) {
                text[0] = ConfigUtils.literal("> ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)t.m_6881_().m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)ConfigUtils.literal(" <").m_130940_(ChatFormatting.YELLOW));
            } else if (!(option.getEntry() instanceof OptionValueEntry.Configure) && access.get(option).equals(Objects.requireNonNullElseGet(option.getDefaultValue(), () -> access.getDefault(option)))) {
                text[0] = ConfigUtils.translatable("config.rei.value.default", t);
                if (font.m_92852_((FormattedText)text[0]) > width) {
                    int trimTo = width - font.m_92895_("...") - (font.m_92852_((FormattedText)text[0]) - font.m_92852_((FormattedText)t));
                    FormattedText trimmed = font.m_92854_((FormattedText)t, trimTo);
                    FormattedText composite = FormattedText.m_130773_((FormattedText[])new FormattedText[]{trimmed, ConfigUtils.literal("...")});
                    text[0] = ConfigUtils.literal(composite.getString());
                    text[0] = ConfigUtils.translatable("config.rei.value.default", text[0]);
                }
            } else if (font.m_92852_((FormattedText)t) > width) {
                int trimTo = width - font.m_92895_("...");
                FormattedText trimmed = font.m_92854_((FormattedText)t, trimTo);
                FormattedText composite = FormattedText.m_130773_((FormattedText[])new FormattedText[]{trimmed, ConfigUtils.literal("...")});
                text[0] = ConfigUtils.literal(composite.getString());
            } else {
                text[0] = t;
            }
        };
        setText.accept(option.getEntry().getOption(access.get(option)));
        Matrix4f[] matrix = new Matrix4f[]{new Matrix4f()};
        Label label = Widgets.createLabel(new Point(), text[0]).rightAligned().color(-2039584).hoveredColor(-2039584).onRender((poses, l) -> {
            if (MatrixUtils.transform(matrix[0], l.getBounds()).contains(PointHelper.ofMouse())) {
                l.setMessage((FormattedText)text[0].m_6881_().m_130940_(ChatFormatting.UNDERLINE));
            } else {
                l.setMessage((FormattedText)text[0]);
            }
        });
        OptionValueEntry<T> optionValueEntry = option.getEntry();
        if (optionValueEntry instanceof OptionValueEntry.Selection) {
            OptionValueEntry.Selection selection = (OptionValueEntry.Selection)optionValueEntry;
            ConfigOptionValueWidget.applySelection(access, option, selection, label, setText, matrix);
        } else if (access.get(option) instanceof ModifierKeyCode) {
            ConfigOptionValueWidget.applyKeycode(access, option, label, setText, matrix);
        } else if (option.getEntry() instanceof OptionValueEntry.Configure) {
            label.clickable().onClick($ -> ((OptionValueEntry.Configure)option.getEntry()).configure(access, option, () -> {
                Minecraft.m_91087_().m_91152_((Screen)access);
                setText.accept(option.getEntry().getOption(access.get(option)));
            }));
        }
        return Widgets.concatWithBounds(() -> new Rectangle(-label.getBounds().width, 0, label.getBounds().width + 8, 14), label, Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            matrix[0] = matrices.m_85850_().m_85861_();
        }), Widgets.withTranslate(Widgets.createTexturedWidget(new ResourceLocation("roughlyenoughitems:textures/gui/config/selector.png"), new Rectangle(1, 1, 4, 6), 0.0f, 0.0f, 1, 1, 1, 1), 0.0, 0.5, 0.0));
    }

    private static <T> void applySelection(ConfigAccess access, CompositeOption<T> option, OptionValueEntry.Selection<T> selection, Label label, Consumer<Component> setText, Matrix4f[] matrix) {
        int noOfOptions = selection.getOptions().size();
        if (noOfOptions == 2) {
            label.clickable().onClick($ -> {
                access.set(option, selection.getOptions().get((selection.getOptions().indexOf(access.get(option)) + 1) % 2));
                setText.accept(selection.getOption(access.get(option)));
            });
        } else if (noOfOptions >= 2) {
            label.clickable().onClick($ -> {
                Menu menu = new Menu(MatrixUtils.transform(matrix[0], label.getBounds()), CollectionUtils.map(selection.getOptions(), opt -> {
                    Component selectionOption = selection.getOption(opt);
                    if (opt.equals(access.getDefault(option))) {
                        selectionOption = ConfigUtils.translatable("config.rei.value.default", selectionOption);
                    }
                    return ToggleMenuEntry.of(selectionOption, () -> false, o -> {
                        ((REIConfigScreen)Minecraft.m_91087_().f_91080_).closeMenu();
                        access.set(option, opt);
                        setText.accept(selection.getOption(opt));
                    });
                }), false);
                access.closeMenu();
                access.openMenu(menu);
            });
        }
    }

    private static <T> void applyKeycode(ConfigAccess access, CompositeOption<T> option, Label label, Consumer<Component> setText, Matrix4f[] matrix) {
        label.clickable().onClick($ -> {
            access.closeMenu();
            access.focusKeycode(option);
        });
        BiConsumer<PoseStack, Label> render = label.getOnRender();
        label.onRender((poses, $) -> {
            render.accept((PoseStack)poses, (Label)$);
            setText.accept(((ModifierKeyCode)access.get(option)).getLocalizedName());
        });
    }
}

