/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config.entries;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.shedaniel.clothconfig2.gui.widget.DynamicElementListWidget;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class ConfigureCategoriesScreen
extends Screen {
    private final Map<CategoryIdentifier<?>, Boolean> filteringQuickCraftCategories;
    private final Set<CategoryIdentifier<?>> hiddenCategories;
    private final List<CategoryIdentifier<?>> categoryOrdering;
    private ListWidget listWidget;
    public Runnable editedSink = () -> {};
    public Screen parent;

    public ConfigureCategoriesScreen(Map<CategoryIdentifier<?>, Boolean> filteringQuickCraftCategories, Set<CategoryIdentifier<?>> hiddenCategories, List<CategoryIdentifier<?>> categoryOrdering) {
        super((Component)new TranslatableComponent("config.roughlyenoughitems.configureCategories.title"));
        this.filteringQuickCraftCategories = filteringQuickCraftCategories;
        this.hiddenCategories = hiddenCategories;
        this.categoryOrdering = categoryOrdering;
        for (CategoryRegistry.CategoryConfiguration configuration : CategoryRegistry.getInstance()) {
            if (this.categoryOrdering.contains(configuration.getCategoryIdentifier())) continue;
            this.categoryOrdering.add(configuration.getCategoryIdentifier());
        }
    }

    public Map<CategoryIdentifier<?>, Boolean> getFilteringQuickCraftCategories() {
        return this.filteringQuickCraftCategories;
    }

    public Set<CategoryIdentifier<?>> getHiddenCategories() {
        return this.hiddenCategories;
    }

    public List<CategoryIdentifier<?>> getCategoryOrdering() {
        return this.categoryOrdering;
    }

    public void m_7856_() {
        super.m_7856_();
        MutableComponent backText = new TextComponent("\u21a9 ").m_7220_((Component)new TranslatableComponent("gui.back"));
        this.m_142416_((GuiEventListener)new Button(4, 4, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)backText) + 10, 20, (Component)backText, button -> {
            this.f_96541_.m_91152_(this.parent);
            this.parent = null;
        }));
        this.listWidget = (ListWidget)this.m_7787_((GuiEventListener)new ListWidget(this.f_96541_, this.f_96543_, this.f_96544_, 30, this.f_96544_, f_93096_));
        this.resetListEntries();
    }

    public void resetListEntries() {
        this.listWidget.m_6702_().clear();
        ArrayList configurations = new ArrayList(CategoryRegistry.getInstance().stream().toList());
        configurations.sort(Comparator.comparingInt(o -> {
            int indexOf = this.categoryOrdering.indexOf(o.getCategoryIdentifier());
            return indexOf == -1 ? Integer.MAX_VALUE : indexOf;
        }));
        for (CategoryRegistry.CategoryConfiguration categoryConfiguration : configurations) {
            this.listWidget.addItem(new DefaultListEntry(categoryConfiguration));
        }
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.listWidget.m_6305_(matrices, mouseX, mouseY, delta);
        super.m_6305_(matrices, mouseX, mouseY, delta);
        this.f_96547_.m_92744_(matrices, this.f_96539_.m_7532_(), (float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2.0f, 12.0f, -1);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    private static class ListWidget
    extends DynamicElementListWidget<ListEntry> {
        private boolean inFocus;

        public ListWidget(Minecraft client, int width, int height, int top, int bottom, ResourceLocation backgroundLocation) {
            super(client, width, height, top, bottom, backgroundLocation);
        }

        public boolean m_5755_(boolean lookForwards) {
            if (!this.inFocus && this.getItemCount() == 0) {
                return false;
            }
            boolean bl = this.inFocus = !this.inFocus;
            if (this.inFocus && this.getSelectedItem() == null && this.getItemCount() > 0) {
                this.moveSelection(1);
            } else if (this.inFocus && this.getSelectedItem() != null) {
                this.getSelectedItem();
            }
            return this.inFocus;
        }

        protected boolean isSelected(int index) {
            return false;
        }

        public ListEntry getSelectedItem() {
            return null;
        }

        protected int addItem(ListEntry item) {
            return super.addItem((DynamicEntryListWidget.Entry)item);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (super.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            ListEntry item = (ListEntry)this.getItemAtPosition(mouseX, mouseY);
            if (item != null) {
                this.client.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                this.selectItem((DynamicEntryListWidget.Entry)item);
                this.m_7522_((GuiEventListener)item);
                this.m_7897_(true);
                return true;
            }
            return false;
        }

        public int getItemWidth() {
            return this.width - 40;
        }

        protected int getScrollbarPosition() {
            return this.width - 14;
        }
    }

    private class DefaultListEntry
    extends ListEntry {
        private final Label visibilityToggleButton;
        private final Label quickCraftToggleButton;
        private final Button upButton;
        private final Button downButton;
        private final CategoryRegistry.CategoryConfiguration<?> configuration;

        public DefaultListEntry(CategoryRegistry.CategoryConfiguration<?> configuration) {
            this.configuration = configuration;
            TranslatableComponent toggleText = new TranslatableComponent("config.roughlyenoughitems.filtering.filteringQuickCraftCategories.configure.toggle");
            this.visibilityToggleButton = Widgets.createClickableLabel(new Point(), (Component)toggleText, $ -> {
                boolean enabled;
                boolean bl = enabled = !ConfigureCategoriesScreen.this.hiddenCategories.contains(configuration.getCategoryIdentifier());
                if (enabled) {
                    ConfigureCategoriesScreen.this.hiddenCategories.add(configuration.getCategoryIdentifier());
                } else {
                    ConfigureCategoriesScreen.this.hiddenCategories.remove(configuration.getCategoryIdentifier());
                }
                ConfigureCategoriesScreen.this.editedSink.run();
            }).leftAligned();
            this.quickCraftToggleButton = Widgets.createClickableLabel(new Point(), (Component)toggleText, $ -> {
                boolean quickCraftingEnabledByDefault = configuration.isQuickCraftingEnabledByDefault();
                boolean enabled = ConfigureCategoriesScreen.this.filteringQuickCraftCategories.getOrDefault(configuration.getCategoryIdentifier(), quickCraftingEnabledByDefault);
                if (enabled) {
                    if (!quickCraftingEnabledByDefault) {
                        ConfigureCategoriesScreen.this.filteringQuickCraftCategories.remove(configuration.getCategoryIdentifier());
                    } else {
                        ConfigureCategoriesScreen.this.filteringQuickCraftCategories.put(configuration.getCategoryIdentifier(), false);
                    }
                } else if (quickCraftingEnabledByDefault) {
                    ConfigureCategoriesScreen.this.filteringQuickCraftCategories.remove(configuration.getCategoryIdentifier());
                } else {
                    ConfigureCategoriesScreen.this.filteringQuickCraftCategories.put(configuration.getCategoryIdentifier(), true);
                }
                ConfigureCategoriesScreen.this.editedSink.run();
            }).leftAligned();
            this.upButton = new Button(0, 0, 20, 20, (Component)new TextComponent("\u2191"), button -> {
                int index = ConfigureCategoriesScreen.this.categoryOrdering.indexOf(configuration.getCategoryIdentifier());
                if (index > 0) {
                    ConfigureCategoriesScreen.this.categoryOrdering.remove(index);
                    ConfigureCategoriesScreen.this.categoryOrdering.add(index - 1, configuration.getCategoryIdentifier());
                    ConfigureCategoriesScreen.this.editedSink.run();
                    ConfigureCategoriesScreen.this.resetListEntries();
                }
            });
            this.downButton = new Button(0, 0, 20, 20, (Component)new TextComponent("\u2193"), button -> {
                int index = ConfigureCategoriesScreen.this.categoryOrdering.indexOf(configuration.getCategoryIdentifier());
                if (index < ConfigureCategoriesScreen.this.categoryOrdering.size() - 1) {
                    ConfigureCategoriesScreen.this.categoryOrdering.remove(index);
                    ConfigureCategoriesScreen.this.categoryOrdering.add(index + 1, configuration.getCategoryIdentifier());
                    ConfigureCategoriesScreen.this.editedSink.run();
                    ConfigureCategoriesScreen.this.resetListEntries();
                }
            });
            this.upButton.f_93623_ = ConfigureCategoriesScreen.this.categoryOrdering.indexOf(configuration.getCategoryIdentifier()) > 0;
            this.downButton.f_93623_ = ConfigureCategoriesScreen.this.categoryOrdering.indexOf(configuration.getCategoryIdentifier()) < ConfigureCategoriesScreen.this.categoryOrdering.size() - 1;
        }

        public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            if (y + entryHeight < 0 || y > ConfigureCategoriesScreen.this.f_96544_) {
                return;
            }
            Minecraft client = Minecraft.m_91087_();
            matrices.m_85836_();
            matrices.m_85837_(0.0, 0.0, 100.0);
            this.configuration.getCategory().getIcon().render(matrices, new Rectangle(x + 2, y, 16, 16), mouseY, mouseY, delta);
            matrices.m_85849_();
            int xPos = x + 22;
            Component title = this.configuration.getCategory().getTitle();
            int i = client.f_91062_.m_92852_((FormattedText)title);
            if (i > entryWidth - 28) {
                FormattedText titleTrimmed = FormattedText.m_130773_((FormattedText[])new FormattedText[]{client.f_91062_.m_92854_((FormattedText)title, entryWidth - 28 - client.f_91062_.m_92895_("...")), FormattedText.m_130775_((String)"...")});
                client.f_91062_.m_92744_(matrices, Language.m_128107_().m_5536_(titleTrimmed), (float)(x + 2), (float)(y + 1), 0xFFFFFF);
            } else {
                client.f_91062_.m_92744_(matrices, title.m_7532_(), (float)xPos, (float)(y + 1), 0xFFFFFF);
            }
            MutableComponent id = new TextComponent(this.configuration.getCategoryIdentifier().toString()).m_130940_(ChatFormatting.DARK_GRAY);
            i = client.f_91062_.m_92852_((FormattedText)id);
            if (i > entryWidth - 28) {
                FormattedText idTrimmed = FormattedText.m_130773_((FormattedText[])new FormattedText[]{client.f_91062_.m_92854_((FormattedText)id, entryWidth - 28 - client.f_91062_.m_92895_("...")), FormattedText.m_130775_((String)"...")});
                client.f_91062_.m_92744_(matrices, Language.m_128107_().m_5536_(idTrimmed), (float)(x + 2), (float)(y + 12), 0x808080);
            } else {
                client.f_91062_.m_92744_(matrices, id.m_7532_(), (float)xPos, (float)(y + 12), 0x808080);
            }
            boolean shown = !ConfigureCategoriesScreen.this.hiddenCategories.contains(this.configuration.getCategoryIdentifier());
            MutableComponent subtitle = new TranslatableComponent("config.roughlyenoughitems.configureCategories.visibility." + shown).m_130940_(shown ? ChatFormatting.GREEN : ChatFormatting.RED);
            int i2 = client.f_91062_.m_92744_(matrices, subtitle.m_7532_(), (float)xPos, (float)(y + 22), 0x808080);
            this.visibilityToggleButton.getPoint().setLocation((double)(i2 + 3), (double)(y + 22));
            this.visibilityToggleButton.m_6305_(matrices, mouseX, mouseY, delta);
            if (shown) {
                subtitle = new TranslatableComponent("config.roughlyenoughitems.filtering.filteringQuickCraftCategories.configure." + ConfigureCategoriesScreen.this.filteringQuickCraftCategories.getOrDefault(this.configuration.getCategoryIdentifier(), this.configuration.isQuickCraftingEnabledByDefault())).m_130940_(ChatFormatting.GRAY);
                i2 = client.f_91062_.m_92744_(matrices, subtitle.m_7532_(), (float)xPos, (float)(y + 32), 0x808080);
                this.quickCraftToggleButton.getPoint().setLocation((double)(i2 + 3), (double)(y + 32));
                this.quickCraftToggleButton.m_6305_(matrices, mouseX, mouseY, delta);
            } else {
                this.quickCraftToggleButton.getPoint().setLocation(-12390.0, -12390.0);
            }
            this.upButton.f_93620_ = x + entryWidth - 20;
            this.upButton.f_93621_ = y + entryHeight / 2 - 21;
            this.upButton.m_6305_(matrices, mouseX, mouseY, delta);
            this.downButton.f_93620_ = x + entryWidth - 20;
            this.downButton.f_93621_ = y + entryHeight / 2 + 1;
            this.downButton.m_6305_(matrices, mouseX, mouseY, delta);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of(this.visibilityToggleButton, this.quickCraftToggleButton, this.upButton, this.downButton);
        }

        public List<? extends NarratableEntry> narratables() {
            return List.of();
        }
    }

    private static abstract class ListEntry
    extends DynamicElementListWidget.ElementEntry<ListEntry> {
        private ListEntry() {
        }

        public int getItemHeight() {
            return 45;
        }

        public boolean m_5755_(boolean lookForwards) {
            return false;
        }
    }
}

