/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client;

import com.google.common.base.Suppliers;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.DisplayScreenType;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.api.common.util.FormattingUtils;
import me.shedaniel.rei.impl.ClientInternals;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.screen.AbstractDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.screen.CompositeDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.screen.DefaultDisplayViewingScreen;
import me.shedaniel.rei.impl.client.view.ViewsImpl;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class ClientHelperImpl
implements ClientHelper {
    @ApiStatus.Internal
    public final LazyLoadedValue<Boolean> isAprilFools = new LazyLoadedValue(() -> {
        try {
            LocalDateTime now = LocalDateTime.now();
            return now.getMonthValue() == 4 && now.getDayOfMonth() == 1;
        }
        catch (Throwable throwable) {
            return false;
        }
    });
    private final Map<String, String> modNameCache = new HashMap<String, String>(){
        {
            this.put("minecraft", "Minecraft");
            this.put("c", "Global");
            this.put("global", "Global");
        }
    };

    @ApiStatus.Internal
    public static ClientHelperImpl getInstance() {
        return (ClientHelperImpl)ClientHelper.getInstance();
    }

    public boolean hasPermissionToUsePackets() {
        try {
            Minecraft.m_91087_().m_91403_().m_105137_().m_6761_(0);
            return this.hasOperatorPermission() && this.canUsePackets();
        }
        catch (NullPointerException e) {
            return true;
        }
    }

    public boolean hasOperatorPermission() {
        try {
            return Minecraft.m_91087_().m_91403_().m_105137_().m_6761_(1);
        }
        catch (NullPointerException e) {
            return true;
        }
    }

    public boolean canUsePackets() {
        return NetworkManager.canServerReceive((ResourceLocation)RoughlyEnoughItemsNetwork.CREATE_ITEMS_PACKET) && NetworkManager.canServerReceive((ResourceLocation)RoughlyEnoughItemsNetwork.CREATE_ITEMS_GRAB_PACKET) && NetworkManager.canServerReceive((ResourceLocation)RoughlyEnoughItemsNetwork.DELETE_ITEMS_PACKET);
    }

    public boolean canUseHotbarPackets() {
        return NetworkManager.canServerReceive((ResourceLocation)RoughlyEnoughItemsNetwork.CREATE_ITEMS_HOTBAR_PACKET);
    }

    public boolean canDeleteItems() {
        return this.hasPermissionToUsePackets() || Minecraft.m_91087_().f_91072_.m_105290_();
    }

    @Override
    public void appendModIdToTooltips(Tooltip components, String modId) {
        String modName = ClientHelper.getInstance().getModFromModId(modId);
        if (this.preserveModId(components, modName)) {
            return;
        }
        int i = 0;
        Iterator<Tooltip.Entry> iterator = components.entries().iterator();
        while (iterator.hasNext()) {
            Tooltip.Entry entry = iterator.next();
            if (!entry.isText() || i++ == 0 || !FormattingUtils.stripFormatting(entry.getAsText().getString()).equalsIgnoreCase(modName)) continue;
            iterator.remove();
        }
        components.add(ClientHelper.getInstance().getFormattedModFromModId(modId));
    }

    private boolean preserveModId(Tooltip components, String modName) {
        if (components.entries().isEmpty()) {
            return false;
        }
        Tooltip.Entry lastEntry = components.entries().get(components.entries().size() - 1);
        if (!lastEntry.isText()) {
            return false;
        }
        return FormattingUtils.stripFormatting(lastEntry.getAsText().getString()).equalsIgnoreCase(modName);
    }

    @Override
    public String getModFromModId(String modId) {
        if (modId == null) {
            return "";
        }
        String any = this.modNameCache.getOrDefault(modId, null);
        if (any != null) {
            return any;
        }
        if (Platform.isModLoaded((String)modId)) {
            String modName = Platform.getMod((String)modId).getName();
            this.modNameCache.put(modId, modName);
            return modName;
        }
        return modId;
    }

    @Override
    public boolean isCheating() {
        return ConfigObject.getInstance().isCheating();
    }

    @Override
    public void setCheating(boolean cheating) {
        ConfigObject.getInstance().setCheating(cheating);
        ConfigManager.getInstance().saveConfig();
    }

    @Override
    public void sendDeletePacket() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen inventoryScreen = (CreativeModeInventoryScreen)screen;
            Minecraft.m_91087_().f_91074_.f_36096_.m_142503_(ItemStack.f_41583_);
            inventoryScreen.f_97738_ = false;
            return;
        }
        NetworkManager.sendToServer((ResourceLocation)RoughlyEnoughItemsNetwork.DELETE_ITEMS_PACKET, (FriendlyByteBuf)new FriendlyByteBuf(Unpooled.buffer()));
        screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            containerScreen.f_97738_ = false;
        }
    }

    @Override
    public boolean tryCheatingEntry(EntryStack<?> e) {
        if (e.getType() != VanillaEntryTypes.ITEM) {
            return false;
        }
        EntryStack<?> entry = e;
        if (Minecraft.m_91087_().f_91074_ == null) {
            return false;
        }
        if (Minecraft.m_91087_().f_91074_.m_150109_() == null) {
            return false;
        }
        ItemStack cheatedStack = ((ItemStack)entry.getValue()).m_41777_();
        if (ConfigObject.getInstance().isGrabbingItems() && Minecraft.m_91087_().f_91080_ instanceof CreativeModeInventoryScreen) {
            AbstractContainerMenu menu = Minecraft.m_91087_().f_91074_.f_36096_;
            EntryStack<?> stack = entry.copy();
            if (!menu.m_142621_().m_41619_() && EntryStacks.equalsExact(EntryStacks.of(menu.m_142621_()), stack)) {
                ((ItemStack)stack.getValue()).m_41764_(Mth.m_14045_((int)(((ItemStack)stack.getValue()).m_41613_() + menu.m_142621_().m_41613_()), (int)1, (int)((ItemStack)stack.getValue()).m_41741_()));
            } else if (!menu.m_142621_().m_41619_()) {
                return false;
            }
            menu.m_142503_(((ItemStack)stack.getValue()).m_41777_());
            return true;
        }
        if (ClientHelperImpl.getInstance().canUsePackets()) {
            AbstractContainerMenu menu = Minecraft.m_91087_().f_91074_.f_36096_;
            EntryStack<?> stack = entry.copy();
            if (!menu.m_142621_().m_41619_() && !EntryStacks.equalsExact(EntryStacks.of(menu.m_142621_()), stack)) {
                return false;
            }
            try {
                NetworkManager.sendToServer((ResourceLocation)(ConfigObject.getInstance().isGrabbingItems() ? RoughlyEnoughItemsNetwork.CREATE_ITEMS_GRAB_PACKET : RoughlyEnoughItemsNetwork.CREATE_ITEMS_PACKET), (FriendlyByteBuf)new FriendlyByteBuf(Unpooled.buffer()).m_130055_(cheatedStack));
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        ResourceLocation identifier = entry.getIdentifier();
        if (identifier == null) {
            return false;
        }
        String tagMessage = cheatedStack.m_41777_().m_41783_() != null && !cheatedStack.m_41777_().m_41783_().m_128456_() ? cheatedStack.m_41777_().m_41783_().m_7916_() : "";
        String og = cheatedStack.m_41613_() == 1 ? ConfigObject.getInstance().getGiveCommand().replaceAll(" \\{count}", "") : ConfigObject.getInstance().getGiveCommand();
        String madeUpCommand = og.replaceAll("\\{player_name}", Minecraft.m_91087_().f_91074_.m_6302_()).replaceAll("\\{item_name}", identifier.m_135815_()).replaceAll("\\{item_identifier}", identifier.toString()).replaceAll("\\{nbt}", tagMessage).replaceAll("\\{count}", String.valueOf(cheatedStack.m_41613_()));
        if (madeUpCommand.length() > 256) {
            madeUpCommand = og.replaceAll("\\{player_name}", Minecraft.m_91087_().f_91074_.m_6302_()).replaceAll("\\{item_name}", identifier.m_135815_()).replaceAll("\\{item_identifier}", identifier.toString()).replaceAll("\\{nbt}", "").replaceAll("\\{count}", String.valueOf(cheatedStack.m_41613_()));
            Minecraft.m_91087_().f_91074_.m_5661_((Component)new TranslatableComponent("text.rei.too_long_nbt"), false);
        }
        Minecraft.m_91087_().f_91074_.m_108739_(madeUpCommand);
        return true;
    }

    @Override
    public boolean tryCheatingEntryTo(EntryStack<?> e, int hotbarSlotId) {
        EntryStack<?> stack;
        AbstractContainerMenu menu;
        if (e.getType() != VanillaEntryTypes.ITEM) {
            return false;
        }
        EntryStack<?> entry = e;
        if (Minecraft.m_91087_().f_91074_ == null) {
            return false;
        }
        if (Minecraft.m_91087_().f_91074_.m_150109_() == null) {
            return false;
        }
        if (Minecraft.m_91087_().f_91072_ != null && Minecraft.m_91087_().f_91080_ instanceof CreativeModeInventoryScreen) {
            menu = Minecraft.m_91087_().f_91074_.f_36096_;
            stack = entry.copy();
            if (menu.m_142621_().m_41619_()) {
                Minecraft.m_91087_().f_91074_.m_150109_().m_6836_(hotbarSlotId, ((ItemStack)stack.getValue()).m_41777_());
                Minecraft.m_91087_().f_91074_.f_36095_.m_38946_();
                return true;
            }
        }
        if (ClientHelperImpl.getInstance().canUseHotbarPackets()) {
            menu = Minecraft.m_91087_().f_91074_.f_36096_;
            stack = entry.copy();
            if (!menu.m_142621_().m_41619_()) {
                return false;
            }
            try {
                NetworkManager.sendToServer((ResourceLocation)RoughlyEnoughItemsNetwork.CREATE_ITEMS_HOTBAR_PACKET, (FriendlyByteBuf)new FriendlyByteBuf(Unpooled.buffer()).m_130055_(((ItemStack)stack.getValue()).m_41777_()).m_130130_(hotbarSlotId));
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    @ApiStatus.Internal
    public Long2LongMap _getInventoryItemsTypes() {
        EntryDefinition<ItemStack> definition;
        try {
            definition = VanillaEntryTypes.ITEM.getDefinition();
        }
        catch (NullPointerException e) {
            return Long2LongMaps.EMPTY_MAP;
        }
        Long2LongOpenHashMap map = new Long2LongOpenHashMap();
        for (NonNullList compartment : Minecraft.m_91087_().f_91074_.m_150109_().f_35979_) {
            for (ItemStack stack : compartment) {
                long hash = definition.hash(null, stack, ComparisonContext.FUZZY);
                long newCount = map.getOrDefault(hash, 0L) + (long)Math.max(0, stack.m_41613_());
                map.put(hash, newCount);
            }
        }
        return map;
    }

    @ApiStatus.Internal
    public Long2LongMap _getContainerItemsTypes() {
        EntryDefinition<ItemStack> definition;
        try {
            definition = VanillaEntryTypes.ITEM.getDefinition();
        }
        catch (NullPointerException e) {
            return Long2LongMaps.EMPTY_MAP;
        }
        Long2LongOpenHashMap map = new Long2LongOpenHashMap();
        AbstractContainerMenu menu = Minecraft.m_91087_().f_91074_.f_36096_;
        if (menu != null) {
            for (Slot slot : menu.f_38839_) {
                ItemStack stack = slot.m_7993_();
                if (stack.m_41619_()) continue;
                long hash = definition.hash(null, stack, ComparisonContext.FUZZY);
                long newCount = map.getOrDefault(hash, 0L) + (long)Math.max(0, stack.m_41613_());
                map.put(hash, newCount);
            }
        }
        return map;
    }

    @ApiStatus.Internal
    public void openDisplayViewingScreen(Map<DisplayCategory<?>, List<DisplaySpec>> map, @Nullable CategoryIdentifier<?> category, List<EntryStack<?>> ingredientNotice, List<EntryStack<?>> resultNotice) {
        LegacyWrapperViewSearchBuilder builder = new LegacyWrapperViewSearchBuilder(map);
        for (EntryStack<?> stack : ingredientNotice) {
            builder.addInputNotice(stack);
        }
        for (EntryStack<?> stack : resultNotice) {
            builder.addOutputNotice(stack);
        }
        this.openView(builder.setPreferredOpenedCategory(category));
    }

    @Override
    public boolean openView(ViewSearchBuilder builder) {
        Object object;
        DisplayScreen displayScreen;
        AbstractDisplayViewingScreen screen;
        Map<DisplayCategory<?>, List<DisplaySpec>> map = builder.buildMapInternal();
        if (map.isEmpty()) {
            return false;
        }
        if (ConfigObject.getInstance().getRecipeScreenType() == DisplayScreenType.COMPOSITE) {
            screen = new CompositeDisplayViewingScreen(map, builder.getPreferredOpenedCategory());
        } else {
            if (ConfigObject.getInstance().getRecipeScreenType() == DisplayScreenType.UNSET) {
                ConfigObject.getInstance().setRecipeScreenType(DisplayScreenType.ORIGINAL);
                ConfigManager.getInstance().saveConfig();
                return this.openView(builder);
            }
            screen = new DefaultDisplayViewingScreen(map, builder.getPreferredOpenedCategory());
        }
        if (screen instanceof DisplayScreen) {
            displayScreen = screen;
            for (EntryStack entryStack : builder.getUsagesFor()) {
                displayScreen.addIngredientToNotice(entryStack);
            }
            object = builder.getRecipesFor().iterator();
            while (object.hasNext()) {
                EntryStack entryStack = (EntryStack)object.next();
                displayScreen.addResultToNotice(entryStack);
            }
        }
        if ((object = Minecraft.m_91087_().f_91080_) instanceof DisplayScreen) {
            displayScreen = (DisplayScreen)object;
            REIRuntimeImpl.getInstance().storeDisplayScreen(displayScreen);
        }
        Minecraft.m_91087_().m_91152_((Screen)screen);
        return true;
    }

    @Override
    public boolean canUseMovePackets() {
        return NetworkManager.canServerReceive((ResourceLocation)RoughlyEnoughItemsNetwork.MOVE_ITEMS_PACKET);
    }

    public void onInitializeClient() {
        ClientInternals.attachInstance(this, ClientHelper.class);
        ClientInternals.attachInstance(ViewSearchBuilderImpl::new, "viewSearchBuilder");
    }

    public static final class LegacyWrapperViewSearchBuilder
    extends AbstractViewSearchBuilder {
        private final Map<DisplayCategory<?>, List<DisplaySpec>> map;
        @Nullable
        private EntryStack<?> inputNotice;
        @Nullable
        private EntryStack<?> outputNotice;
        @Nullable
        private CategoryIdentifier<?> preferredOpenedCategory = null;

        public LegacyWrapperViewSearchBuilder(Map<DisplayCategory<?>, List<DisplaySpec>> map) {
            this.map = map;
        }

        @Override
        public ViewSearchBuilder addCategory(CategoryIdentifier<?> category) {
            return this;
        }

        @Override
        public ViewSearchBuilder addCategories(Collection<CategoryIdentifier<?>> categories) {
            return this;
        }

        @Override
        public Set<CategoryIdentifier<?>> getCategories() {
            return Collections.emptySet();
        }

        @Override
        public ViewSearchBuilder filterCategory(CategoryIdentifier<?> category) {
            return this;
        }

        @Override
        public ViewSearchBuilder filterCategories(Collection<CategoryIdentifier<?>> categories) {
            return this;
        }

        @Override
        public Set<CategoryIdentifier<?>> getFilteringCategories() {
            return Collections.emptySet();
        }

        @Override
        public <T> ViewSearchBuilder addRecipesFor(EntryStack<T> stack) {
            return this;
        }

        @Override
        public List<EntryStack<?>> getRecipesFor() {
            return this.inputNotice == null ? Collections.emptyList() : Collections.singletonList(this.outputNotice);
        }

        @Override
        public <T> ViewSearchBuilder addUsagesFor(EntryStack<T> stack) {
            return this;
        }

        @Override
        public List<EntryStack<?>> getUsagesFor() {
            return this.inputNotice == null ? Collections.emptyList() : Collections.singletonList(this.inputNotice);
        }

        @Override
        public ViewSearchBuilder setPreferredOpenedCategory(@Nullable CategoryIdentifier<?> category) {
            this.preferredOpenedCategory = category;
            return this;
        }

        @Override
        @Nullable
        public CategoryIdentifier<?> getPreferredOpenedCategory() {
            return this.preferredOpenedCategory;
        }

        public <T> LegacyWrapperViewSearchBuilder addInputNotice(@Nullable EntryStack<T> stack) {
            this.inputNotice = stack;
            return this;
        }

        public <T> LegacyWrapperViewSearchBuilder addOutputNotice(@Nullable EntryStack<T> stack) {
            this.outputNotice = stack;
            return this;
        }

        @Override
        public Map<DisplayCategory<?>, List<DisplaySpec>> buildMapInternal() {
            this.fillPreferredOpenedCategory();
            return this.map;
        }

        @Override
        public boolean isMergingDisplays() {
            return true;
        }

        @Override
        public ViewSearchBuilder mergingDisplays(boolean mergingDisplays) {
            return this;
        }

        @Override
        public boolean isProcessingVisibilityHandlers() {
            return false;
        }

        @Override
        public ViewSearchBuilder processingVisibilityHandlers(boolean processingVisibilityHandlers) {
            return this;
        }
    }

    public static final class ViewSearchBuilderImpl
    extends AbstractViewSearchBuilder {
        private final Set<CategoryIdentifier<?>> filteringCategories = new HashSet();
        private final Set<CategoryIdentifier<?>> categories = new HashSet();
        private final List<EntryStack<?>> recipesFor = new ArrayList();
        private final List<EntryStack<?>> usagesFor = new ArrayList();
        @Nullable
        private CategoryIdentifier<?> preferredOpenedCategory = null;
        private boolean mergeDisplays = true;
        private boolean processVisibilityHandlers = true;
        private final Supplier<Map<DisplayCategory<?>, List<DisplaySpec>>> map = Suppliers.memoize(() -> ViewsImpl.buildMapFor(this));

        @Override
        public ViewSearchBuilder addCategory(CategoryIdentifier<?> category) {
            this.categories.add(category);
            return this;
        }

        @Override
        public ViewSearchBuilder addCategories(Collection<CategoryIdentifier<?>> categories) {
            this.categories.addAll(categories);
            return this;
        }

        @Override
        public Set<CategoryIdentifier<?>> getCategories() {
            return this.categories;
        }

        @Override
        public <T> ViewSearchBuilder addRecipesFor(EntryStack<T> stack) {
            this.recipesFor.add(stack);
            return this;
        }

        @Override
        public List<EntryStack<?>> getRecipesFor() {
            return this.recipesFor;
        }

        @Override
        public <T> ViewSearchBuilder addUsagesFor(EntryStack<T> stack) {
            this.usagesFor.add(stack);
            return this;
        }

        @Override
        public List<EntryStack<?>> getUsagesFor() {
            return this.usagesFor;
        }

        @Override
        public ViewSearchBuilder setPreferredOpenedCategory(@Nullable CategoryIdentifier<?> category) {
            this.preferredOpenedCategory = category;
            return this;
        }

        @Override
        @Nullable
        public CategoryIdentifier<?> getPreferredOpenedCategory() {
            return this.preferredOpenedCategory;
        }

        @Override
        public ViewSearchBuilder filterCategory(CategoryIdentifier<?> category) {
            this.filteringCategories.add(category);
            return this;
        }

        @Override
        public ViewSearchBuilder filterCategories(Collection<CategoryIdentifier<?>> categories) {
            this.filteringCategories.addAll(categories);
            return this;
        }

        @Override
        public Set<CategoryIdentifier<?>> getFilteringCategories() {
            return this.filteringCategories;
        }

        @Override
        public Map<DisplayCategory<?>, List<DisplaySpec>> buildMapInternal() {
            this.fillPreferredOpenedCategory();
            return this.map.get();
        }

        @Override
        public boolean isMergingDisplays() {
            return this.mergeDisplays;
        }

        @Override
        public ViewSearchBuilder mergingDisplays(boolean mergingDisplays) {
            this.mergeDisplays = mergingDisplays;
            return this;
        }

        @Override
        public boolean isProcessingVisibilityHandlers() {
            return this.processVisibilityHandlers;
        }

        @Override
        public ViewSearchBuilder processingVisibilityHandlers(boolean processingVisibilityHandlers) {
            this.processVisibilityHandlers = processingVisibilityHandlers;
            return this;
        }
    }

    private static abstract class AbstractViewSearchBuilder
    implements ViewSearchBuilder {
        private AbstractViewSearchBuilder() {
        }

        public ViewSearchBuilder fillPreferredOpenedCategory() {
            Screen currentScreen;
            if (this.getPreferredOpenedCategory() == null && (currentScreen = Minecraft.m_91087_().f_91080_) instanceof DisplayScreen) {
                DisplayScreen displayScreen = (DisplayScreen)currentScreen;
                this.setPreferredOpenedCategory(displayScreen.getCurrentCategoryId());
            }
            return this;
        }

        @Override
        public Stream<DisplaySpec> streamDisplays() {
            return this.buildMapInternal().values().stream().flatMap(Collection::stream);
        }
    }
}

