/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.transformers.SplitPacketTransformer;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessorRegistry;
import me.shedaniel.rei.impl.common.transfer.InputSlotCrafter;
import me.shedaniel.rei.impl.common.transfer.LegacyInputSlotCrafter;
import me.shedaniel.rei.impl.common.transfer.NewInputSlotCrafter;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.ItemStack;

public class RoughlyEnoughItemsNetwork {
    public static final ResourceLocation DELETE_ITEMS_PACKET = new ResourceLocation("roughlyenoughitems", "delete_item");
    public static final ResourceLocation CREATE_ITEMS_PACKET = new ResourceLocation("roughlyenoughitems", "create_item");
    public static final ResourceLocation CREATE_ITEMS_HOTBAR_PACKET = new ResourceLocation("roughlyenoughitems", "create_item_hotbar");
    public static final ResourceLocation CREATE_ITEMS_GRAB_PACKET = new ResourceLocation("roughlyenoughitems", "create_item_grab");
    public static final ResourceLocation CREATE_ITEMS_MESSAGE_PACKET = new ResourceLocation("roughlyenoughitems", "ci_msg");
    public static final ResourceLocation MOVE_ITEMS_PACKET = new ResourceLocation("roughlyenoughitems", "move_items");
    public static final ResourceLocation MOVE_ITEMS_NEW_PACKET = new ResourceLocation("roughlyenoughitems", "move_items_new");
    public static final ResourceLocation NOT_ENOUGH_ITEMS_PACKET = new ResourceLocation("roughlyenoughitems", "og_not_enough");

    public static void onInitialize() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)DELETE_ITEMS_PACKET, Collections.singletonList(new SplitPacketTransformer()), (buf, context) -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player.m_20194_().m_129944_(player.m_36316_()) < player.m_20194_().m_7022_()) {
                player.m_5661_((Component)new TranslatableComponent("text.rei.no_permission_cheat").m_130940_(ChatFormatting.RED), false);
                return;
            }
            AbstractContainerMenu menu = player.f_36096_;
            if (!menu.m_142621_().m_41619_()) {
                menu.m_142503_(ItemStack.f_41583_);
                menu.m_38946_();
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)CREATE_ITEMS_PACKET, Collections.singletonList(new SplitPacketTransformer()), (buf, context) -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player.m_20194_().m_129944_(player.m_36316_()) < player.m_20194_().m_7022_()) {
                player.m_5661_((Component)new TranslatableComponent("text.rei.no_permission_cheat").m_130940_(ChatFormatting.RED), false);
                return;
            }
            ItemStack stack = buf.m_130267_();
            if (player.m_150109_().m_36054_(stack.m_41777_())) {
                NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)CREATE_ITEMS_MESSAGE_PACKET, (FriendlyByteBuf)new FriendlyByteBuf(Unpooled.buffer()).m_130055_(stack.m_41777_()).m_130072_(player.m_6302_(), Short.MAX_VALUE));
            } else {
                player.m_5661_((Component)new TranslatableComponent("text.rei.failed_cheat_items"), false);
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)CREATE_ITEMS_GRAB_PACKET, Collections.singletonList(new SplitPacketTransformer()), (buf, context) -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player.m_20194_().m_129944_(player.m_36316_()) < player.m_20194_().m_7022_()) {
                player.m_5661_((Component)new TranslatableComponent("text.rei.no_permission_cheat").m_130940_(ChatFormatting.RED), false);
                return;
            }
            AbstractContainerMenu menu = player.f_36096_;
            ItemStack itemStack = buf.m_130267_();
            ItemStack stack = itemStack.m_41777_();
            if (!menu.m_142621_().m_41619_() && ItemStack.m_41758_((ItemStack)menu.m_142621_(), (ItemStack)stack) && ItemStack.m_41658_((ItemStack)menu.m_142621_(), (ItemStack)stack)) {
                stack.m_41764_(Mth.m_14045_((int)(stack.m_41613_() + menu.m_142621_().m_41613_()), (int)1, (int)stack.m_41741_()));
            } else if (!menu.m_142621_().m_41619_()) {
                return;
            }
            menu.m_142503_(stack.m_41777_());
            menu.m_38946_();
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)CREATE_ITEMS_MESSAGE_PACKET, (FriendlyByteBuf)new FriendlyByteBuf(Unpooled.buffer()).m_130055_(itemStack.m_41777_()).m_130072_(player.m_6302_(), Short.MAX_VALUE));
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)CREATE_ITEMS_HOTBAR_PACKET, Collections.singletonList(new SplitPacketTransformer()), (buf, context) -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player.m_20194_().m_129944_(player.m_36316_()) < player.m_20194_().m_7022_()) {
                player.m_5661_((Component)new TranslatableComponent("text.rei.no_permission_cheat").m_130940_(ChatFormatting.RED), false);
                return;
            }
            ItemStack stack = buf.m_130267_();
            int hotbarSlotId = buf.m_130242_();
            if (hotbarSlotId >= 0 && hotbarSlotId < 9) {
                AbstractContainerMenu menu = player.f_36096_;
                player.m_150109_().f_35974_.set(hotbarSlotId, (Object)stack.m_41777_());
                menu.m_38946_();
                NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)CREATE_ITEMS_MESSAGE_PACKET, (FriendlyByteBuf)new FriendlyByteBuf(Unpooled.buffer()).m_130055_(stack.m_41777_()).m_130072_(player.m_6302_(), Short.MAX_VALUE));
            } else {
                player.m_5661_((Component)new TranslatableComponent("text.rei.failed_cheat_items"), false);
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)MOVE_ITEMS_PACKET, Collections.singletonList(new SplitPacketTransformer()), (packetByteBuf, context) -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            CategoryIdentifier category = CategoryIdentifier.of(packetByteBuf.m_130281_());
            AbstractContainerMenu container = player.f_36096_;
            InventoryMenu playerContainer = player.f_36095_;
            try {
                boolean shift = packetByteBuf.readBoolean();
                try {
                    LegacyInputSlotCrafter legacyInputSlotCrafter = LegacyInputSlotCrafter.start(category, container, player, packetByteBuf.m_130261_(), shift);
                }
                catch (InputSlotCrafter.NotEnoughMaterialsException e) {
                    if (!(container instanceof RecipeBookMenu)) {
                        return;
                    }
                }
                catch (IllegalStateException e) {
                    player.m_6352_((Component)new TranslatableComponent(e.getMessage()).m_130940_(ChatFormatting.RED), Util.f_137441_);
                }
                catch (Exception e) {
                    player.m_6352_((Component)new TranslatableComponent("error.rei.internal.error", new Object[]{e.getMessage()}).m_130940_(ChatFormatting.RED), Util.f_137441_);
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)MOVE_ITEMS_NEW_PACKET, Collections.singletonList(new SplitPacketTransformer()), (packetByteBuf, context) -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            CategoryIdentifier category = CategoryIdentifier.of(packetByteBuf.m_130281_());
            AbstractContainerMenu container = player.f_36096_;
            InventoryMenu playerContainer = player.f_36095_;
            try {
                boolean shift = packetByteBuf.readBoolean();
                try {
                    CompoundTag nbt = packetByteBuf.m_130261_();
                    int version = nbt.m_128451_("Version");
                    if (version != 1) {
                        throw new IllegalStateException("Server and client REI protocol version mismatch! Server: 1, Client: " + version);
                    }
                    List<InputIngredient<ItemStack>> inputs = RoughlyEnoughItemsNetwork.readInputs(nbt.m_128437_("Inputs", 10));
                    List<SlotAccessor> input = RoughlyEnoughItemsNetwork.readSlots(container, (Player)player, nbt.m_128437_("InputSlots", 10));
                    List<SlotAccessor> inventory = RoughlyEnoughItemsNetwork.readSlots(container, (Player)player, nbt.m_128437_("InventorySlots", 10));
                    NewInputSlotCrafter crafter = new NewInputSlotCrafter(container, input, inventory, inputs);
                    crafter.fillInputSlots(player, shift);
                }
                catch (InputSlotCrafter.NotEnoughMaterialsException e) {
                    if (!(container instanceof RecipeBookMenu)) {
                        return;
                    }
                }
                catch (IllegalStateException e) {
                    player.m_6352_((Component)new TranslatableComponent(e.getMessage()).m_130940_(ChatFormatting.RED), Util.f_137441_);
                }
                catch (Exception e) {
                    player.m_6352_((Component)new TranslatableComponent("error.rei.internal.error", new Object[]{e.getMessage()}).m_130940_(ChatFormatting.RED), Util.f_137441_);
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private static List<SlotAccessor> readSlots(AbstractContainerMenu menu, Player player, ListTag tag) {
        ArrayList<SlotAccessor> slots = new ArrayList<SlotAccessor>();
        for (Tag t : tag) {
            slots.add(SlotAccessorRegistry.getInstance().read(menu, player, (CompoundTag)t));
        }
        return slots;
    }

    private static List<InputIngredient<ItemStack>> readInputs(ListTag tag) {
        ArrayList<InputIngredient<ItemStack>> inputs = new ArrayList<InputIngredient<ItemStack>>();
        for (Tag t : tag) {
            CompoundTag compoundTag = (CompoundTag)t;
            InputIngredient<EntryStack<?>> stacks = InputIngredient.of(compoundTag.m_128451_("Index"), EntryIngredient.read(compoundTag.m_128437_("Ingredient", 10)));
            inputs.add(InputIngredient.withType(stacks, VanillaEntryTypes.ITEM));
        }
        return inputs;
    }
}

