/*
 * Decompiled with CFR 0.152.
 */
package baguchan.bettergolem.mixin;

import baguchan.bettergolem.api.ISwingAttack;
import baguchan.bettergolem.entity.goal.SwingAttackGoal;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={IronGolem.class})
public abstract class MixinIronGolemEntity
extends AbstractGolem
implements ISwingAttack {
    private static final EntityDataAccessor<Boolean> SWING_ATTACK = SynchedEntityData.m_135353_(IronGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float swingAttackAnimationProgress;
    private float lastSwingAttackAnimationProgress;

    public MixinIronGolemEntity(EntityType<? extends AbstractGolem> type, Level worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    protected void defineSynchedData(CallbackInfo callbackInfo) {
        this.f_19804_.m_135372_(SWING_ATTACK, (Object)Boolean.FALSE);
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    protected void registerGoals(CallbackInfo callbackInfo) {
        this.f_21345_.m_25352_(0, new SwingAttackGoal<MixinIronGolemEntity>(this));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_()) {
            this.lastSwingAttackAnimationProgress = this.swingAttackAnimationProgress;
            this.swingAttackAnimationProgress = this.isSwingAttack() ? Mth.m_14036_((float)(this.swingAttackAnimationProgress + 0.2f), (float)0.0f, (float)1.0f) : Mth.m_14036_((float)(this.swingAttackAnimationProgress - 0.05f), (float)0.0f, (float)1.0f);
        }
    }

    @Override
    public void setSwingAttack(boolean attack) {
        this.f_19804_.m_135381_(SWING_ATTACK, (Object)attack);
    }

    @Override
    public boolean isSwingAttack() {
        return (Boolean)this.f_19804_.m_135370_(SWING_ATTACK);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getSwingAttackAnimationScale(float ageInTicks) {
        return this.lastSwingAttackAnimationProgress + (this.swingAttackAnimationProgress - this.lastSwingAttackAnimationProgress) * ageInTicks;
    }
}

