/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.util;

import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;

public class TagAccess {
    public static TagAccess ROOT = new TagAccess(null);
    @Nullable
    private final RegistryAccess registries;

    private TagAccess(@Nullable RegistryAccess registries) {
        this.registries = registries;
    }

    public static TagAccess create(RegistryAccess registries) {
        return new TagAccess(Objects.requireNonNull(registries));
    }

    public static TagAccess create(MinecraftServer server) {
        return TagAccess.create((RegistryAccess)server.m_206579_());
    }

    public static TagAccess create(Level level) {
        return TagAccess.create(level.m_5962_());
    }

    public <T> HolderSet.Named<T> get(TagKey<T> key) {
        return this.resolve(key.f_203867_()).m_203561_(key);
    }

    public <T> Optional<HolderSet.Named<T>> tryGet(TagKey<T> key) {
        return this.resolve(key.f_203867_()).m_203431_(key);
    }

    public <T> boolean has(TagKey<T> key, T value) {
        Registry<T> registry = this.resolve(key.f_203867_());
        Optional holder = registry.m_7854_(value).flatMap(arg_0 -> registry.m_203636_(arg_0));
        if (holder.isEmpty()) {
            return false;
        }
        return registry.m_203431_(key).map(tag -> tag.m_203333_((Holder)holder.get())).orElse(false);
    }

    public <T> Optional<T> random(TagKey<T> key, Random random) {
        return this.resolve(key.f_203867_()).m_203431_(key).flatMap(tag -> tag.m_203450_(random)).map(Holder::m_203334_);
    }

    private <T> Registry<T> resolve(ResourceKey<? extends Registry<T>> key) {
        if (this.registries != null) {
            return (Registry)this.registries.m_6632_(key).orElseThrow(() -> new IllegalArgumentException("Registry " + key.m_135782_() + " not found in access: " + this.registries));
        }
        Registry registry = (Registry)Registry.f_122897_.m_7745_(key.m_135782_());
        if (registry == null) {
            throw new IllegalArgumentException("Registry " + key.m_135782_() + " not found: No registry access attached.");
        }
        return registry;
    }
}

