/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.mod.registration;

import com.google.common.collect.ImmutableMap;
import io.github.noeppi_noeppi.libx.mod.registration.Registerable;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import org.apache.commons.lang3.tuple.Pair;

public class EnumObjects<E extends Enum<E>, T>
implements Registerable {
    private final T defaultValue;
    private final E[] keys;
    private final Map<E, T> map;

    public EnumObjects(Class<E> enumClass, Function<E, T> factory) {
        if (!enumClass.isEnum()) {
            throw new IllegalStateException("EnumObjects can only be used with enum classes.");
        }
        Object defaultValue = null;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.keys = (Enum[])enumClass.getEnumConstants();
        if (this.keys.length == 0) {
            throw new IllegalStateException("EnumObjects can not be used with empty enums.");
        }
        for (E e : this.keys) {
            T t = factory.apply(e);
            if (defaultValue == null) {
                defaultValue = t;
            }
            builder.put(e, t);
        }
        this.defaultValue = Objects.requireNonNull(defaultValue, "No value in EnumObjects. This can not be used with empty enums.");
        this.map = builder.build();
    }

    public T get(E key) {
        return this.map.getOrDefault(key, this.defaultValue);
    }

    public T random(Random random) {
        return this.map.get(this.keys[random.nextInt(this.keys.length)]);
    }

    @Override
    public Map<String, Object> getNamedAdditionalRegisters(ResourceLocation id) {
        return (Map)this.map.entrySet().stream().map(e -> Pair.of((Object)((Enum)e.getKey()).name().toLowerCase(Locale.ROOT), e.getValue())).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
    }

    public static <T> EnumObjects<DyeColor, T> colored(Function<DyeColor, T> factory) {
        return new EnumObjects<DyeColor, T>(DyeColor.class, factory);
    }
}

