/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.base.decoration;

import com.google.common.collect.ImmutableMap;
import io.github.noeppi_noeppi.libx.base.BlockBase;
import io.github.noeppi_noeppi.libx.base.decoration.DecorationContext;
import io.github.noeppi_noeppi.libx.base.decoration.DecorationType;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class DecoratedBlock
extends BlockBase {
    private final DecorationContext context;
    private final Map<DecorationType<?>, Object> elements;
    private final Map<String, Object> registerMap;

    public DecoratedBlock(ModX mod, DecorationContext context, BlockBehaviour.Properties properties) {
        this(mod, context, properties, new Item.Properties());
    }

    public DecoratedBlock(ModX mod, DecorationContext context, BlockBehaviour.Properties properties, Item.Properties itemProperties) {
        super(mod, properties, itemProperties);
        this.context = context;
        DecorationContext.RegistrationInfo info = context.register(this.mod, this);
        this.elements = info.elementMap();
        this.registerMap = info.registerMap();
    }

    @Override
    public Map<String, Object> getNamedAdditionalRegisters(ResourceLocation id) {
        return ImmutableMap.builder().putAll(super.getNamedAdditionalRegisters(id)).putAll(this.registerMap).build();
    }

    public DecorationContext getContext() {
        return this.context;
    }

    public boolean has(DecorationType<?> type) {
        return this.context.has(type) && this.elements.containsKey(type);
    }

    @Nonnull
    public <T> T get(DecorationType<T> type) {
        if (type == DecorationType.BASE) {
            return (T)this;
        }
        if (this.has(type)) {
            return (T)this.elements.get(type);
        }
        throw new NoSuchElementException("Decoration context " + this.context + " has no element of type " + type.name() + ": " + type);
    }
}

