/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.followme.common.network;

import java.io.Serializable;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.smileycorp.atlas.api.network.SimpleByteMessage;
import net.smileycorp.atlas.api.network.SimpleMessageDecoder;
import net.smileycorp.atlas.api.network.SimpleMessageEncoder;
import net.smileycorp.followme.client.ClientHandler;
import net.smileycorp.followme.common.CommonConfigHandler;
import net.smileycorp.followme.common.FollowHandler;
import net.smileycorp.followme.common.FollowMe;
import net.smileycorp.followme.common.ModDefinitions;
import net.smileycorp.followme.common.ai.FollowUserGoal;
import net.smileycorp.followme.common.network.DenyFollowMessage;
import net.smileycorp.followme.common.network.FollowMessage;
import net.smileycorp.followme.common.network.FollowSyncMessage;
import net.smileycorp.followme.common.network.StopFollowMessage;

public class PacketHandler {
    public static SimpleChannel NETWORK_INSTANCE;

    public static void initPackets() {
        NETWORK_INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)ModDefinitions.getResource("main"), () -> "1", "1"::equals, "1"::equals);
        NETWORK_INSTANCE.registerMessage(0, SimpleByteMessage.class, (BiConsumer)new SimpleMessageEncoder(), (Function)new SimpleMessageDecoder(SimpleByteMessage.class), (T, K) -> PacketHandler.processSyncMessage(T, (NetworkEvent.Context)K.get()));
        NETWORK_INSTANCE.registerMessage(1, FollowMessage.class, (BiConsumer)new SimpleMessageEncoder(), (Function)new SimpleMessageDecoder(FollowMessage.class), (T, K) -> PacketHandler.processFollowMessage(T, (NetworkEvent.Context)K.get()));
        NETWORK_INSTANCE.registerMessage(2, StopFollowMessage.class, (BiConsumer)new SimpleMessageEncoder(), (Function)new SimpleMessageDecoder(StopFollowMessage.class), (T, K) -> PacketHandler.processStopFollowMessage(T, (NetworkEvent.Context)K.get()));
        NETWORK_INSTANCE.registerMessage(3, FollowSyncMessage.class, (BiConsumer)new SimpleMessageEncoder(), (Function)new SimpleMessageDecoder(FollowSyncMessage.class), (T, K) -> PacketHandler.processFollowSyncMessage(T, (NetworkEvent.Context)K.get()));
        NETWORK_INSTANCE.registerMessage(4, DenyFollowMessage.class, (BiConsumer)new SimpleMessageEncoder(), (Function)new SimpleMessageDecoder(DenyFollowMessage.class), (T, K) -> PacketHandler.processDenyMessage(T, (NetworkEvent.Context)K.get()));
    }

    public static void processSyncMessage(SimpleByteMessage message, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeRunnable & Serializable)() -> CommonConfigHandler.syncClient(message.getData())));
        ctx.setPacketHandled(true);
    }

    public static void processFollowMessage(FollowMessage message, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            ServerPlayer player = server.m_6846_().m_11259_(message.getPlayerUUID());
            Mob entity = message.getEntity(player.f_19853_);
            boolean isForced = FollowHandler.isForcedToFollow((Entity)entity);
            if (isForced || CommonConfigHandler.isInWhitelist((Entity)entity)) {
                FollowHandler.processInteraction(player.f_19853_, (LivingEntity)player, entity, InteractionHand.MAIN_HAND, isForced);
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void processStopFollowMessage(StopFollowMessage message, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            ServerPlayer player = server.m_6846_().m_11259_(message.getPlayerUUID());
            for (Mob entity : player.f_19853_.m_6443_(Mob.class, player.m_142469_().m_82400_(5.0), e -> CommonConfigHandler.isInWhitelist((Entity)e))) {
                for (WrappedGoal entry : (WrappedGoal[])entity.f_21345_.m_25386_().toArray(WrappedGoal[]::new)) {
                    Goal goal = entry.m_26015_();
                    if (!(goal instanceof FollowUserGoal) || ((FollowUserGoal)goal).getUser() != player) continue;
                    FollowMe.DELAYED_THREAD_EXECUTOR.execute(() -> FollowHandler.removeAI((FollowUserGoal)goal));
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void processFollowSyncMessage(FollowSyncMessage message, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeRunnable & Serializable)() -> ClientHandler.syncFollowEntities(message)));
        ctx.setPacketHandled(true);
    }

    public static void processDenyMessage(DenyFollowMessage message, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeRunnable & Serializable)() -> ClientHandler.processEntityDeny(message)));
        ctx.setPacketHandled(true);
    }
}

