/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.followme.common.data;

import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.smileycorp.atlas.api.data.LogicalOperation;
import net.smileycorp.followme.common.data.DataCondition;

public class LogicalDataCondition
implements DataCondition {
    public final List<DataCondition> subConditions;
    protected final LogicalOperation operation;

    public LogicalDataCondition(LogicalOperation operation, List<DataCondition> conditions) {
        this.operation = operation;
        this.subConditions = conditions;
    }

    @Override
    public boolean matches(Mob entity, LivingEntity player) {
        boolean result = false;
        for (DataCondition condition : this.subConditions) {
            result = this.operation.apply(result, condition.matches(entity, player));
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.subConditions.size(); ++i) {
            builder.append(this.subConditions.get(i).toString());
            if (i >= this.subConditions.size() - 1) continue;
            builder.append(" " + this.operation.getSymbol() + " ");
        }
        return super.toString() + "[" + builder.toString() + "]";
    }
}

