/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.followme.common.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.smileycorp.atlas.api.data.ComparableOperation;
import net.smileycorp.atlas.api.data.DataType;
import net.smileycorp.atlas.api.data.LogicalOperation;
import net.smileycorp.atlas.api.data.NBTExplorer;
import net.smileycorp.followme.common.FollowHandler;
import net.smileycorp.followme.common.FollowMe;
import net.smileycorp.followme.common.ModDefinitions;
import net.smileycorp.followme.common.data.CompareDataCondition;
import net.smileycorp.followme.common.data.DataCondition;
import net.smileycorp.followme.common.data.EntityDataCondition;
import net.smileycorp.followme.common.data.LogicalDataCondition;
import net.smileycorp.followme.common.data.UserDataCondition;
import net.smileycorp.followme.common.data.WorldDataCondition;

public class DataLoader
extends SimpleJsonResourceReloadListener {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static ResourceLocation CONDITIONS = ModDefinitions.getResource("conditions");
    private static IForgeRegistry<EntityType<?>> entityRegistry = ForgeRegistries.ENTITIES;

    public DataLoader() {
        super(GSON, "conditions");
    }

    public void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profiler) {
        block13: {
            FollowHandler.resetConditions();
            if (map.containsKey(CONDITIONS)) {
                JsonElement data = map.get(CONDITIONS);
                try {
                    if (data.isJsonObject()) {
                        for (Map.Entry entityEntry : data.getAsJsonObject().entrySet()) {
                            ResourceLocation loc;
                            if (!((JsonElement)entityEntry.getValue()).isJsonObject()) continue;
                            String name = null;
                            EntityType type = null;
                            JsonObject json = ((JsonElement)entityEntry.getValue()).getAsJsonObject();
                            name = (String)entityEntry.getKey();
                            if (name.contains(":")) {
                                String[] nameSplit = name.split(":");
                                loc = new ResourceLocation(nameSplit[0], nameSplit[1]);
                                if (!entityRegistry.containsKey(loc)) {
                                    throw new Exception("Entity " + name + " is not registered");
                                }
                            } else {
                                throw new Exception(name + " is not a valid entity");
                            }
                            type = (EntityType)entityRegistry.getValue(loc);
                            if (GsonHelper.m_13900_((JsonObject)json, (String)"conditions")) {
                                for (Map.Entry entry : GsonHelper.m_13930_((JsonObject)json, (String)"conditions").entrySet()) {
                                    if (((JsonElement)entry.getValue()).isJsonObject()) {
                                        DataCondition condition = this.parseCondition(((JsonElement)entry.getValue()).getAsJsonObject(), (String)entry.getKey());
                                        if (type != null && condition != null) {
                                            FollowHandler.addCondition(type, (String)entry.getKey(), condition);
                                            continue;
                                        }
                                        throw new Exception("condition [type=" + type + ", condition=" + condition + "] is not valid for Entity " + name);
                                    }
                                    throw new Exception("Conditions are not in the JsonObject format");
                                }
                                continue;
                            }
                            throw new Exception("Entity " + name + " has no defined conditions");
                        }
                        break block13;
                    }
                    throw new Exception("Conditions datapack has no entries");
                }
                catch (Exception e) {
                    FollowMe.logError("Failed to load conditions datapack ", e);
                }
            } else {
                FollowMe.logError("Failed to load conditions datapack", new FileNotFoundException(CONDITIONS.toString()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DataCondition parseCondition(JsonObject json, String name) throws Exception {
        DataType type = null;
        NBTExplorer explorer = null;
        ComparableOperation operation = null;
        Comparable value = null;
        if (GsonHelper.m_13900_((JsonObject)json, (String)"type")) {
            type = DataType.of((String)GsonHelper.m_13906_((JsonObject)json, (String)"type"));
        }
        if (GsonHelper.m_13900_((JsonObject)json, (String)"target") && type != null) {
            explorer = new NBTExplorer(GsonHelper.m_13906_((JsonObject)json, (String)"target"), type);
        }
        if (GsonHelper.m_13900_((JsonObject)json, (String)"operation")) {
            String operationString = GsonHelper.m_13906_((JsonObject)json, (String)"operation");
            if (operationString.equals("%")) {
                if (GsonHelper.m_13900_((JsonObject)json, (String)"value") && type != null) {
                    SubOperationParser parser = SubOperationParser.parseValue(GsonHelper.m_13930_((JsonObject)json, (String)"value"), type);
                    if (!parser.isValid()) throw new Exception("SubOperation has thrown null " + parser);
                    value = parser.getValue();
                    operation = ComparableOperation.modOf(parser.comparison, (ComparableOperation)parser.subOperation);
                }
            } else {
                operation = ComparableOperation.of((String)GsonHelper.m_13906_((JsonObject)json, (String)"operation"));
                if (GsonHelper.m_13900_((JsonObject)json, (String)"value") && type != null) {
                    JsonElement element = json.get("value");
                    value = type.readFromJson(element);
                }
            }
        }
        if (!GsonHelper.m_13900_((JsonObject)json, (String)"mode")) throw new Exception("Condition \"" + name + "\" does not have \"mode\" value");
        String mode = GsonHelper.m_13906_((JsonObject)json, (String)"mode");
        if (type != null && explorer != null && operation != null && value != null) {
            if (mode.equals("user_nbt")) {
                return new UserDataCondition(explorer, value, operation);
            }
            if (mode.equals("entity_nbt")) {
                return new EntityDataCondition<Comparable>(explorer, value, operation);
            }
            if (mode.equals("world_nbt") || mode.equals("level_nbt")) {
                return new WorldDataCondition<Comparable>(explorer, value, operation);
            }
            if (mode.equals("compare_nbt")) {
                return new CompareDataCondition(explorer, new NBTExplorer((String)((Object)value), type), operation);
            }
            if (!mode.equals("player_nbt")) throw new Exception("\"" + mode + "\" for condition \"" + name + "\"  is not a valid condition mode");
            FollowMe.logError("\"player_nbt\" is depreciated, use \"user_nbt\" in future", new Exception("\"player_nbt\""));
            return new UserDataCondition<Comparable>(explorer, value, operation);
        }
        if (!GsonHelper.m_13900_((JsonObject)json, (String)"conditions")) throw new Exception("\"" + mode + "\" for condition \"" + name + "\" is not a valid mode");
        LogicalOperation gate = LogicalOperation.fromName((String)mode);
        ArrayList<DataCondition> subConditions = new ArrayList<DataCondition>();
        if (gate == null) throw new Exception("\"" + GsonHelper.m_13906_((JsonObject)json, (String)"mode") + "\" for condition \"" + name + "\" is not a valid logical operator");
        JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)"conditions");
        for (int i = 0; i < array.size(); ++i) {
            JsonElement field = array.get(i);
            try {
                subConditions.add(this.parseCondition((JsonObject)field, name + "_" + i));
                continue;
            }
            catch (Exception e) {
                throw new Exception("Failed parsing sub condition \"" + e.getMessage() + "\"for condition \"" + name + "\"");
            }
        }
        if (subConditions.isEmpty()) throw new Exception("Operator has no valid conditions");
        return new LogicalDataCondition(gate, subConditions);
    }

    public static class SubOperationParser {
        private final Comparable<?> comparison;
        private final ComparableOperation subOperation;
        private final Comparable<?> value;

        private SubOperationParser(Comparable<?> comparison, ComparableOperation subOperation, Comparable<?> value) {
            this.comparison = comparison;
            this.subOperation = subOperation;
            this.value = value;
        }

        public boolean isValid() {
            return this.comparison != null && this.subOperation != null && this.value != null;
        }

        public Comparable<?> getComparison() {
            return this.comparison;
        }

        public ComparableOperation subOperation() {
            return this.subOperation;
        }

        public Comparable<?> getValue() {
            return this.value;
        }

        public static SubOperationParser parseValue(JsonObject json, DataType<?> type) throws Exception {
            JsonElement element;
            Comparable comparison = null;
            ComparableOperation subOperation = null;
            Comparable value = null;
            String operationString = GsonHelper.m_13906_((JsonObject)json, (String)"operation");
            if (GsonHelper.m_13900_((JsonObject)json, (String)"comparison") && type != null) {
                element = json.get("comparison");
                comparison = type.readFromJson(element);
            }
            if (operationString.equals("%")) {
                SubOperationParser parser;
                if (GsonHelper.m_13900_((JsonObject)json, (String)"value") && type != null && (parser = SubOperationParser.parseValue(GsonHelper.m_13930_((JsonObject)json, (String)"value"), type)).isValid()) {
                    value = parser.getValue();
                    subOperation = ComparableOperation.modOf(parser.comparison, (ComparableOperation)parser.subOperation);
                }
            } else {
                subOperation = ComparableOperation.of((String)GsonHelper.m_13906_((JsonObject)json, (String)"operation"));
                if (GsonHelper.m_13900_((JsonObject)json, (String)"value") && type != null) {
                    element = json.get("value");
                    value = type.readFromJson(element);
                }
            }
            return new SubOperationParser(comparison, subOperation, value);
        }
    }
}

