/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.followme.common.data;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.smileycorp.atlas.api.data.ComparableOperation;
import net.smileycorp.atlas.api.data.NBTExplorer;
import net.smileycorp.followme.common.FollowMe;
import net.smileycorp.followme.common.data.DataCondition;

public class CompareDataCondition<T extends Comparable<T>>
implements DataCondition {
    protected final NBTExplorer<T> entityExplorer;
    protected final NBTExplorer<T> playerExplorer;
    protected final ComparableOperation operation;

    public CompareDataCondition(NBTExplorer<T> entityExplorer, NBTExplorer<T> playerExplorer, ComparableOperation operation) {
        this.entityExplorer = entityExplorer;
        this.playerExplorer = playerExplorer;
        this.operation = operation;
    }

    @Override
    public boolean matches(Mob entity, LivingEntity user) {
        CompoundTag entityNbt = new CompoundTag();
        entity.m_20240_(entityNbt);
        CompoundTag playerNbt = new CompoundTag();
        user.m_20240_(playerNbt);
        try {
            boolean result = this.operation.apply(this.entityExplorer.findValue(entityNbt), this.playerExplorer.findValue(playerNbt));
            return result;
        }
        catch (Exception e) {
            FollowMe.logError("Condition is invalid for " + this.toString(), e);
            return false;
        }
    }

    public String toString() {
        return super.toString() + "[" + this.entityExplorer.toString() + this.operation.getSymbol() + this.playerExplorer.toString() + "]";
    }
}

