/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.followme.common.capability;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.smileycorp.followme.common.FollowMe;
import net.smileycorp.followme.common.ai.FollowUserGoal;

public interface IFollower {
    public boolean isForcedToFollow();

    public void setForcedToFollow(boolean var1);

    public LivingEntity getFollowedEntity();

    public void readNBT(CompoundTag var1);

    public CompoundTag writeNBT();

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        private final IFollower impl;

        public Provider(Mob entity) {
            this.impl = new Implementation(entity);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == FollowMe.FOLLOW_CAPABILITY ? LazyOptional.of(() -> this.impl).cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.impl.writeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.impl.readNBT(nbt);
        }
    }

    public static class Implementation
    implements IFollower {
        private final Mob entity;
        private boolean forceFollow = false;

        public Implementation(Mob entity) {
            this.entity = entity;
        }

        @Override
        public boolean isForcedToFollow() {
            return this.forceFollow;
        }

        @Override
        public void setForcedToFollow(boolean follow) {
            this.forceFollow = follow;
        }

        @Override
        public LivingEntity getFollowedEntity() {
            for (WrappedGoal entry : (WrappedGoal[])this.entity.f_21345_.m_25386_().toArray(WrappedGoal[]::new)) {
                if (!(entry.m_26015_() instanceof FollowUserGoal) || entry.m_26015_() == null) continue;
                return ((FollowUserGoal)entry.m_26015_()).getUser();
            }
            return null;
        }

        @Override
        public void readNBT(CompoundTag tag) {
            this.forceFollow = tag.m_128445_("shouldFollow") > 0;
        }

        @Override
        public CompoundTag writeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128344_("shouldFollow", (byte)(this.forceFollow ? 1 : 0));
            return tag;
        }
    }
}

