/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.followme.common.ai;

import java.util.EnumSet;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import net.smileycorp.atlas.api.util.DirectionUtils;
import net.smileycorp.followme.common.CommonConfigHandler;
import net.smileycorp.followme.common.FollowHandler;
import net.smileycorp.followme.common.FollowMe;

public class FollowUserGoal
extends Goal {
    protected final float min = 1.0f;
    protected final double max = (Double)CommonConfigHandler.teleportDistance.get();
    protected final Mob entity;
    protected final LivingEntity user;
    protected final Level level;
    protected final PathNavigation pather;
    protected float waterCost;
    protected int timeToRecalcPath = 0;

    public FollowUserGoal(Mob entity, LivingEntity user) {
        this.entity = entity;
        this.user = user;
        this.level = entity.f_19853_;
        this.pather = entity.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        boolean canUse = false;
        if (this.entity.m_5448_() != this.user && this.user.isAddedToWorld() & !this.user.m_21224_() & !this.user.m_5833_() && (double)this.entity.m_20270_((Entity)this.user) < (Double)CommonConfigHandler.stopFollowDistance.get()) {
            canUse = this.user.m_5647_() != null && this.entity.m_5647_() != null ? this.user.m_5647_().m_83536_(this.entity.m_5647_()) : this.user.m_5647_() == this.entity.m_5647_() || this.user.m_5647_() != null;
        }
        if (!canUse) {
            FollowMe.DELAYED_THREAD_EXECUTOR.schedule(() -> FollowHandler.removeAI(this), 20L, TimeUnit.MILLISECONDS);
        }
        return canUse;
    }

    public void m_8056_() {
        this.waterCost = this.entity.m_21439_(BlockPathTypes.WATER);
    }

    public void m_8041_() {
        this.pather.m_26573_();
        this.entity.m_21441_(BlockPathTypes.WATER, this.waterCost);
    }

    public void m_8037_() {
        Vec3 dir;
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 5;
            if (this.entity.m_20270_((Entity)this.user) > 1.0f) {
                dir = DirectionUtils.getDirectionVecXZ((Entity)this.user, (Entity)this.entity);
                Path path = this.pather.m_7864_(this.user.m_142538_().m_142022_((double)Math.round(dir.f_82479_), 0.0, (double)Math.round(dir.f_82481_)), 1);
                this.pather.m_26536_(path, 0.75);
            }
        }
        if (((Boolean)CommonConfigHandler.shouldTeleport.get()).booleanValue() && (double)this.entity.m_20270_((Entity)this.user) >= this.max && !this.entity.m_21523_() && this.entity.m_20202_() == null) {
            dir = DirectionUtils.getDirectionVecXZ((Entity)this.user, (Entity)this.entity);
            int x = (int)Math.round(this.user.m_20185_() + 2.0 * dir.f_82479_);
            int y = (int)Math.round(this.user.m_20186_());
            int z = (int)Math.round(this.user.m_20189_() + 2.0 * dir.f_82481_);
            Random rand = this.level.f_46441_;
            for (int l = 0; l <= 10; ++l) {
                int k;
                int j;
                int i = rand.nextInt(7) - 3;
                BlockPos pos = new BlockPos((double)(x + i) + 0.5, (double)(y + (j = rand.nextInt(3) - 1)) + 0.5, (double)(z + (k = rand.nextInt(7) - 3)) + 0.5);
                if (!this.canTeleportTo(pos)) continue;
                this.entity.m_6027_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                this.pather.m_26573_();
            }
        }
    }

    private boolean canTeleportTo(BlockPos pos) {
        BlockPathTypes pathnodetype = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pos.m_122032_());
        if (pathnodetype != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockPos blockpos = pos.m_141950_((Vec3i)this.entity.m_142538_());
        return !this.level.m_45756_((Entity)this.entity, this.entity.m_142469_().m_82338_(blockpos));
    }

    public LivingEntity getUser() {
        return this.user;
    }

    public Mob getEntity() {
        return this.entity;
    }
}

