/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.followme.common;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.smileycorp.followme.client.ClientConfigHandler;
import net.smileycorp.followme.client.ClientHandler;
import net.smileycorp.followme.common.CommonConfigHandler;
import net.smileycorp.followme.common.EventListener;
import net.smileycorp.followme.common.ModDefinitions;
import net.smileycorp.followme.common.capability.IFollower;
import net.smileycorp.followme.common.network.PacketHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="followme")
@Mod.EventBusSubscriber(modid="followme", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FollowMe {
    public static ScheduledExecutorService DELAYED_THREAD_EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    private static Logger logger = LogManager.getLogger((String)"Follow Me");
    public static Capability<IFollower> FOLLOW_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IFollower>(){});

    public FollowMe() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfigHandler.config);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfigHandler.config);
    }

    @SubscribeEvent
    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(IFollower.class);
    }

    @SubscribeEvent
    public void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Mob) {
            event.addCapability(ModDefinitions.getResource("follower"), (ICapabilityProvider)new IFollower.Provider((Mob)entity));
        }
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        ClientHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)new ClientHandler());
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventListener());
        PacketHandler.initPackets();
    }

    public static void logInfo(Object message) {
        logger.info(message);
    }

    public static void logError(Object message, Exception e) {
        logger.error(message);
        e.printStackTrace();
    }
}

