/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.followme.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;
import net.smileycorp.followme.common.FollowMe;
import net.smileycorp.followme.common.ai.FollowUserGoal;
import net.smileycorp.followme.common.capability.IFollower;
import net.smileycorp.followme.common.data.DataCondition;
import net.smileycorp.followme.common.event.FollowUserEvent;
import net.smileycorp.followme.common.network.DenyFollowMessage;
import net.smileycorp.followme.common.network.FollowSyncMessage;
import net.smileycorp.followme.common.network.PacketHandler;

public class FollowHandler {
    private static Map<EntityType<?>, Map<String, DataCondition>> conditions = new HashMap();

    public static void removeAI(FollowUserGoal ai) {
        Mob entity = ai.getEntity();
        ai.m_8041_();
        entity.f_21345_.m_25363_((Goal)ai);
        if (ai.getUser() instanceof ServerPlayer) {
            PacketHandler.NETWORK_INSTANCE.sendTo((Object)new FollowSyncMessage(entity, true), ((ServerPlayer)ai.getUser()).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static boolean processInteraction(Level level, LivingEntity user, Mob entity, InteractionHand hand) {
        return FollowHandler.processInteraction(level, user, entity, hand, false);
    }

    public static boolean processInteraction(Level level, LivingEntity user, Mob entity, InteractionHand hand, boolean ignoreConditions) {
        if (entity.m_5448_() != user && hand == InteractionHand.MAIN_HAND) {
            FollowUserEvent followEvent = new FollowUserEvent((LivingEntity)entity, user, conditions.get(entity.m_6095_()));
            MinecraftForge.EVENT_BUS.post((Event)followEvent);
            if (followEvent.isCanceled()) {
                return false;
            }
            user = followEvent.user;
            if (followEvent.conditions != null & !ignoreConditions) {
                for (DataCondition condition : followEvent.conditions.values()) {
                    if (condition.matches(entity, user)) continue;
                    if (user instanceof ServerPlayer) {
                        PacketHandler.NETWORK_INSTANCE.sendTo((Object)new DenyFollowMessage(entity), ((ServerPlayer)user).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                    }
                    return false;
                }
            }
            if (entity.m_5647_() != null && !entity.m_5647_().m_83536_(user.m_5647_())) {
                return false;
            }
            boolean hasGoal = false;
            GoalSelector tasks = entity.f_21345_;
            for (WrappedGoal entry : (WrappedGoal[])entity.f_21345_.m_25386_().toArray(WrappedGoal[]::new)) {
                if (!(entry.m_26015_() instanceof FollowUserGoal)) continue;
                FollowUserGoal task = (FollowUserGoal)entry.m_26015_();
                if (task.getUser() == user) {
                    FollowHandler.removeAI(task);
                } else if (user instanceof ServerPlayer) {
                    PacketHandler.NETWORK_INSTANCE.sendTo((Object)new DenyFollowMessage(entity), ((ServerPlayer)user).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
                hasGoal = true;
                break;
            }
            if (!hasGoal) {
                FollowUserGoal task = new FollowUserGoal(entity, user);
                tasks.m_25352_(0, (Goal)task);
                if (user instanceof ServerPlayer) {
                    PacketHandler.NETWORK_INSTANCE.sendTo((Object)new FollowSyncMessage(entity, false), ((ServerPlayer)user).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
            }
            return true;
        }
        return false;
    }

    public static void resetConditions() {
        conditions.clear();
    }

    public static void addCondition(EntityType<?> type, String name, DataCondition condition) {
        if (conditions.containsKey(type)) {
            conditions.get(type).put(name, condition);
            FollowMe.logInfo("Added new condition " + condition + " for entity " + type);
        } else {
            HashMap<String, DataCondition> newConditions = new HashMap<String, DataCondition>();
            newConditions.put(name, condition);
            conditions.put(type, newConditions);
            FollowMe.logInfo("Added new condition " + condition + " for entity " + type);
        }
    }

    public static void removeCondition(String name) {
        HashSet emptySets = new HashSet();
        for (Map.Entry<EntityType<?>, Map<String, DataCondition>> entry : conditions.entrySet()) {
            HashSet<String> toRemove = new HashSet<String>();
            Map<String, DataCondition> map = entry.getValue();
            for (String conditionName : map.keySet()) {
                if (!conditionName.equals(name)) continue;
                toRemove.add(conditionName);
            }
            for (String key : toRemove) {
                map.remove(key);
            }
            if (!map.isEmpty()) continue;
            emptySets.add(entry.getKey());
        }
        for (EntityType entityType : emptySets) {
            conditions.remove(entityType);
        }
    }

    public static void removeCondition(DataCondition condition) {
        HashSet emptySets = new HashSet();
        for (Map.Entry<EntityType<?>, Map<String, DataCondition>> entry : conditions.entrySet()) {
            HashSet<String> toRemove = new HashSet<String>();
            Map<String, DataCondition> map = entry.getValue();
            for (Map.Entry<String, DataCondition> conditionEntry : map.entrySet()) {
                if (conditionEntry.getValue() != condition) continue;
                toRemove.add(conditionEntry.getKey());
            }
            for (String key : toRemove) {
                map.remove(key);
            }
            if (!map.isEmpty()) continue;
            emptySets.add(entry.getKey());
        }
        for (EntityType entityType : emptySets) {
            conditions.remove(entityType);
        }
    }

    public static boolean isForcedToFollow(Entity target) {
        LazyOptional optional = target.getCapability(FollowMe.FOLLOW_CAPABILITY);
        return optional.isPresent() && ((IFollower)optional.resolve().get()).isForcedToFollow();
    }
}

