/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.followme.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.smileycorp.followme.common.FollowMe;
import org.apache.commons.lang3.ArrayUtils;

public class CommonConfigHandler {
    public static final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec config;
    protected static List<EntityType<?>> entityWhitelist;
    protected static List<EntityType<?>> localEntityWhitelist;
    protected static ForgeConfigSpec.ConfigValue<List<String>> entityWhitelistBuilder;
    public static ForgeConfigSpec.ConfigValue<Boolean> shouldTeleport;
    public static ForgeConfigSpec.DoubleValue teleportDistance;
    public static ForgeConfigSpec.DoubleValue stopFollowDistance;
    private static IForgeRegistry<EntityType<?>> entityRegistry;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initWhitelist() {
        FollowMe.logInfo("Trying to read config");
        localEntityWhitelist = new ArrayList();
        try {
            if (entityWhitelistBuilder == null) {
                throw new Exception("Config has loaded as null");
            }
            if (((List)entityWhitelistBuilder.get()).size() <= 0) {
                throw new Exception("Value entityWhitelist in config is empty");
            }
            HashMap<String, EntityType> registeredEntities = new HashMap<String, EntityType>();
            for (String name : (List)entityWhitelistBuilder.get()) {
                try {
                    EntityType type;
                    if (name.contains(":")) {
                        String[] nameSplit = name.split(":");
                        ResourceLocation loc = new ResourceLocation(nameSplit[0], nameSplit[1]);
                        if (!entityRegistry.containsKey(loc)) throw new Exception("Entity " + name + " is not registered");
                        type = (EntityType)entityRegistry.getValue(loc);
                    } else {
                        if (registeredEntities.isEmpty()) {
                            for (EntityType entry : entityRegistry) {
                                Class<? extends Mob> eclazz = CommonConfigHandler.getClass(entry);
                                registeredEntities.put(eclazz.getSimpleName(), entry);
                            }
                        }
                        if (!registeredEntities.containsKey(name)) throw new Exception("Entity " + name + " is not registered");
                        type = (EntityType)registeredEntities.get(name);
                    }
                    localEntityWhitelist.add(type);
                    FollowMe.logInfo("Loaded entity " + name + " as " + type.m_20675_());
                }
                catch (Exception e) {
                    FollowMe.logError("Error adding entity " + name + " " + e.getCause() + " " + e.getMessage(), e);
                }
            }
            return;
        }
        catch (Exception e) {
            FollowMe.logError("Failed to read config, " + e.getCause() + " " + e.getMessage(), e);
        }
    }

    public static Class<? extends Mob> getClass(EntityType<?> value) throws Exception {
        return value.m_20615_((Level)ServerLifecycleHooks.getCurrentServer().m_129783_()).getClass();
    }

    public static boolean isInWhitelist(Entity entity) {
        return entity instanceof Mob && (entity.f_19853_.f_46443_ ? entityWhitelist.contains(entity.m_6095_()) : CommonConfigHandler.getLocalWhitelist().contains(entity.m_6095_()));
    }

    public static byte[] getPacketData() {
        byte[] bytes = new byte[]{};
        for (EntityType<?> type : CommonConfigHandler.getLocalWhitelist()) {
            bytes = ArrayUtils.addAll((byte[])bytes, (byte[])entityRegistry.getKey(type).toString().getBytes());
            bytes = ArrayUtils.addAll((byte[])bytes, (byte[])";".getBytes());
        }
        return bytes;
    }

    private static List<EntityType<?>> getLocalWhitelist() {
        if (localEntityWhitelist == null) {
            CommonConfigHandler.initWhitelist();
        }
        return localEntityWhitelist;
    }

    public static boolean syncClient(byte[] data) {
        ArrayList whitelist = new ArrayList();
        byte[] bytes = new byte[]{};
        for (byte b : data) {
            if (b == 0) continue;
            bytes = ArrayUtils.add((byte[])bytes, (byte)b);
        }
        for (String name : new String(bytes).split(";")) {
            try {
                EntityType type = (EntityType)entityRegistry.getValue(new ResourceLocation(name));
                whitelist.add(type);
                FollowMe.logInfo("Synced config entity " + name + " from server");
            }
            catch (Exception e) {
                FollowMe.logError("Failed to sync config entity " + name + " from server " + e.getCause(), e);
            }
        }
        entityWhitelist = whitelist;
        return true;
    }

    public static void resetConfigSync() {
        entityWhitelist.clear();
    }

    static {
        entityWhitelist = new ArrayList();
        localEntityWhitelist = null;
        entityRegistry = ForgeRegistries.ENTITIES;
        builder.push("general");
        entityWhitelistBuilder = builder.comment("Entities that follow the player after sneak right-clicked. (uses the string format and either classname e.g. \"Villager\" or registry name e.g. \"minecraft:villager\")").define("entityWhitelist", (Object)Lists.newArrayList());
        shouldTeleport = builder.comment("Should following entities teleport when too far away (like wolves)?").define("shouldTeleport", true);
        teleportDistance = builder.comment("How far away do entities need to be away to teleport?").defineInRange("teleportDistance", 30.0, 0.0, 255.0);
        stopFollowDistance = builder.comment("How far away do entities need to be away to stop following?").defineInRange("stopFollowDistance", 60.0, 0.0, 255.0);
        builder.pop();
        config = builder.build();
    }
}

