/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.followme.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.smileycorp.atlas.api.util.DirectionUtils;
import net.smileycorp.followme.client.ClientConfigHandler;
import net.smileycorp.followme.common.CommonConfigHandler;
import net.smileycorp.followme.common.FollowMe;
import net.smileycorp.followme.common.ModDefinitions;
import net.smileycorp.followme.common.network.DenyFollowMessage;
import net.smileycorp.followme.common.network.FollowMessage;
import net.smileycorp.followme.common.network.FollowSyncMessage;
import net.smileycorp.followme.common.network.PacketHandler;
import net.smileycorp.followme.common.network.StopFollowMessage;

@Mod.EventBusSubscriber(modid="followme", value={Dist.CLIENT})
public class ClientHandler {
    private static ResourceLocation SPEECH_BUBBLE = ModDefinitions.getResource("textures/gui/follow.png");
    public static Set<Mob> FOLLOW_ENTITIES = new HashSet<Mob>();
    private static KeyMapping FOLLOW_KEY = new KeyMapping("key.followme.follow.desc", 72, "key.followme.category");
    private static KeyMapping STOP_KEY = new KeyMapping("key.followme.stop.desc", 74, "key.followme.category");

    public static void init() {
        ClientRegistry.registerKeyBinding((KeyMapping)FOLLOW_KEY);
        ClientRegistry.registerKeyBinding((KeyMapping)STOP_KEY);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public static void onEvent(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null) {
            Entity target;
            HitResult ray;
            Level level = player.f_19853_;
            if (FOLLOW_KEY.m_90857_() && (ray = DirectionUtils.getEntityRayTrace((Level)level, (Entity)player, (float)4.5f)) instanceof EntityHitResult && (target = ((EntityHitResult)ray).m_82443_()).isAddedToWorld() && target.m_6084_() && target instanceof Mob) {
                PacketHandler.NETWORK_INSTANCE.sendToServer((Object)new FollowMessage((Player)player, (Mob)target));
            }
            if (STOP_KEY.m_90857_()) {
                PacketHandler.NETWORK_INSTANCE.sendToServer((Object)new StopFollowMessage((Player)player));
            }
        }
    }

    @SubscribeEvent
    public void onlevelUnload(WorldEvent.Unload event) {
        if (event.getWorld().m_5776_()) {
            FOLLOW_ENTITIES.clear();
            CommonConfigHandler.resetConfigSync();
            FollowMe.logInfo("Cleared config from server.");
        }
    }

    @SubscribeEvent
    public void renderLiving(RenderNameplateEvent event) {
        Mob entity;
        if (event.getEntity() instanceof Mob && FOLLOW_ENTITIES.contains(entity = (Mob)event.getEntity())) {
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            if (player != null) {
                EntityRenderer renderer = event.getEntityRenderer();
                PoseStack pose = event.getPoseStack();
                pose.m_85836_();
                pose.m_85837_(0.0, (double)-0.2f, 0.0);
                TranslatableComponent text = new TranslatableComponent("text.followme.following");
                TextColor colour = ClientConfigHandler.getFollowMessageColour();
                if (((Boolean)ClientConfigHandler.followMessageUseTeamColour.get()).booleanValue() && entity.m_5647_() != null) {
                    colour = TextColor.m_131270_((ChatFormatting)entity.m_5647_().m_7414_());
                }
                text.m_6270_(Style.f_131099_.m_131148_(colour));
                renderer.m_7649_((Entity)entity, (Component)text, pose, event.getMultiBufferSource(), event.getPackedLight());
                pose.m_85849_();
            }
        }
    }

    public static void syncFollowEntities(FollowSyncMessage message) {
        Minecraft mc = Minecraft.m_91087_();
        Mob entity = message.getEntity((Level)mc.f_91073_);
        if (message.isUnfollow()) {
            FOLLOW_ENTITIES.remove(entity);
        } else {
            FOLLOW_ENTITIES.add(entity);
        }
    }

    public static void processEntityDeny(DenyFollowMessage message) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        Mob entity = message.getEntity((Level)level);
        Random rand = level.f_46441_;
        for (int i = 0; i < 6; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123792_, entity.m_20185_() + (double)rand.nextFloat(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f) + (double)rand.nextFloat(), entity.m_20189_() + (double)rand.nextFloat(), 0.0, (double)0.3f, 0.0);
        }
        level.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12507_, entity.m_5720_(), 0.3f, rand.nextFloat(), false);
    }
}

