/*
 * Decompiled with CFR 0.152.
 */
package reascer.epicsanji.skill;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import reascer.epicsanji.gameasset.OPXEFAnimations;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.PlayerEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillConsumeEvent;

public class DiableJambuSkill
extends WeaponInnateSkill {
    public static final SkillDataManager.SkillDataKey<Integer> TIMER = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    public static final SkillDataManager.SkillDataKey<Boolean> ACTIVE = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    public static final SkillDataManager.SkillDataKey<Boolean> TRANSFORMING = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    public static final SkillDataManager.SkillDataKey<Boolean> SUPERARMOR = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    private static final UUID EVENT_UUID = UUID.fromString("e11067da-3f5c-11ed-b878-0242ac120002");

    public DiableJambuSkill(Skill.Builder<?> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        container.getDataManager().registerData(TIMER);
        container.getDataManager().registerData(ACTIVE);
        container.getDataManager().registerData(TRANSFORMING);
        container.getDataManager().registerData(SUPERARMOR);
        if (!container.getExecuter().isLogicalClient()) {
            this.setMaxDurationSynchronize((ServerPlayerPatch)container.getExecuter(), 3600);
        }
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_PRE, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(ACTIVE)).booleanValue() && !((Boolean)container.getDataManager().getDataValue(TRANSFORMING)).booleanValue()) {
                event.setAttackDamage(event.getAttackDamage() * 1.5f);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(ACTIVE)).booleanValue() && !((Boolean)container.getDataManager().getDataValue(TRANSFORMING)).booleanValue()) {
                event.getTarget().m_20254_(5);
                ((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123744_, event.getTarget().m_20185_(), event.getTarget().m_20186_() + 1.2, event.getTarget().m_20189_(), 24, 0.0, 0.0, 0.0, 0.1);
                event.getTarget().m_5496_(SoundEvents.f_11937_, 1.0f, 1.0f);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(ACTIVE)).booleanValue() && !((Boolean)container.getDataManager().getDataValue(TRANSFORMING)).booleanValue()) {
                ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().setDataSync(TRANSFORMING, (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().setDataSync(SUPERARMOR, (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(SUPERARMOR)).booleanValue()) {
                ((EpicFightDamageSource)event.getDamageSource()).setStunType(StunType.NONE);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_PRE, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID);
        if (!container.getExecuter().isLogicalClient()) {
            container.getSkill().cancelOnServer((ServerPlayerPatch)container.getExecuter(), null);
        }
        container.deactivate();
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        if (executer.getSkill((Skill)this).isActivated()) {
            this.cancelOnServer(executer, args);
            executer.getSkill((Skill)this).getDataManager().setDataSync(ACTIVE, (Object)false, (ServerPlayer)executer.getOriginal());
            this.setDurationSynchronize(executer, 0);
            this.setStackSynchronize(executer, executer.getSkill((Skill)this).getStack() - 1);
            executer.getSkill((Skill)this).deactivate();
            executer.modifyLivingMotionByCurrentItem();
        } else {
            executer.playAnimationSynchronized(OPXEFAnimations.SANJI_DIABLE, 0.0f);
            executer.getSkill((Skill)this).getDataManager().setDataSync(TIMER, (Object)((30 + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)executer.getOriginal())) * 10) * 20), (ServerPlayer)executer.getOriginal());
            executer.getSkill((Skill)this).getDataManager().setDataSync(SUPERARMOR, (Object)true, (ServerPlayer)executer.getOriginal());
            SkillConsumeEvent event = new SkillConsumeEvent((PlayerPatch)executer, (Skill)this, this.resource, true);
            executer.getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, (PlayerEvent)event);
            if (!event.isCanceled()) {
                event.getResourceType().consumer.consume((Skill)this, executer, event.getAmount());
            }
            executer.getSkill((Skill)this).activate();
            executer.modifyLivingMotionByCurrentItem();
        }
    }

    public void cancelOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        super.cancelOnServer(executer, args);
        executer.getSkill((Skill)this).getDataManager().setDataSync(ACTIVE, (Object)false, (ServerPlayer)executer.getOriginal());
        ((ServerPlayer)executer.getOriginal()).m_21195_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get());
        this.setStackSynchronize(executer, executer.getSkill((Skill)this).getStack() - 1);
        this.setDurationSynchronize(executer, 0);
        executer.modifyLivingMotionByCurrentItem();
    }

    public boolean canExecute(PlayerPatch<?> executer) {
        if (executer.isLogicalClient()) {
            return super.canExecute(executer);
        }
        ItemStack itemstack = ((Player)executer.getOriginal()).m_21205_();
        return EpicFightCapabilities.getItemStackCapability((ItemStack)itemstack).getInnateSkill(executer, itemstack) == this && ((Player)executer.getOriginal()).m_20202_() == null;
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        executer.updateEntityState();
        EntityState playerState = executer.getEntityState();
        return !((Player)executer.getOriginal()).m_21255_() && executer.currentLivingMotion != LivingMotions.FALL && playerState.canUseSkill() && executer.getEntityState().canBasicAttack();
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        List list = super.getTooltipOnItem(itemStack, cap, playerCap);
        return list;
    }

    public void updateContainer(SkillContainer container) {
        PlayerPatch entitypatch;
        super.updateContainer(container);
        if (((Boolean)container.getDataManager().getDataValue(ACTIVE)).booleanValue()) {
            entitypatch = container.getExecuter();
            int numberOf = 7;
            float partialScale = 1.0f / (float)(numberOf - 1);
            float interpolation = 0.0f;
            for (int i = 0; i < numberOf; ++i) {
                OpenMatrix4f transformMatrix2 = entitypatch.getArmature().getBindedTransformFor(entitypatch.getArmature().getPose(interpolation), Armatures.BIPED.legR);
                transformMatrix2.translate(new Vec3f(0.0f, 0.0f, 0.0f));
                OpenMatrix4f.mul((OpenMatrix4f)new OpenMatrix4f().rotate(-((float)Math.toRadians(((Player)entitypatch.getOriginal()).f_20884_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f)), (OpenMatrix4f)transformMatrix2, (OpenMatrix4f)transformMatrix2);
                ((Player)entitypatch.getOriginal()).f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)transformMatrix2.m30 + ((Player)entitypatch.getOriginal()).m_20185_() + (double)((new Random().nextFloat() - 0.5f) * 0.2f), (double)transformMatrix2.m31 + ((Player)entitypatch.getOriginal()).m_20186_() + (double)((new Random().nextFloat() - 1.0f) * 0.3f), (double)transformMatrix2.m32 + ((Player)entitypatch.getOriginal()).m_20189_() + (double)((new Random().nextFloat() - 0.5f) * 0.2f), (double)((new Random().nextFloat() - 0.5f) * 0.025f), (double)((new Random().nextFloat() - 0.5f) * 0.025f), (double)((new Random().nextFloat() - 0.5f) * 0.025f));
                interpolation += partialScale;
            }
            if (!container.getExecuter().isLogicalClient()) {
                if ((Integer)container.getDataManager().getDataValue(TIMER) > 0) {
                    container.getDataManager().setDataSync(TIMER, (Object)((Integer)container.getDataManager().getDataValue(TIMER) - 1), (ServerPlayer)container.getExecuter().getOriginal());
                    this.setDurationSynchronize((ServerPlayerPatch)container.getExecuter(), (int)((float)((Integer)container.getDataManager().getDataValue(TIMER)).intValue() / 20.0f));
                } else {
                    container.getSkill().cancelOnServer((ServerPlayerPatch)container.getExecuter(), null);
                    this.setDurationSynchronize((ServerPlayerPatch)container.getExecuter(), 0);
                    container.deactivate();
                }
            }
        }
        if (((Boolean)container.getDataManager().getDataValue(TRANSFORMING)).booleanValue()) {
            entitypatch = container.getExecuter();
            for (int j = 0; j < 14; ++j) {
                ((Player)entitypatch.getOriginal()).f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, ((Player)entitypatch.getOriginal()).m_20185_(), ((Player)entitypatch.getOriginal()).m_20186_() + (double)0.03f, ((Player)entitypatch.getOriginal()).m_20189_(), (double)((new Random().nextFloat() - 0.5f) * 0.35f), (double)((new Random().nextFloat() - 0.5f) * 0.05f), (double)((new Random().nextFloat() - 0.5f) * 0.35f));
            }
        }
    }
}

