/*
 * Decompiled with CFR 0.152.
 */
package reascer.epicsanji.skill;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.epicsanji.gameasset.OPXEFSounds;
import reascer.epicsanji.particle.OPXEFParticles;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.guard.GuardSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ArmementHakiSkill
extends GuardSkill {
    public static final SkillDataManager.SkillDataKey<Integer> COOLDOWN = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    public static final SkillDataManager.SkillDataKey<Integer> MASSAGE_COOLDOWN = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    public static final SkillDataManager.SkillDataKey<Boolean> CHARGING = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    public static final SkillDataManager.SkillDataKey<Boolean> ACTIVE = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    public static final SkillDataManager.SkillDataKey<Boolean> RENDER_HAKI_HIT = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    public static final SkillDataManager.SkillDataKey<Boolean> RENDER_HAKI_HURT = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    protected static final UUID EVENT_UUID = UUID.fromString("b422f7a0-f378-11eb-9a03-0242ac130003");

    public ArmementHakiSkill(GuardSkill.Builder builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        container.getDataManager().registerData(COOLDOWN);
        container.getDataManager().registerData(MASSAGE_COOLDOWN);
        container.getDataManager().registerData(CHARGING);
        container.getDataManager().registerData(ACTIVE);
        container.getDataManager().registerData(RENDER_HAKI_HIT);
        container.getDataManager().registerData(RENDER_HAKI_HURT);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, GuardSkill.EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_PRE, GuardSkill.EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, GuardSkill.EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, GuardSkill.EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_POST, GuardSkill.EVENT_UUID);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            if (((ServerPlayerPatch)event.getPlayerPatch()).getStamina() > 0.0f) {
                container.getDataManager().setDataSync(CHARGING, (Object)true, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                container.getDataManager().setDataSync(COOLDOWN, (Object)5, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_STOP_EVENT, EVENT_UUID, event -> {});
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_PRE, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(CHARGING)).booleanValue() && ((ServerPlayerPatch)event.getPlayerPatch()).getStamina() > 0.0f) {
                event.setAttackDamage(event.getAttackDamage() * 1.5f);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(CHARGING)).booleanValue()) {
                if (((ServerPlayerPatch)event.getPlayerPatch()).getStamina() > 0.0f) {
                    ((ServerPlayerPatch)event.getPlayerPatch()).setStamina(((ServerPlayerPatch)event.getPlayerPatch()).getStamina() - 1.0f);
                    ((ServerLevel)((Player)container.getExecuter().getOriginal()).f_19853_).m_8767_((ParticleOptions)((HitParticleType)OPXEFParticles.ARMEMENT_HAKI_HIT.get()), event.getTarget().f_19854_, event.getTarget().f_19855_ + 0.75, event.getTarget().f_19856_, 1, 0.0, 0.0, 0.0, 0.0);
                    container.getDataManager().setDataSync(RENDER_HAKI_HIT, (Object)true, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                } else {
                    container.getDataManager().setDataSync(CHARGING, (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                }
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(CHARGING)).booleanValue() && ((ServerPlayerPatch)event.getPlayerPatch()).getStamina() > 0.0f) {
                event.setAmount(event.getAmount() / 2.0f);
                ((ServerPlayerPatch)event.getPlayerPatch()).setStamina(((ServerPlayerPatch)event.getPlayerPatch()).getStamina() - 2.0f);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(CHARGING)).booleanValue() && ((ServerPlayerPatch)event.getPlayerPatch()).getStamina() > 0.0f) {
                container.getDataManager().setDataSync(RENDER_HAKI_HURT, (Object)true, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                ((ServerLevel)((Player)container.getExecuter().getOriginal()).f_19853_).m_8767_((ParticleOptions)((HitParticleType)OPXEFParticles.ARMEMENT_HAKI_HIT.get()), ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_() + 0.75, ((Player)container.getExecuter().getOriginal()).m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(CHARGING)).booleanValue()) {
                if (!((Boolean)container.getDataManager().getDataValue(ACTIVE)).booleanValue()) {
                    ((ServerPlayerPatch)event.getPlayerPatch()).playSound(OPXEFSounds.ARMEMENT_HAKI, 0.7f, 1.0f, 1.0f);
                }
                container.getDataManager().setDataSync(ACTIVE, (Object)true, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_PRE, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID);
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        EntityState playerState = executer.getEntityState();
        return !executer.isUnstable() && !playerState.hurt() && executer.isBattleMode();
    }

    protected boolean isBlockableSource(DamageSource damageSource, boolean advanced) {
        return !damageSource.m_19378_() && !damageSource.m_19376_() && !damageSource.m_19360_() && !damageSource.m_19372_() && !damageSource.m_19387_() && !damageSource.m_19384_();
    }

    protected boolean isAdvancedGuard() {
        return true;
    }

    protected Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> getGuradMotionMap(GuardSkill.BlockType blockType) {
        switch (blockType) {
            case GUARD_BREAK: {
                return this.guardBreakMotions;
            }
            case GUARD: {
                return this.guardMotions;
            }
            case ADVANCED_GUARD: {
                return this.advancedGuardMotions;
            }
        }
        throw new IllegalArgumentException("unsupported block type " + blockType);
    }

    protected boolean isHoldingWeaponAvailable(PlayerPatch<?> playerpatch, CapabilityItem itemCapability, GuardSkill.BlockType blockType) {
        Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> guardMotions = this.getGuradMotionMap(blockType);
        if (!guardMotions.containsKey(itemCapability.getWeaponCategory())) {
            return false;
        }
        Object motion = guardMotions.get(itemCapability.getWeaponCategory()).apply(itemCapability, playerpatch);
        return motion != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return (Boolean)container.getDataManager().getDataValue(CHARGING);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, PoseStack poseStack, float x, float y) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)gui.getSlidingProgression(), 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getSkillTexture());
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiComponent.m_93160_((PoseStack)poseStack, (int)((int)x), (int)((int)y), (int)24, (int)24, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
        poseStack.m_85849_();
    }

    public void updateContainer(SkillContainer container) {
        if (((Boolean)container.getDataManager().getDataValue(RENDER_HAKI_HIT)).booleanValue()) {
            ((Player)container.getExecuter().getOriginal()).f_19853_.m_7106_((ParticleOptions)OPXEFParticles.ARMEMENT_HAKI.get(), ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), Double.longBitsToDouble(((Player)container.getExecuter().getOriginal()).m_142049_()), 0.0, 0.0);
            if (!container.getExecuter().isLogicalClient()) {
                container.getDataManager().setDataSync(RENDER_HAKI_HIT, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
        }
        if (((Boolean)container.getDataManager().getDataValue(RENDER_HAKI_HURT)).booleanValue()) {
            ((Player)container.getExecuter().getOriginal()).f_19853_.m_7106_((ParticleOptions)OPXEFParticles.ARMEMENT_HAKI_HIT.get(), ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_() + 0.75, ((Player)container.getExecuter().getOriginal()).m_20189_(), Double.longBitsToDouble(((Player)container.getExecuter().getOriginal()).m_142049_()), 0.0, 0.0);
            if (!container.getExecuter().isLogicalClient()) {
                container.getDataManager().setDataSync(RENDER_HAKI_HURT, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
        }
        if ((Integer)container.getDataManager().getDataValue(COOLDOWN) > 0) {
            if (!container.getExecuter().isLogicalClient()) {
                container.getDataManager().setData(COOLDOWN, (Object)((Integer)container.getDataManager().getDataValue(COOLDOWN) - 1));
            }
        } else {
            container.getDataManager().setData(COOLDOWN, (Object)0);
            if (!container.getExecuter().isLogicalClient()) {
                container.getDataManager().setDataSync(CHARGING, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                container.getDataManager().setDataSync(ACTIVE, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
        }
    }
}

