/*
 * Decompiled with CFR 0.152.
 */
package reascer.epicsanji.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.epicsanji.client.model.OPXEFClientModels;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.client.particle.EpicFightParticleRenderTypes;
import yesman.epicfight.client.particle.TexturedCustomModelParticle;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class ConquerorHakiParticle
extends TexturedCustomModelParticle {
    private LivingEntityPatch<?> caster;

    public ConquerorHakiParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, Mesh.RawMesh particleMesh, ResourceLocation texture) {
        super(level, x, y, z, xd, yd, zd, particleMesh, texture);
        this.f_107225_ = 5;
        this.f_107219_ = false;
        this.f_107231_ = (float)xd;
        this.pitch = (float)zd;
        this.scale = 12.0f;
        Entity entity = level.m_6815_((int)Double.doubleToLongBits(yd));
        if (entity != null) {
            this.caster = (LivingEntityPatch)entity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
        }
    }

    public ParticleRenderType m_7556_() {
        return EpicFightParticleRenderTypes.PARTICLE_MODEL_NO_NORMAL;
    }

    public void m_5989_() {
        super.m_5989_();
        this.yaw += 36.0f;
        this.scale += (float)Math.max(30 - this.f_107224_, 0) * 4.0f;
        this.f_107230_ = (float)(this.f_107225_ - this.f_107224_) / (float)this.f_107225_ * 2.0f;
        if (this.caster != null && this.caster.getStunShield() <= 0.0f) {
            this.m_107274_();
        }
    }

    protected void setupPoseStack(PoseStack poseStack, Camera camera, float partialTicks) {
        float yaw = Mth.m_14179_((float)partialTicks, (float)this.yawO, (float)this.yaw);
        Vec3 vec3 = camera.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float z = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        float scale = (float)Mth.m_14139_((double)partialTicks, (double)this.scaleO, (double)this.scale);
        poseStack.m_85837_((double)x, (double)y, (double)z);
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(this.pitch));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(this.f_107231_));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(yaw));
        poseStack.m_85841_(scale, scale, scale);
    }

    public int m_6355_(float p_107086_) {
        int i = super.m_6355_(p_107086_);
        int k = i >> 16 & 0xFF;
        return 0xF0 | k << 16;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ConquerorHakiParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, OPXEFClientModels.CONQUEROR_HAKI, new ResourceLocation("epicfight", "textures/models/particle/conqueror_haki.png"));
        }
    }
}

