/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.misc;

import lykrast.meetyourfight.registry.ModItems;
import lykrast.meetyourfight.registry.ModSounds;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber(modid="meetyourfight")
public class EventHandler {
    @SubscribeEvent
    public static void entityDamage(LivingHurtEvent event) {
        LivingEntity attacked = event.getEntityLiving();
        if (attacked instanceof Player) {
            Player pattacked = (Player)attacked;
            if (!event.isCanceled() && CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)pattacked, ModItems.aceOfIron).isPresent()) {
                float luck = pattacked.m_36336_();
                double chance = 0.16666666666666666;
                chance = luck >= 0.0f ? (1.0 + (double)luck) / (6.0 + (double)(2.0f * luck)) : 1.0 / (6.0 - (double)(3.0f * luck));
                if (pattacked.m_21187_().nextDouble() <= chance) {
                    event.setCanceled(true);
                    pattacked.f_19853_.m_5594_(null, attacked.m_142538_(), ModSounds.aceOfIronProc, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
        if (event.isCanceled()) {
            return;
        }
        Entity attacker = event.getSource().m_7639_();
        if (attacker != null && attacker instanceof Player) {
            Player pattacker = (Player)attacker;
            if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)pattacker, ModItems.slicersDice).isPresent()) {
                float luck = pattacker.m_36336_();
                double chance = 0.2;
                chance = luck >= 0.0f ? (1.0 + (double)luck) / (5.0 + (double)luck) : 1.0 / (5.0 - (double)(3.0f * luck));
                if (pattacker.m_21187_().nextDouble() <= chance) {
                    event.setAmount(event.getAmount() * 2.0f);
                    pattacker.f_19853_.m_5594_(null, attacked.m_142538_(), ModSounds.slicersDiceProc, SoundSource.PLAYERS, 1.0f, 1.0f);
                    ((ServerLevel)pattacker.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123797_, attacked.m_20185_(), attacked.m_20188_(), attacked.m_20189_(), 15, 0.2, 0.2, 0.2, 0.0);
                }
            }
        }
        if (attacked instanceof Player) {
            Player pattacked = (Player)attacked;
            if (!event.isCanceled() && CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)pattacked, ModItems.cagedHeart).isPresent()) {
                float treshold = pattacked.m_21233_() / 4.0f;
                if (event.getAmount() > treshold) {
                    event.setAmount((event.getAmount() - treshold) * 0.5f + treshold);
                    pattacked.f_19853_.m_5594_(null, attacked.m_142538_(), ModSounds.cagedHeartProc, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        if (stack.m_41720_() instanceof ICurio && stack.m_41720_().getRegistryName().m_135827_().equals("meetyourfight")) {
            event.addCapability(CuriosCapability.ID_ITEM, (ICapabilityProvider)new Provider((ICurio)stack.m_41720_()));
        }
    }

    private static class Provider
    implements ICapabilityProvider {
        private LazyOptional<ICurio> curio = LazyOptional.of(() -> curio);

        public Provider(ICurio curio) {
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return CuriosCapability.ITEM.orEmpty(cap, this.curio);
        }
    }
}

