/*
 * Decompiled with CFR 0.152.
 */
package com.itayfeder.restored_earth.events;

import com.itayfeder.restored_earth.init.EntityInit;
import com.itayfeder.restored_earth.utils.Config;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="restored_earth", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WorldSpawnEventHandler {
    public static void Setup() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityInit.VILER_WITCH.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityInit.BOULDERING_ZOMBIE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityInit.SKELETON_WOLF.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityInit.BONE_SPIDER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityInit.LOBBER_ZOMBIE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void biomeLoad(BiomeLoadingEvent event) {
        ResourceKey biome = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)event.getName());
        if (BiomeDictionary.hasType((ResourceKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD)) {
            if (BiomeDictionary.hasType((ResourceKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || event.getName().toString().contains("minecraft:grove") || event.getName().toString().contains("minecraft:snowy_slopes")) {
                if (((Boolean)Config.WOOLY_COW_SPAWNING.get()).booleanValue()) {
                    event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)EntityInit.WOOLY_COW.get(), 8, 4, 4));
                }
                if (((Boolean)Config.WOOLY_COW_SPAWNING.get()).booleanValue()) {
                    WorldSpawnEventHandler.ReplaceCurrentMobSpawnWithNew(event.getSpawns(), MobCategory.CREATURE, EntityType.f_20557_, (EntityType)EntityInit.WOOLY_COW.get());
                }
            }
            if ((event.getName().toString().contains("minecraft:old_growth_pine_taiga") || event.getName().toString().contains("minecraft:old_growth_spruce_taiga")) && ((Boolean)Config.JUMBO_RABBIT_SPAWNING.get()).booleanValue()) {
                event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)EntityInit.JUMBO_RABBIT.get(), 4, 2, 3));
            }
            if (event.getName().toString().contains("minecraft:flower_forest")) {
                if (((Boolean)Config.FANCY_CHICKEN_SPAWNING.get()).booleanValue()) {
                    WorldSpawnEventHandler.ReplaceCurrentMobSpawnWithNew(event.getSpawns(), MobCategory.CREATURE, EntityType.f_20555_, (EntityType)EntityInit.FANCY_CHICKEN.get());
                }
                if (!ModList.get().isLoaded("buzzier_bees") && ((Boolean)Config.MOOBLOOM_SPAWNING.get()).booleanValue()) {
                    WorldSpawnEventHandler.ReplaceCurrentMobSpawnWithNew(event.getSpawns(), MobCategory.CREATURE, EntityType.f_20557_, (EntityType)EntityInit.MOOBLOOM.get());
                }
                if (((Boolean)Config.MOOLIP_SPAWNING.get()).booleanValue()) {
                    event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)EntityInit.MOOLIP.get(), 8, 4, 4));
                }
            }
            if ((BiomeDictionary.hasType((ResourceKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || event.getName().toString().contains("minecraft:meadow")) && ((Boolean)Config.RAINBOW_SHEEP_SPAWNING.get()).booleanValue()) {
                event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)EntityInit.RAINBOW_SHEEP.get(), 1, 1, 1));
            }
            if ((event.getName().toString().contains("minecraft:snowy_peaks") || event.getName().toString().contains("minecraft:jagged_peaks") || event.getName().toString().contains("minecraft:grove") || event.getName().toString().contains("minecraft:snowy_slopes")) && ((Boolean)Config.JOLLY_LLAMA_SPAWNING.get()).booleanValue()) {
                event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)EntityInit.JOLLY_LLAMA.get(), 4, 2, 3));
            }
            if (!(BiomeDictionary.hasType((ResourceKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM) || BiomeDictionary.hasType((ResourceKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) || BiomeDictionary.hasType((ResourceKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH))) {
                if (((Boolean)Config.VILER_WITCH_SPAWNING.get()).booleanValue()) {
                    event.getSpawns().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)EntityInit.VILER_WITCH.get(), 3, 1, 1));
                }
                if (((Boolean)Config.BOULDERING_ZOMBIE_SPAWNING.get()).booleanValue()) {
                    event.getSpawns().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)EntityInit.BOULDERING_ZOMBIE.get(), 6, 1, 1));
                }
                if (((Boolean)Config.LOBBER_ZOMBIE_SPAWNING.get()).booleanValue()) {
                    event.getSpawns().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)EntityInit.LOBBER_ZOMBIE.get(), 6, 1, 1));
                }
            }
            if ((event.getName().toString().contains("minecraft:beach") || event.getName().toString().contains("minecraft:stone_shore")) && ((Boolean)Config.TROPICAL_SLIME_SPAWNING.get()).booleanValue()) {
                event.getSpawns().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)EntityInit.TROPICAL_SLIME.get(), 25, 1, 1));
            }
            if (event.getName().toString().contains("taiga") && ((Boolean)Config.SKELETON_WOLF_SPAWNING.get()).booleanValue()) {
                event.getSpawns().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)EntityInit.SKELETON_WOLF.get(), 25, 3, 4));
            }
            if (event.getName().toString().contains("dark_forest") && ((Boolean)Config.BONE_SPIDER_SPAWNING.get()).booleanValue()) {
                event.getSpawns().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)EntityInit.BONE_SPIDER.get(), 20, 1, 2));
            }
            if (BiomeDictionary.hasType((ResourceKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM) && ((Boolean)Config.CLUCKSHROOM_SPAWNING.get()).booleanValue()) {
                event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)EntityInit.CLUCKSHROOM.get(), 8, 4, 4));
            }
        }
    }

    public static void ReplaceCurrentMobSpawnWithNew(MobSpawnSettingsBuilder builder, MobCategory spawnType, EntityType<?> replacedEntity, EntityType<?> replacingEntity) {
        List spawnList = builder.getSpawner(spawnType);
        for (int i = 0; i < spawnList.size(); ++i) {
            MobSpawnSettings.SpawnerData entry = (MobSpawnSettings.SpawnerData)spawnList.get(i);
            int weight = entry.m_142631_().m_146281_();
            int minCount = entry.f_48405_;
            int maxCount = entry.f_48406_;
            EntityType type = entry.f_48404_;
            if (type != replacedEntity) continue;
            MobSpawnSettings.SpawnerData replaceType = new MobSpawnSettings.SpawnerData(replacingEntity, weight, minCount, maxCount);
            spawnList.set(i, replaceType);
        }
    }
}

