/*
 * Decompiled with CFR 0.152.
 */
package com.itayfeder.restored_earth.entities;

import com.itayfeder.restored_earth.init.EntityInit;
import com.itayfeder.restored_earth.utils.ModLootTables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.IForgeShearable;

public class WoolyCow
extends Cow
implements IForgeShearable {
    private static final EntityDataAccessor<Boolean> DATA_SHEARED_ID = SynchedEntityData.m_135353_(WoolyCow.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private EatBlockGoal eatBlockGoal;
    private int eatAnimationTick;

    public WoolyCow(EntityType<? extends Cow> p_28285_, Level p_28286_) {
        super((EntityType)EntityInit.WOOLY_COW.get(), p_28286_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.eatBlockGoal = new EatBlockGoal((Mob)this);
        this.f_21345_.m_25352_(5, (Goal)this.eatBlockGoal);
    }

    protected void m_8024_() {
        this.eatAnimationTick = this.eatBlockGoal.m_25213_();
        super.m_8024_();
    }

    public void m_8107_() {
        if (this.f_19853_.f_46443_) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
        super.m_8107_();
    }

    public WoolyCow getBreedOffspring(ServerLevel p_148890_, AgeableMob p_148891_) {
        return (WoolyCow)((EntityType)EntityInit.WOOLY_COW.get()).m_20615_((Level)p_148890_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SHEARED_ID, (Object)false);
    }

    public void m_7380_(CompoundTag p_29864_) {
        super.m_7380_(p_29864_);
        p_29864_.m_128379_("Sheared", this.isSheared());
    }

    public void m_7378_(CompoundTag p_29845_) {
        super.m_7378_(p_29845_);
        this.setSheared(p_29845_.m_128471_("Sheared"));
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SHEARED_ID);
    }

    public void setSheared(boolean p_29568_) {
        this.f_19804_.m_135381_(DATA_SHEARED_ID, (Object)p_29568_);
    }

    public void m_8035_() {
        this.setSheared(false);
        if (this.m_6162_()) {
            this.m_146758_(60);
        }
    }

    public boolean readyForShearing() {
        return this.m_6084_() && !this.isSheared() && !this.m_6162_();
    }

    public boolean isShearable(@Nonnull ItemStack item, Level world, BlockPos pos) {
        return this.readyForShearing();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level world, BlockPos pos, int fortune) {
        world.m_6269_(null, (Entity)this, SoundEvents.f_12344_, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!world.f_46443_) {
            this.setSheared(true);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.add(new ItemStack((ItemLike)Items.f_41935_, 1));
            return items;
        }
        return Collections.emptyList();
    }

    public void m_7822_(byte p_29814_) {
        if (p_29814_ == 10) {
            this.eatAnimationTick = 40;
        } else {
            super.m_7822_(p_29814_);
        }
    }

    public float getHeadEatPositionScale(float p_29881_) {
        if (this.eatAnimationTick <= 0) {
            return 0.0f;
        }
        if (this.eatAnimationTick >= 4 && this.eatAnimationTick <= 36) {
            return 1.0f;
        }
        return this.eatAnimationTick < 4 ? ((float)this.eatAnimationTick - p_29881_) / 4.0f : -((float)(this.eatAnimationTick - 40) - p_29881_) / 4.0f;
    }

    public float getHeadEatAngleScale(float p_29883_) {
        if (this.eatAnimationTick > 4 && this.eatAnimationTick <= 36) {
            float f = ((float)(this.eatAnimationTick - 4) - p_29883_) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.m_14031_((float)(f * 28.7f));
        }
        return this.eatAnimationTick > 0 ? 0.62831855f : this.m_146909_() * ((float)Math.PI / 180);
    }

    public ResourceLocation m_7582_() {
        if (this.isSheared()) {
            return EntityType.f_20557_.m_20677_();
        }
        return ModLootTables.COW_WOOLY;
    }
}

