/*
 * Decompiled with CFR 0.152.
 */
package com.itayfeder.restored_earth.client.gui.screen;

import com.itayfeder.restored_earth.init.EntityInit;
import com.itayfeder.restored_earth.utils.JournalEntry;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.RenderProperties;

public class JournalScreen
extends Screen {
    public static final ResourceLocation BOOK_LOCATION = new ResourceLocation("restored_earth", "textures/gui/journal.png");
    private int currentPage;
    private int cachedPage = -1;
    private Component pageMsg = TextComponent.f_131282_;
    private PageButton forwardButton;
    private PageButton backButton;
    private final boolean playTurnSound;
    private final Level world;

    public JournalScreen(Level world, boolean p_i51099_2_) {
        super(NarratorChatListener.f_93310_);
        this.world = world;
        this.playTurnSound = p_i51099_2_;
        this.currentPage = Mth.m_14045_((int)this.currentPage, (int)0, (int)JournalScreen.getPageCount());
        this.cachedPage = -1;
    }

    public static void open(Level world) {
        Minecraft.m_91087_().m_91152_((Screen)new JournalScreen(world, true));
    }

    public boolean setPage(int p_214160_1_) {
        int i = Mth.m_14045_((int)p_214160_1_, (int)0, (int)(JournalScreen.getPageCount() - 1));
        if (i != this.currentPage) {
            this.currentPage = i;
            this.updateButtonVisibility();
            this.cachedPage = -1;
            return true;
        }
        return false;
    }

    protected boolean forcePage(int p_214153_1_) {
        return this.setPage(p_214153_1_);
    }

    protected void m_7856_() {
        this.createMenuControls();
        this.createPageControlButtons();
    }

    protected void createMenuControls() {
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, 196, 200, 20, CommonComponents.f_130655_, p_214161_1_ -> this.f_96541_.m_91152_((Screen)null)));
    }

    protected void createPageControlButtons() {
        int i = (this.f_96543_ - 192) / 2;
        int j = 2;
        this.forwardButton = (PageButton)this.m_142416_((GuiEventListener)new PageButton(i + 116, 159, true, p_214159_1_ -> this.pageForward(), this.playTurnSound));
        this.backButton = (PageButton)this.m_142416_((GuiEventListener)new PageButton(i + 43, 159, false, p_214158_1_ -> this.pageBack(), this.playTurnSound));
        this.updateButtonVisibility();
    }

    protected void pageBack() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        this.updateButtonVisibility();
    }

    protected void pageForward() {
        if (this.currentPage < this.getPageCount() - 1) {
            ++this.currentPage;
        }
        this.updateButtonVisibility();
    }

    private void updateButtonVisibility() {
        this.forwardButton.f_93624_ = this.currentPage < this.getPageCount() - 1;
        this.backButton.f_93624_ = this.currentPage > 0;
    }

    private static int getPageCount() {
        return EntityInit.JOURNAL_ENTRIES.length;
    }

    public boolean m_7933_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (super.m_7933_(p_231046_1_, p_231046_2_, p_231046_3_)) {
            return true;
        }
        switch (p_231046_1_) {
            case 266: {
                this.backButton.m_5691_();
                return true;
            }
            case 267: {
                this.forwardButton.m_5691_();
                return true;
            }
        }
        return false;
    }

    public void m_6305_(PoseStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        this.m_7333_(p_230430_1_);
        float xMouse = p_230430_2_;
        float yMouse = p_230430_3_;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BOOK_LOCATION);
        int i = (this.f_96543_ - 192) / 2;
        int j = 2;
        this.m_93228_(p_230430_1_, i, 2, 0, 0, 192, 192);
        if (this.cachedPage != this.currentPage) {
            this.pageMsg = new TranslatableComponent("book.pageIndicator", new Object[]{this.currentPage + 1, Math.max(JournalScreen.getPageCount(), 1)});
        }
        this.cachedPage = this.currentPage;
        int i1 = this.f_96547_.m_92852_((FormattedText)this.pageMsg);
        this.f_96547_.m_92889_(p_230430_1_, this.pageMsg, (float)(i - i1 + 192 - 44), 18.0f, 0);
        float animalWidth = this.f_96543_ / 2 - 4;
        float animalHeight = 86.0f;
        JournalEntry entry = EntityInit.JOURNAL_ENTRIES[this.currentPage];
        EntityType type = entry.type;
        float size = entry.size;
        EntityType family = entry.family;
        Item egg = entry.egg;
        InventoryScreen.m_98850_((int)((int)animalWidth), (int)((int)animalHeight), (int)((int)size), (float)(animalWidth - xMouse), (float)(animalHeight - yMouse), (LivingEntity)((LivingEntity)type.m_20615_(this.world)));
        this.f_96547_.m_92889_(p_230430_1_, (Component)new TextComponent("Name: " + this.getName("entity.restored_earth." + type.getRegistryName().m_135815_())), (float)(i + 36), 104.0f, 0);
        this.f_96547_.m_92889_(p_230430_1_, (Component)new TextComponent("Health: " + DefaultAttributes.m_22297_((EntityType)type).m_22245_(Attributes.f_22276_) / 2.0 + "\uf900"), (float)(i + 36), 113.0f, 0);
        this.f_96547_.m_92889_(p_230430_1_, (Component)new TextComponent("Family: " + this.getName("entity.minecraft." + family.getRegistryName().m_135815_())), (float)(i + 36), 122.0f, 0);
        this.renderFloatingItem(new ItemStack((ItemLike)egg), i + 40, 86, null);
        super.m_6305_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
    }

    private String getName(String str) {
        Language language = Language.m_128107_();
        return language.m_6834_(str);
    }

    public boolean m_6375_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        return super.m_6375_(p_231044_1_, p_231044_3_, p_231044_5_);
    }

    public boolean m_5561_(Style p_98293_) {
        ClickEvent clickevent = p_98293_.m_131182_();
        if (clickevent == null) {
            return false;
        }
        if (clickevent.m_130622_() == ClickEvent.Action.CHANGE_PAGE) {
            String s = clickevent.m_130623_();
            try {
                int i = Integer.parseInt(s) - 1;
                return this.forcePage(i);
            }
            catch (Exception exception) {
                return false;
            }
        }
        boolean flag = super.m_5561_(p_98293_);
        if (flag && clickevent.m_130622_() == ClickEvent.Action.RUN_COMMAND) {
            this.closeScreen();
        }
        return flag;
    }

    protected void closeScreen() {
        this.f_96541_.m_91152_((Screen)null);
    }

    private void renderFloatingItem(ItemStack p_97783_, int p_97784_, int p_97785_, String p_97786_) {
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85837_(0.0, 0.0, 32.0);
        RenderSystem.m_157182_();
        this.m_93250_(200);
        this.f_96542_.f_115093_ = 200.0f;
        Font font = RenderProperties.get((ItemStack)p_97783_).getFont(p_97783_);
        if (font == null) {
            font = this.f_96547_;
        }
        this.f_96542_.m_115203_(p_97783_, p_97784_, p_97785_);
        this.f_96542_.m_115174_(font, p_97783_, p_97784_, p_97785_ - 0, p_97786_);
        this.m_93250_(0);
        this.f_96542_.f_115093_ = 0.0f;
    }
}

