/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Random;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.HerbJar;
import net.joefoxe.hexerei.block.custom.PickableDoubleFlower;
import net.joefoxe.hexerei.block.custom.PickableFlower;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.CustomItemRenderer;
import net.joefoxe.hexerei.item.custom.FlowerOutputItem;
import net.joefoxe.hexerei.tileentity.HerbJarTile;
import net.joefoxe.hexerei.tileentity.renderer.HerbJarRenderer;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.RenderProperties;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class HerbJarItemRenderer
extends CustomItemRenderer {
    private HerbJarRenderer renderer;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderByItem(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.2, -0.1, -0.1);
        BlockItem item = (BlockItem)stack.m_41720_();
        BlockState state = (BlockState)item.m_40614_().m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.SOUTH);
        Minecraft.m_91087_().m_91289_().renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
        matrixStackIn.m_85849_();
        this.renderTileStuff(stack.m_41784_(), stack, transformType, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    public static int getCustomColor(CompoundTag tag) {
        CompoundTag compoundtag = tag.m_128441_("display") ? tag.m_128469_("display") : null;
        return compoundtag != null && compoundtag.m_128425_("color", 99) ? compoundtag.m_128451_("color") : 4337438;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static HerbJarTile loadBlockEntityFromItem(CompoundTag tag, ItemStack item) {
        BlockItem blockItem;
        Block block;
        Item item2 = item.m_41720_();
        if (item2 instanceof BlockItem && (block = (blockItem = (BlockItem)item2).m_40614_()) instanceof HerbJar) {
            HerbJar herbJar = (HerbJar)block;
            HerbJarTile te = (HerbJarTile)herbJar.m_142194_(BlockPos.f_121853_, (BlockState)((BlockState)block.m_49966_().m_61124_((Property)HerbJar.GUI_RENDER, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.SOUTH));
            te.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
            te.dyeColor = HerbJarItemRenderer.getCustomColor(tag);
            if (item.m_41788_()) {
                te.customName = item.m_41786_();
            }
            return te;
        }
        return null;
    }

    private void renderItem(ItemStack stack, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, 1);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state) {
        Minecraft.m_91087_().m_91289_().renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE);
    }

    public void renderTileStuff(CompoundTag tag, ItemStack stack, ItemTransforms.TransformType transformType, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        HerbJarTile tileEntityIn = HerbJarItemRenderer.loadBlockEntityFromItem(tag, stack);
        String name = tileEntityIn.m_5446_().getString();
        DyeColor col = HexereiUtil.getDyeColorNamed(name);
        int color = col != null ? HexereiUtil.getColorValue(col) : HexereiUtil.getColorStatic(stack);
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.2, -0.1, -0.1);
        matrixStackIn.m_85837_(0.5, 0.265625, 0.25);
        matrixStackIn.m_85841_(0.3f, 0.3f, 0.3f);
        this.renderItem(new ItemStack((ItemLike)tileEntityIn.itemHandler.getStackInSlot(0).m_41720_(), 1), matrixStackIn, bufferIn, combinedLightIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(0.0f));
        matrixStackIn.m_85837_(0.2, -0.1, -0.1);
        this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, (BlockState)((BlockState)((HerbJar)ModBlocks.HERB_JAR.get()).m_49966_().m_61124_((Property)HerbJar.GUI_RENDER, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HerbJar.DYED, (Comparable)Boolean.valueOf(color != 4337438 && color != 0)), color);
        matrixStackIn.m_85849_();
        if (!tileEntityIn.itemHandler.isEmpty()) {
            BlockState state = null;
            Item item = ((ItemStack)tileEntityIn.itemHandler.getContents().get(0)).m_41720_();
            if (item == ((PickableFlower)((Object)ModBlocks.BELLADONNA_FLOWER.get())).m_5456_() || item == ((FlowerOutputItem)((Object)ModItems.BELLADONNA_FLOWERS.get())).m_5456_()) {
                state = ((Block)ModBlocks.HERB_JAR_BELLADONNA.get()).m_49966_();
            }
            if (item == ((PickableDoubleFlower)((Object)ModBlocks.MUGWORT_BUSH.get())).m_5456_() || item == ((FlowerOutputItem)((Object)ModItems.MUGWORT_LEAVES.get())).m_5456_() || item == ((FlowerOutputItem)((Object)ModItems.MUGWORT_FLOWERS.get())).m_5456_()) {
                state = ((Block)ModBlocks.HERB_JAR_MUGWORT.get()).m_49966_();
            }
            if (item == ((PickableFlower)((Object)ModBlocks.MANDRAKE_FLOWER.get())).m_5456_() || item == ((FlowerOutputItem)((Object)ModItems.MANDRAKE_FLOWERS.get())).m_5456_()) {
                state = ((Block)ModBlocks.HERB_JAR_MANDRAKE_FLOWER.get()).m_49966_();
            }
            if (item == ModItems.MANDRAKE_ROOT.get()) {
                state = ((Block)ModBlocks.HERB_JAR_MANDRAKE_ROOT.get()).m_49966_();
            }
            if (item == ((PickableDoubleFlower)((Object)ModBlocks.YELLOW_DOCK_BUSH.get())).m_5456_() || item == ((FlowerOutputItem)((Object)ModItems.YELLOW_DOCK_LEAVES.get())).m_5456_() || item == ((FlowerOutputItem)((Object)ModItems.YELLOW_DOCK_FLOWERS.get())).m_5456_()) {
                state = ((Block)ModBlocks.HERB_JAR_YELLOW_DOCK.get()).m_49966_();
            }
            Random rand = new Random(0L);
            Minecraft minecraft = Minecraft.m_91087_();
            ItemRenderer itemRenderer = minecraft.m_91291_();
            ItemModelShaper shaper = itemRenderer.m_115103_();
            boolean is3dModel = shaper.m_109393_().m_119422_(new ModelResourceLocation(item.getRegistryName(), "inventory")).m_7539_();
            int a = 0;
            while ((float)a < (float)((ItemStack)tileEntityIn.itemHandler.getContents().get(0)).m_41613_() / 1024.0f * 10.0f) {
                matrixStackIn.m_85836_();
                matrixStackIn.m_85837_(0.2, -0.1, -0.1);
                if (is3dModel) {
                    matrixStackIn.m_85837_(0.0, 0.09375, 0.0);
                }
                if (state != null) {
                    matrixStackIn.m_85837_(0.5, 0.03125 * (double)a, 0.5);
                    matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_((float)(90 * a)));
                    matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(0.0f));
                    this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, state);
                } else {
                    matrixStackIn.m_85837_(0.5, 0.03125 * (double)a + 0.0625, 0.5);
                    matrixStackIn.m_85841_(0.4f, 0.4f, 0.4f);
                    matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_((float)(rand.nextInt(90) * a)));
                    matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(0.0f));
                    matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_((float)(80 + rand.nextInt(20))));
                    if (is3dModel) {
                        matrixStackIn.m_85841_(1.2f, 1.2f, 1.2f);
                    }
                    this.renderItem(new ItemStack((ItemLike)tileEntityIn.itemHandler.getStackInSlot(0).m_41720_(), 1), matrixStackIn, bufferIn, combinedLightIn);
                }
                matrixStackIn.m_85849_();
                ++a;
            }
        }
        int i = 4607830;
        int j = (int)((double)NativeImage.m_85085_((int)i) * 0.4);
        int k = (int)((double)NativeImage.m_85103_((int)i) * 0.4);
        int l = (int)((double)NativeImage.m_85119_((int)i) * 0.4);
        int i1 = NativeImage.m_84992_((int)0, (int)l, (int)k, (int)j);
        matrixStackIn.m_85837_(0.2, -0.1, -0.1);
        matrixStackIn.m_85837_(0.5, 0.5, 0.24687499999999996);
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        matrixStackIn.m_85841_(0.0069444445f, -0.0069444445f, 0.0069444445f);
        Component component = null;
        if (stack.m_41788_()) {
            component = stack.m_41786_();
        }
        if (component == null && tileEntityIn.getItemStackInSlot(0) != ItemStack.f_41583_) {
            component = tileEntityIn.getItemStackInSlot(0).m_41786_().getString().equals("") ? tileEntityIn.getItemStackInSlot(0).m_41720_().m_7626_(tileEntityIn.getItemStackInSlot(0)) : tileEntityIn.getItemStackInSlot(0).m_41786_();
        }
        if (component != null) {
            List list = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)component, 70);
            float f3 = -Minecraft.m_91087_().f_91062_.m_92724_((FormattedCharSequence)list.get(0)) / 2;
            if (tileEntityIn.dyeColor != 4337438 && tileEntityIn.dyeColor != 0) {
                matrixStackIn.m_85837_(0.0, 5.0, 1.0);
            }
            Minecraft.m_91087_().f_91062_.m_92733_((FormattedCharSequence)list.get(0), f3, 0.0f, i1, false, matrixStackIn.m_85850_().m_85861_(), bufferIn, false, 0, combinedLightIn);
            if (list.size() > 1) {
                matrixStackIn.m_85837_(0.0, 10.0, 0.0);
                f3 = -Minecraft.m_91087_().f_91062_.m_92724_((FormattedCharSequence)list.get(1)) / 2;
                Minecraft.m_91087_().f_91062_.m_92733_((FormattedCharSequence)list.get(1), f3, 0.0f, i1, false, matrixStackIn.m_85850_().m_85861_(), bufferIn, false, 0, combinedLightIn);
            }
        }
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE, color);
    }

    public void renderSingleBlock(BlockState p_110913_, PoseStack p_110914_, MultiBufferSource p_110915_, int p_110916_, int p_110917_, IModelData modelData, int color) {
        RenderShape rendershape = p_110913_.m_60799_();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
                    BakedModel bakedmodel = dispatcher.m_110910_(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    dispatcher.m_110937_().renderModel(p_110914_.m_85850_(), p_110915_.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.m_60734_());
                    RenderProperties.get((ItemStack)stack).getItemStackRenderer().m_108829_(stack, ItemTransforms.TransformType.NONE, p_110914_, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

