/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import net.joefoxe.hexerei.client.renderer.IFirstPersonItemAnimation;
import net.joefoxe.hexerei.client.renderer.IThirdPersonItemAnimation;
import net.joefoxe.hexerei.client.renderer.IThirdPersonItemRenderer;
import net.joefoxe.hexerei.client.renderer.TwoHandedItemAnimation;
import net.joefoxe.hexerei.client.renderer.entity.custom.CrowEntity;
import net.joefoxe.hexerei.container.CrowFluteContainer;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.sounds.ModSounds;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.CrowFluteClearCrowListToServer;
import net.joefoxe.hexerei.util.message.CrowFluteClearCrowPerchToServer;
import net.joefoxe.hexerei.util.message.CrowFluteCommandModeSyncToServer;
import net.joefoxe.hexerei.util.message.CrowFluteCommandSyncToServer;
import net.joefoxe.hexerei.util.message.CrowFluteHelpCommandSyncToServer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class CrowFluteItem
extends Item
implements Container,
IThirdPersonItemAnimation,
IThirdPersonItemRenderer,
IFirstPersonItemAnimation {
    protected final Predicate<CrowEntity> targetEntitySelector = input -> true;
    private static final Predicate<Entity> field_219989_a = EntitySelector.f_20408_.and(Entity::m_5829_);
    public int commandSelected = 0;
    public int helpCommandSelected = 0;
    boolean initialized = false;

    public CrowFluteItem(Item.Properties properties) {
        super(properties);
    }

    protected AABB getTargetableArea(double targetDistance, Entity entity) {
        Vec3 renderCenter = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        AABB aabb = new AABB(-targetDistance, -targetDistance, -targetDistance, targetDistance, targetDistance, targetDistance);
        return aabb.m_82383_(renderCenter);
    }

    public void m_6883_(ItemStack itemstack, Level level, Entity p_41406_, int p_41407_, boolean p_41408_) {
        if (!itemstack.m_41784_().m_128441_("commandSelected")) {
            itemstack.m_41784_().m_128405_("commandSelected", 0);
        }
        if (!itemstack.m_41784_().m_128441_("helpCommandSelected")) {
            itemstack.m_41784_().m_128405_("helpCommandSelected", 0);
        }
        if (!itemstack.m_41784_().m_128441_("commandMode")) {
            itemstack.m_41784_().m_128379_("commandMode", false);
        }
        if (!itemstack.m_41784_().m_128441_("crowList")) {
            itemstack.m_41784_().m_128365_("crowList", (Tag)new CompoundTag());
        }
        if (!itemstack.m_41784_().m_128441_("dyeColor1")) {
            itemstack.m_41784_().m_128405_("dyeColor1", -1);
        }
        if (!itemstack.m_41784_().m_128441_("dyeColor2")) {
            itemstack.m_41784_().m_128405_("dyeColor2", -1);
        }
        if (!this.initialized && !level.f_46443_) {
            ListTag id = itemstack.m_41784_().m_128437_("crowList", 10);
            for (int i = 0; i < id.size(); ++i) {
                UUID crowId;
                Entity entity;
                CompoundTag tag = id.m_128728_(i);
                if (!tag.m_128441_("UUID") || !((entity = ((ServerLevel)level).m_8791_(crowId = tag.m_128342_("UUID"))) instanceof CrowEntity)) continue;
                tag.m_128405_("ID", entity.m_142049_());
            }
        }
        super.m_6883_(itemstack, level, p_41406_, p_41407_, p_41408_);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Player player = ctx.m_43723_();
        ItemStack itemstack = ctx.m_43722_();
        if (!player.m_6144_() && itemstack.m_41784_().m_128451_("commandMode") == 2 && !player.f_19853_.f_46443_) {
            ArrayList<CrowEntity> crows = new ArrayList<CrowEntity>();
            ListTag id = itemstack.m_41784_().m_128437_("crowList", 10);
            if (id.size() < 1) {
                return InteractionResult.FAIL;
            }
            for (int i = 0; i < id.size(); ++i) {
                CompoundTag tag = id.m_128728_(i);
                if (tag.m_128441_("UUID")) {
                    UUID crowId = tag.m_128342_("UUID");
                    Entity entity = ((ServerLevel)player.f_19853_).m_8791_(crowId);
                    if (entity instanceof CrowEntity) {
                        tag.m_128405_("ID", entity.m_142049_());
                        crows.add((CrowEntity)entity);
                        ((CrowEntity)((ServerLevel)player.f_19853_).m_8791_(crowId)).setPerchPos(ctx.m_8083_());
                        continue;
                    }
                    id.remove(i);
                    i = 0;
                    continue;
                }
                id.remove(i);
                i = 0;
            }
            if (crows.size() > 0) {
                player.f_19853_.m_6263_(null, player.m_20185_() + player.m_20154_().m_7096_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_() + player.m_20154_().m_7094_(), (SoundEvent)ModSounds.CROW_FLUTE.get(), SoundSource.PLAYERS, 1.0f, 0.8f + 0.4f * new Random().nextFloat());
                player.m_36335_().m_41524_((Item)this, 20);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(ctx);
    }

    public static ItemStack withColors(int color1, int color2) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.CROW_FLUTE.get());
        stack.m_41784_().m_128405_("dyeColor1", color1);
        stack.m_41784_().m_128405_("dyeColor2", color2);
        return stack;
    }

    public static int getColorValue(DyeColor color) {
        float[] colors = color.m_41068_();
        int r = (int)(colors[0] * 255.0f);
        int g = (int)(colors[1] * 255.0f);
        int b = (int)(colors[2] * 255.0f);
        return r << 16 | g << 8 | b;
    }

    public static DyeColor getColor1(ItemStack stack) {
        DyeColor col = HexereiUtil.getDyeColorNamed(stack.m_41786_().getString(), 0);
        return col == null ? DyeColor.m_41053_((int)stack.m_41784_().m_128451_("dyeColor1")) : col;
    }

    public static DyeColor getColor2(ItemStack stack) {
        DyeColor col = HexereiUtil.getDyeColorNamed(stack.m_41786_().getString(), 0, 5);
        return col == null ? DyeColor.m_41053_((int)stack.m_41784_().m_128451_("dyeColor2")) : col;
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41784_().m_128451_("commandMode") == 2 || stack.m_41784_().m_128451_("commandMode") == 1;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.NONE;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player playerIn, InteractionHand handIn) {
        BlockHitResult raytraceresult;
        ItemStack itemstack = playerIn.m_21120_(handIn);
        playerIn.m_6672_(handIn);
        if (!level.f_46443_) {
            if (playerIn.m_6144_()) {
                ListTag id = itemstack.m_41784_().m_128437_("crowList", 10);
                for (int i = 0; i < id.size(); ++i) {
                    CompoundTag tag = id.m_128728_(i);
                    if (!tag.m_128441_("UUID")) continue;
                    UUID crowId = tag.m_128342_("UUID");
                    Entity entity = ((ServerLevel)level).m_8791_(crowId);
                    if (entity instanceof CrowEntity) {
                        tag.m_128405_("ID", entity.m_142049_());
                        continue;
                    }
                    id.remove(i);
                    i = 0;
                }
                MenuProvider containerProvider = this.createContainerProvider(itemstack, handIn, itemstack.m_41783_());
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)containerProvider, b -> b.m_130079_(itemstack.m_41783_()).writeInt(handIn == InteractionHand.MAIN_HAND ? 0 : 1));
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            if (itemstack.m_41784_().m_128451_("commandMode") == 0) {
                List<CrowEntity> crows = new ArrayList();
                ListTag id = itemstack.m_41784_().m_128437_("crowList", 10);
                for (int i = 0; i < id.size(); ++i) {
                    CompoundTag tag = id.m_128728_(i);
                    UUID crowId = tag.m_128342_("UUID");
                    tag.m_128405_("ID", ((ServerLevel)playerIn.f_19853_).m_8791_(crowId).m_142049_());
                    crows.add((CrowEntity)((ServerLevel)playerIn.f_19853_).m_8791_(crowId));
                }
                if (crows.size() < 1) {
                    crows = level.m_6443_(CrowEntity.class, this.getTargetableArea(64.0, (Entity)playerIn), this.targetEntitySelector);
                    crows.removeIf(crow -> !crow.m_21830_((LivingEntity)playerIn));
                }
                if (crows.size() > 0) {
                    int selected = itemstack.m_41784_().m_128451_("commandSelected");
                    if (selected == 0) {
                        playerIn.m_5661_((Component)new TranslatableComponent("entity.hexerei.crow_flute_set_message", new Object[]{crows.size(), crows.size() > 1 ? "s" : "", new TranslatableComponent("entity.hexerei.crow_command_gui_0")}), true);
                        for (CrowEntity crow2 : crows) {
                            if (!crow2.m_21830_((LivingEntity)playerIn)) continue;
                            crow2.setCommandFollow();
                        }
                    } else if (selected == 1) {
                        playerIn.m_5661_((Component)new TranslatableComponent("entity.hexerei.crow_flute_set_message", new Object[]{crows.size(), crows.size() > 1 ? "s" : "", new TranslatableComponent("entity.hexerei.crow_command_gui_1")}), true);
                        for (CrowEntity crow2 : crows) {
                            if (!crow2.m_21830_((LivingEntity)playerIn)) continue;
                            crow2.setCommandSit();
                        }
                    } else if (selected == 2) {
                        playerIn.m_5661_((Component)new TranslatableComponent("entity.hexerei.crow_flute_set_message", new Object[]{crows.size(), crows.size() > 1 ? "s" : "", new TranslatableComponent("entity.hexerei.crow_command_gui_2")}), true);
                        for (CrowEntity crow2 : crows) {
                            if (!crow2.m_21830_((LivingEntity)playerIn)) continue;
                            crow2.setCommandWander();
                        }
                    } else if (selected == 3) {
                        playerIn.m_5661_((Component)new TranslatableComponent("entity.hexerei.crow_flute_set_message", new Object[]{crows.size(), crows.size() > 1 ? "s" : "", new TranslatableComponent("entity.hexerei.crow_command_gui_3")}).m_130946_(" (").m_7220_((Component)new TranslatableComponent("entity.hexerei.crow_help_command_gui_" + itemstack.m_41784_().m_128451_("helpCommandSelected"))).m_130946_(")"), true);
                        for (CrowEntity crow2 : crows) {
                            if (!crow2.m_21830_((LivingEntity)playerIn)) continue;
                            crow2.setHelpCommand(itemstack.m_41784_().m_128451_("helpCommandSelected"));
                            crow2.setCommandHelp();
                        }
                    }
                }
                level.m_6263_(null, playerIn.m_20185_() + playerIn.m_20154_().m_7096_(), playerIn.m_20186_() + (double)playerIn.m_20192_(), playerIn.m_20189_() + playerIn.m_20154_().m_7094_(), (SoundEvent)ModSounds.CROW_FLUTE.get(), SoundSource.PLAYERS, 1.0f, 0.8f + 0.4f * new Random().nextFloat());
                playerIn.m_36335_().m_41524_((Item)this, 20);
                return InteractionResultHolder.m_19090_((Object)itemstack);
            }
            if (itemstack.m_41784_().m_128451_("commandMode") == 1) {
                BlockHitResult raytraceresult2 = CrowFluteItem.m_41435_((Level)level, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.NONE);
                if (raytraceresult2.m_6662_() == HitResult.Type.ENTITY) {
                    Vec3 vector3d = playerIn.m_20154_();
                    List list = level.m_6249_((Entity)playerIn, playerIn.m_142469_().m_82369_(vector3d.m_82490_(5.0)).m_82400_(1.0), field_219989_a);
                    boolean flag = false;
                    for (Entity entity : list) {
                        if (!(entity instanceof CrowEntity) || !((CrowEntity)entity).m_21830_((LivingEntity)playerIn)) continue;
                        flag = true;
                        break;
                    }
                    if (flag) return InteractionResultHolder.m_19100_((Object)itemstack);
                    playerIn.m_36335_().m_41524_((Item)this, 5);
                    return InteractionResultHolder.m_19100_((Object)itemstack);
                } else {
                    playerIn.m_36335_().m_41524_((Item)this, 5);
                }
                return InteractionResultHolder.m_19100_((Object)itemstack);
            } else {
                if (itemstack.m_41784_().m_128451_("commandMode") != 2) return InteractionResultHolder.m_19100_((Object)itemstack);
                BlockHitResult raytraceresult3 = CrowFluteItem.m_41435_((Level)level, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.NONE);
                if (raytraceresult3.m_6662_() == HitResult.Type.BLOCK) {
                    ListTag id = itemstack.m_41784_().m_128437_("crowList", 10);
                    if (id.size() >= 1) return InteractionResultHolder.m_19090_((Object)itemstack);
                    playerIn.m_5661_((Component)new TranslatableComponent("entity.hexerei.crow_flute_perch_message_fail_no_crows"), true);
                    playerIn.m_36335_().m_41524_((Item)this, 5);
                    return InteractionResultHolder.m_19100_((Object)itemstack);
                } else {
                    playerIn.m_36335_().m_41524_((Item)this, 5);
                }
            }
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        if (playerIn.m_6144_()) return InteractionResultHolder.m_19090_((Object)itemstack);
        if (itemstack.m_41784_().m_128451_("commandMode") == 1) {
            raytraceresult = CrowFluteItem.m_41435_((Level)level, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.ANY);
            if (raytraceresult.m_6662_() != HitResult.Type.ENTITY) {
                playerIn.m_5661_((Component)new TranslatableComponent("entity.hexerei.crow_flute_select_message_fail"), true);
                playerIn.m_5496_((SoundEvent)ModSounds.CROW_FLUTE_DESELECT.get(), 1.0f, 0.1f);
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            if (raytraceresult.m_6662_() == HitResult.Type.ENTITY) {
                Vec3 vector3d = playerIn.m_20154_();
                List list = level.m_6249_((Entity)playerIn, playerIn.m_142469_().m_82369_(vector3d.m_82490_(5.0)).m_82400_(1.0), field_219989_a);
                boolean flag = false;
                for (Entity entity : list) {
                    if (!(entity instanceof CrowEntity) || !((CrowEntity)entity).m_21830_((LivingEntity)playerIn)) continue;
                    flag = true;
                    break;
                }
                if (flag) return InteractionResultHolder.m_19090_((Object)itemstack);
                playerIn.m_5661_((Component)new TranslatableComponent("entity.hexerei.crow_flute_select_message_fail"), true);
                playerIn.m_5496_((SoundEvent)ModSounds.CROW_FLUTE_DESELECT.get(), 1.0f, 0.1f);
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
        }
        if (itemstack.m_41784_().m_128451_("commandMode") != 2) return InteractionResultHolder.m_19090_((Object)itemstack);
        raytraceresult = CrowFluteItem.m_41435_((Level)level, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (raytraceresult.m_6662_() != HitResult.Type.BLOCK) {
            playerIn.m_5661_((Component)new TranslatableComponent("entity.hexerei.crow_flute_perch_message_fail_no_block"), true);
            playerIn.m_5496_((SoundEvent)ModSounds.CROW_FLUTE_DESELECT.get(), 1.0f, 0.1f);
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        ListTag id = itemstack.m_41784_().m_128437_("crowList", 10);
        if (id.size() >= 1) return InteractionResultHolder.m_19090_((Object)itemstack);
        playerIn.m_5661_((Component)new TranslatableComponent("entity.hexerei.crow_flute_perch_message_fail_no_crows"), true);
        playerIn.m_5496_((SoundEvent)ModSounds.CROW_FLUTE_DESELECT.get(), 1.0f, 0.1f);
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public void m_7373_(ItemStack stack, @javax.annotation.Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)new TranslatableComponent("<%s>", new Object[]{new TranslatableComponent("tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAA6600)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.crow_flute_shift_1").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.crow_flute_shift_2").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.crow_flute_shift_3").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.crow_flute_shift_4").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.crow_flute_shift_5").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
        } else {
            tooltip.add((Component)new TranslatableComponent("[%s]", new Object[]{new TranslatableComponent("tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAA00)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            if (stack.m_41784_().m_128441_("commandMode")) {
                String command = "";
                if (stack.m_41784_().m_128451_("commandMode") == 0) {
                    if (stack.m_41784_().m_128451_("commandSelected") == 0) {
                        command = "entity.hexerei.crow_command_gui_0";
                    }
                    if (stack.m_41784_().m_128451_("commandSelected") == 1) {
                        command = "entity.hexerei.crow_command_gui_1";
                    }
                    if (stack.m_41784_().m_128451_("commandSelected") == 2) {
                        command = "entity.hexerei.crow_command_gui_2";
                    }
                    if (stack.m_41784_().m_128451_("commandSelected") == 3) {
                        if (stack.m_41784_().m_128451_("helpCommandSelected") == 0) {
                            command = "entity.hexerei.crow_help_command_gui_0";
                        }
                        if (stack.m_41784_().m_128451_("helpCommandSelected") == 1) {
                            command = "entity.hexerei.crow_help_command_gui_1";
                        }
                        if (stack.m_41784_().m_128451_("helpCommandSelected") == 2) {
                            command = "entity.hexerei.crow_help_command_gui_2";
                        }
                    }
                } else if (stack.m_41784_().m_128451_("commandMode") == 1) {
                    command = "entity.hexerei.crow_flute_perch";
                } else if (stack.m_41784_().m_128451_("commandMode") == 2) {
                    command = "entity.hexerei.crow_flute_select";
                }
                tooltip.add((Component)new TranslatableComponent("-%s-", new Object[]{new TranslatableComponent(command).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAA6600)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            }
        }
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    public void setCommand(int command, ItemStack stack, Player player, InteractionHand hand) {
        if (player.f_19853_.f_46443_) {
            HexereiPacketHandler.sendToServer(new CrowFluteCommandSyncToServer(stack, command, player.m_142081_(), hand == InteractionHand.MAIN_HAND ? 0 : 1));
        }
    }

    public void setHelpCommand(int helpCommand, ItemStack stack, Player player, InteractionHand hand) {
        if (player.f_19853_.f_46443_) {
            HexereiPacketHandler.sendToServer(new CrowFluteHelpCommandSyncToServer(stack, helpCommand, player.m_142081_(), hand == InteractionHand.MAIN_HAND ? 0 : 1));
        }
    }

    public void setCommandMode(int mode, ItemStack stack, Player player, InteractionHand hand) {
        if (player.f_19853_.f_46443_) {
            HexereiPacketHandler.sendToServer(new CrowFluteCommandModeSyncToServer(stack, mode, player.m_142081_(), hand == InteractionHand.MAIN_HAND ? 0 : 1));
        }
    }

    public void clearCrowList(ItemStack stack, Player player, InteractionHand hand) {
        if (player.f_19853_.f_46443_) {
            HexereiPacketHandler.sendToServer(new CrowFluteClearCrowListToServer(stack, player.m_142081_(), hand == InteractionHand.MAIN_HAND ? 0 : 1));
        }
    }

    public void clearCrowPerch(ItemStack stack, Player player, InteractionHand hand) {
        if (player.f_19853_.f_46443_) {
            HexereiPacketHandler.sendToServer(new CrowFluteClearCrowPerchToServer(stack, player.m_142081_(), hand == InteractionHand.MAIN_HAND ? 0 : 1));
        }
    }

    public int m_6643_() {
        return 0;
    }

    public boolean m_7983_() {
        return false;
    }

    public ItemStack m_8020_(int p_18941_) {
        return null;
    }

    public ItemStack m_7407_(int p_18942_, int p_18943_) {
        return null;
    }

    public ItemStack m_8016_(int p_18951_) {
        return null;
    }

    public void m_6836_(int p_18944_, ItemStack p_18945_) {
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player p_18946_) {
        return false;
    }

    public void m_6211_() {
    }

    private MenuProvider createContainerProvider(final ItemStack itemStack, final InteractionHand hand, final CompoundTag list) {
        return new MenuProvider(){

            @Nullable
            public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                return new CrowFluteContainer(windowId, itemStack, inv, player, hand, list);
            }

            public Component m_5446_() {
                MutableComponent mutablecomponent = new TextComponent("").m_7220_(itemStack.m_41786_());
                if (itemStack.m_41788_()) {
                    mutablecomponent.m_130940_(ChatFormatting.ITALIC);
                }
                return mutablecomponent;
            }
        };
    }

    public static float wrapRad(float pValue) {
        float p = (float)Math.PI * 2;
        float d0 = pValue % p;
        if ((double)d0 >= Math.PI) {
            d0 -= p;
        }
        if ((double)d0 < -Math.PI) {
            d0 += p;
        }
        return d0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity> boolean poseRightArm(ItemStack stack, HumanoidModel<T> model, T entity, HumanoidArm mainHand, TwoHandedItemAnimation twoHanded) {
        if (entity.m_21212_() > 0 && entity.m_21211_().m_41720_() == this) {
            this.animateHands(model, entity, false);
            twoHanded.bool = true;
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity> boolean poseLeftArm(ItemStack stack, HumanoidModel<T> model, T entity, HumanoidArm mainHand, TwoHandedItemAnimation twoHanded) {
        if (entity.m_21212_() > 0 && entity.m_21211_().m_41720_() == this) {
            this.animateHands(model, entity, true);
            twoHanded.bool = true;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private <T extends LivingEntity> void animateHands(HumanoidModel<T> model, T entity, boolean leftHand) {
        float yRot;
        ModelPart mainHand = leftHand ? model.f_102812_ : model.f_102811_;
        ModelPart offHand = leftHand ? model.f_102811_ : model.f_102812_;
        Vec3 bx = new Vec3(1.0, 0.0, 0.0);
        Vec3 by = new Vec3(0.0, 1.0, 0.0);
        Vec3 bz = new Vec3(0.0, 0.0, 1.0);
        float headXRot = CrowFluteItem.wrapRad(model.f_102808_.f_104203_);
        float headYRot = CrowFluteItem.wrapRad(model.f_102808_.f_104204_);
        float downFacingRot = Mth.m_14036_((float)headXRot, (float)0.0f, (float)0.8f);
        float xRot = CrowFluteItem.getMaxHeadXRot(headXRot) - (entity.m_6047_() ? 1.0f : 0.0f) - 0.3f + downFacingRot * 0.5f;
        bx = bx.m_82496_(xRot);
        by = by.m_82496_(xRot);
        bz = bz.m_82496_(xRot);
        Vec3 armVec = new Vec3(0.0, 0.0, 1.0);
        float mirror = leftHand ? 1.0f : -1.0f;
        armVec = armVec.m_82524_(-0.99f * mirror);
        Vec3 newV = bx.m_82490_(armVec.f_82479_).m_82549_(by.m_82490_(armVec.f_82480_)).m_82549_(bz.m_82490_(armVec.f_82481_));
        float yaw = (float)Math.atan2(-newV.f_82479_, newV.f_82481_);
        float len = (float)newV.m_82553_();
        float pitch = (float)Math.asin(newV.f_82480_ / (double)len);
        mainHand.f_104204_ = yRot = yaw + headYRot * 0.8f - 1.6f * mirror - 0.5f * downFacingRot * mirror;
        mainHand.f_104203_ = (float)((double)pitch - 1.5707963267948966);
        offHand.f_104204_ = yRot;
        offHand.f_104203_ = CrowFluteItem.wrapRad(mainHand.f_104203_ - 0.06f);
        float offset = leftHand ? -Mth.m_14036_((float)headYRot, (float)-1.0f, (float)0.0f) : Mth.m_14036_((float)headYRot, (float)0.0f, (float)1.0f);
        mainHand.f_104202_ = -offset * 0.95f;
        AnimationUtils.m_170341_((ModelPart)model.f_102812_, (float)entity.f_19797_, (float)1.0f);
        AnimationUtils.m_170341_((ModelPart)model.f_102811_, (float)entity.f_19797_, (float)-1.0f);
    }

    public static float getMaxHeadXRot(float xRot) {
        return Mth.m_14036_((float)xRot, (float)-1.2566371f, (float)1.5707964f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <T extends Player, M extends EntityModel<T> & HeadedModel> void renderThirdPersonItem(M parentModel, LivingEntity entity, ItemStack stack, HumanoidArm humanoidArm, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        if (!stack.m_41619_()) {
            ItemTransforms.TransformType transform;
            boolean leftHand;
            poseStack.m_85836_();
            boolean bl = leftHand = humanoidArm == HumanoidArm.LEFT;
            if (entity.m_21211_() == stack) {
                ModelPart head = ((HeadedModel)parentModel).m_5585_();
                float oldRot = head.f_104203_;
                head.f_104203_ = CrowFluteItem.getMaxHeadXRot(CrowFluteItem.wrapRad(oldRot));
                poseStack.m_85837_((double)(head.f_104200_ / 16.0f), (double)(head.f_104201_ / 16.0f), (double)(head.f_104202_ / 16.0f));
                if (head.f_104205_ != 0.0f) {
                    poseStack.m_85845_(Vector3f.f_122227_.m_122270_(head.f_104205_ / 1.75f));
                }
                if (head.f_104204_ != 0.0f) {
                    poseStack.m_85845_(Vector3f.f_122225_.m_122270_(head.f_104204_));
                }
                if (head.f_104203_ != 0.0f) {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122270_(head.f_104203_ / 1.75f));
                }
                head.f_104203_ = oldRot;
                CustomHeadLayer.m_174483_((PoseStack)poseStack, (boolean)false);
                poseStack.m_85837_((double)((float)(leftHand ? -1 : 1) * 4.0f / 16.0f), -0.375, -0.75);
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f + head.f_104204_ * ((float)Math.PI * 2) * 10.0f + (float)((leftHand ? -1 : 1) * 10)));
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_((float)((leftHand ? 1 : -1) * 23)));
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_((float)((leftHand ? 1 : 0) * -90)));
                poseStack.m_85837_(0.0, 0.4375, 0.5);
                transform = ItemTransforms.TransformType.HEAD;
            } else {
                ((ArmedModel)parentModel).m_6002_(humanoidArm, poseStack);
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                poseStack.m_85837_((double)((float)(leftHand ? -1 : 1) / 16.0f), 0.125, -0.625);
                transform = leftHand ? ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND : ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            }
            Minecraft.m_91087_().m_91292_().m_109322_(entity, stack, transform, leftHand, poseStack, bufferSource, light);
            poseStack.m_85849_();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void animateItemFirstPerson(LivingEntity entity, ItemStack stack, InteractionHand hand, PoseStack matrixStack, float partialTicks, float pitch, float attackAnim, float handHeight) {
        if (entity.m_6117_() && entity.m_21212_() > 0 && entity.m_7655_() == hand) {
            int mirror = entity.m_5737_() == HumanoidArm.RIGHT ^ hand == InteractionHand.MAIN_HAND ? -1 : 1;
            matrixStack.m_85837_(-0.4 * (double)mirror, 0.2, 0.0);
            float timeLeft = (float)stack.m_41779_() - ((float)entity.m_21212_() - partialTicks + 1.0f);
            float sin = Mth.m_14031_((float)((timeLeft - 0.1f) * 1.3f));
            matrixStack.m_85837_(0.0, (double)(sin * 0.0038f), 0.0);
            matrixStack.m_85845_(Vector3f.f_122226_.m_122240_(90.0f));
            matrixStack.m_85841_(1.0f * (float)mirror, -1.0f * (float)mirror, -1.0f);
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="hexerei", bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class ColorRegisterHandler {
        private ColorRegisterHandler() {
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerFluteColors(ColorHandlerEvent.Item event) {
            ItemHandlerConsumer items = (arg_0, arg_1) -> ((ItemColors)event.getItemColors()).m_92689_(arg_0, arg_1);
            items.register((s, t) -> t == 1 ? CrowFluteItem.getColorValue(CrowFluteItem.getColor1(s)) : (t == 2 ? CrowFluteItem.getColorValue(CrowFluteItem.getColor2(s)) : -1), (ItemLike)ModItems.CROW_FLUTE.get());
        }
    }

    public static interface ItemHandlerConsumer {
        public void register(ItemColor var1, ItemLike ... var2);
    }
}

