/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.events;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SageSeedAdditionModifier
extends LootModifier {
    private final Item addition;
    private final int count;

    protected SageSeedAdditionModifier(LootItemCondition[] conditionsIn, Item addition, int count) {
        super(conditionsIn);
        this.addition = addition;
        this.count = count;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        generatedLoot.add(new ItemStack((ItemLike)this.addition, this.count));
        return generatedLoot;
    }

    @SubscribeEvent
    public static void registerModifiers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> registryEvent) {
        registryEvent.getRegistry().register((IForgeRegistryEntry)new Serializer().setRegistryName("hexerei", "global_loot_modifiers"));
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<SageSeedAdditionModifier> {
        public SageSeedAdditionModifier read(ResourceLocation name, JsonObject object, LootItemCondition[] conditionsIn) {
            Item addition = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"addition")));
            int count = GsonHelper.m_13824_((JsonObject)object, (String)"count", (int)1);
            return new SageSeedAdditionModifier(conditionsIn, addition, count);
        }

        public JsonObject write(SageSeedAdditionModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty("addition", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.addition).toString());
            json.addProperty("count", (Number)instance.count);
            return json;
        }
    }
}

