/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.events;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AnimalFatAdditionModifier
extends LootModifier {
    private final Item addition;

    protected AnimalFatAdditionModifier(LootItemCondition[] conditionsIn, Item addition) {
        super(conditionsIn);
        this.addition = addition;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (context.m_78933_().nextDouble() / (double)Math.min(context.getLootingModifier() + 1, 4) < 0.45) {
            generatedLoot.add(new ItemStack((ItemLike)this.addition, context.m_78933_().nextInt(Math.min(context.getLootingModifier() + 1, 4)) + 1));
        }
        return generatedLoot;
    }

    @SubscribeEvent
    public static void registerModifiers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> registryEvent) {
        registryEvent.getRegistry().register((IForgeRegistryEntry)new Serializer().setRegistryName("hexerei", "global_loot_modifiers"));
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AnimalFatAdditionModifier> {
        public AnimalFatAdditionModifier read(ResourceLocation name, JsonObject object, LootItemCondition[] conditionsIn) {
            Item addition = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"addition")));
            return new AnimalFatAdditionModifier(conditionsIn, addition);
        }

        public JsonObject write(AnimalFatAdditionModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty("addition", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.addition).toString());
            return json;
        }
    }
}

