/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.joefoxe.hexerei.data.books.BookTooltipExtra;
import net.joefoxe.hexerei.data.books.PageDrawing;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BookItemsAndFluids {
    public float x;
    public float y;
    public boolean show_slot;
    public ItemStack item;
    public FluidStack fluid;
    public float fluid_width;
    public float fluid_height;
    public float fluid_offset_x;
    public float fluid_offset_y;
    public int capacity;
    public int amount;
    public String tag;
    public boolean refreshTag = false;
    public String type;
    public TagKey<Item> key;
    List<Component> extra_tooltips;
    List<BookTooltipExtra> extra_tooltips_raw;

    BookItemsAndFluids(float x, float y, ItemStack item) {
        this.x = x;
        this.y = y;
        this.item = item;
        this.fluid = null;
        this.tag = "null";
        this.type = "item";
        this.key = null;
        this.show_slot = true;
    }

    BookItemsAndFluids(float x, float y, ItemStack item, boolean show_slot) {
        this.x = x;
        this.y = y;
        this.item = item;
        this.fluid = null;
        this.tag = "null";
        this.type = "item";
        this.key = null;
        this.show_slot = show_slot;
        this.fluid_height = 16.0f;
        this.fluid_width = 16.0f;
        this.fluid_offset_x = 0.0f;
        this.fluid_offset_y = 0.0f;
        this.extra_tooltips = new ArrayList<Component>();
        this.extra_tooltips_raw = new ArrayList<BookTooltipExtra>();
    }

    BookItemsAndFluids(float x, float y, ItemStack item, boolean show_slot, List<Component> extra_tooltips, List<BookTooltipExtra> extra_tooltips_raw) {
        this.x = x;
        this.y = y;
        this.item = item;
        this.fluid = null;
        this.tag = "null";
        this.type = "item";
        this.key = null;
        this.show_slot = show_slot;
        this.fluid_height = 16.0f;
        this.fluid_width = 16.0f;
        this.fluid_offset_x = 0.0f;
        this.fluid_offset_y = 0.0f;
        this.extra_tooltips = extra_tooltips;
        this.extra_tooltips_raw = extra_tooltips_raw;
    }

    BookItemsAndFluids(float x, float y, FluidStack fluid) {
        this.x = x;
        this.y = y;
        this.fluid = fluid;
        this.item = null;
        this.tag = "null";
        this.type = "fluid";
        this.key = null;
        this.capacity = 0;
        this.show_slot = false;
        this.fluid_height = 16.0f;
        this.fluid_width = 16.0f;
        this.fluid_offset_x = 0.0f;
        this.fluid_offset_y = 0.0f;
    }

    BookItemsAndFluids(float x, float y, FluidStack fluid, int capacity) {
        this.x = x;
        this.y = y;
        this.fluid = fluid;
        this.item = null;
        this.tag = "null";
        this.type = "fluid";
        this.key = null;
        this.capacity = capacity;
        this.show_slot = false;
        this.fluid_height = 16.0f;
        this.fluid_width = 16.0f;
        this.fluid_offset_x = 0.0f;
        this.fluid_offset_y = 0.0f;
    }

    BookItemsAndFluids(float x, float y, FluidStack fluid, int amount, int capacity, boolean showSlot, float fluid_height, float fluid_width, float fluid_offset_x, float fluid_offset_y, List<Component> extra_tooltips, List<BookTooltipExtra> extra_tooltips_raw) {
        this.x = x;
        this.y = y;
        this.fluid = fluid;
        this.item = null;
        this.tag = "null";
        this.type = "fluid";
        this.key = null;
        this.capacity = capacity;
        this.amount = amount;
        this.show_slot = showSlot;
        this.fluid_height = fluid_height;
        this.fluid_width = fluid_width;
        this.fluid_offset_x = fluid_offset_x;
        this.fluid_offset_y = fluid_offset_y;
        this.extra_tooltips = extra_tooltips;
        this.extra_tooltips_raw = extra_tooltips_raw;
    }

    BookItemsAndFluids(float x, float y, FluidStack fluid, int amount, int capacity, boolean showSlot, float fluid_height, float fluid_width, float fluid_offset_x, float fluid_offset_y) {
        this.x = x;
        this.y = y;
        this.fluid = fluid;
        this.item = null;
        this.tag = "null";
        this.type = "fluid";
        this.key = null;
        this.capacity = capacity;
        this.amount = amount;
        this.show_slot = showSlot;
        this.fluid_height = fluid_height;
        this.fluid_width = fluid_width;
        this.fluid_offset_x = fluid_offset_x;
        this.fluid_offset_y = fluid_offset_y;
    }

    BookItemsAndFluids(float x, float y, String tag) {
        this.x = x;
        this.y = y;
        this.tag = tag;
        this.key = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(tag));
        this.item = new ItemStack((ItemLike)PageDrawing.getTagStackStatic(this.key).orElseGet(() -> ((ItemStack)ItemStack.f_41583_).m_41720_()));
        this.type = "tag";
        this.show_slot = true;
        this.fluid_height = 16.0f;
        this.fluid_width = 16.0f;
        this.fluid_offset_x = 0.0f;
        this.fluid_offset_y = 0.0f;
    }

    BookItemsAndFluids(float x, float y, String tag, boolean showSlot) {
        this.x = x;
        this.y = y;
        this.tag = tag;
        this.key = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(tag));
        this.item = new ItemStack((ItemLike)PageDrawing.getTagStackStatic(this.key).orElseGet(() -> ((ItemStack)ItemStack.f_41583_).m_41720_()));
        this.type = "tag";
        this.show_slot = showSlot;
        this.fluid_height = 16.0f;
        this.fluid_width = 16.0f;
        this.fluid_offset_x = 0.0f;
        this.fluid_offset_y = 0.0f;
    }

    BookItemsAndFluids(float x, float y, String tag, boolean showSlot, List<Component> extra_tooltips, List<BookTooltipExtra> tooltipExtras) {
        this.x = x;
        this.y = y;
        this.tag = tag;
        this.key = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(tag));
        this.item = new ItemStack((ItemLike)PageDrawing.getTagStackStatic(this.key).orElseGet(() -> ((ItemStack)ItemStack.f_41583_).m_41720_()));
        this.type = "tag";
        this.show_slot = showSlot;
        this.fluid_height = 16.0f;
        this.fluid_width = 16.0f;
        this.fluid_offset_x = 0.0f;
        this.fluid_offset_y = 0.0f;
        ArrayList<Component> extra_tooltips2 = new ArrayList<Component>();
        extra_tooltips2.add((Component)new TranslatableComponent("book.hexerei.tooltip.accepts_any", new Object[]{new TextComponent(tag)}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x808080))));
        this.extra_tooltips = extra_tooltips2;
        this.extra_tooltips.addAll(extra_tooltips);
        this.extra_tooltips_raw = tooltipExtras;
    }

    public static BookItemsAndFluids deserialize(JsonObject object) throws CommandSyntaxException {
        String type;
        float x = GsonHelper.m_13820_((JsonObject)object, (String)"x", (float)0.0f);
        float y = GsonHelper.m_13820_((JsonObject)object, (String)"y", (float)0.0f);
        boolean show_slot = GsonHelper.m_13855_((JsonObject)object, (String)"show_slot", (boolean)true);
        switch (type = GsonHelper.m_13851_((JsonObject)object, (String)"type", (String)"item")) {
            case "item": {
                Item item = GsonHelper.m_144746_((JsonObject)object, (String)"name", (Item)Items.f_41852_);
                int count = GsonHelper.m_13824_((JsonObject)object, (String)"count", (int)1);
                ItemStack stack = new ItemStack((ItemLike)item, count);
                if (object.has("tag")) {
                    String tagString = GsonHelper.m_13851_((JsonObject)object, (String)"tag", (String)"");
                    CompoundTag tag = TagParser.m_129359_((String)tagString);
                    stack.m_41751_(tag);
                }
                JsonArray yourJson = GsonHelper.m_13832_((JsonObject)object, (String)"extra_tooltips", (JsonArray)new JsonArray());
                ArrayList<Component> textComponentsList = new ArrayList<Component>();
                TranslatableComponent component = new TranslatableComponent("");
                ArrayList<BookTooltipExtra> bookTooltipExtraList = new ArrayList<BookTooltipExtra>();
                for (int i = 0; i < yourJson.size(); ++i) {
                    JsonObject extraItemObject = yourJson.get(i).getAsJsonObject();
                    int color = GsonHelper.m_13824_((JsonObject)extraItemObject, (String)"color", (int)0xFFFFFF);
                    String string = GsonHelper.m_13851_((JsonObject)extraItemObject, (String)"text", (String)"empty");
                    String string_type = GsonHelper.m_13851_((JsonObject)extraItemObject, (String)"type", (String)"append");
                    String hex_color = GsonHelper.m_13851_((JsonObject)extraItemObject, (String)"color_hex", (String)"");
                    if (!hex_color.equals("")) {
                        color = (int)Long.parseLong(hex_color, 16);
                    }
                    if (string_type.equals("trail")) {
                        textComponentsList.add((Component)component);
                        component = new TranslatableComponent(string).m_130948_(Style.f_131099_.m_178520_(color));
                    } else if (string_type.equals("append")) {
                        component.m_7360_().add(new TranslatableComponent(string).m_130948_(Style.f_131099_.m_178520_(color)));
                    }
                    if (i + 1 >= yourJson.size() && !component.getString().equals("")) {
                        textComponentsList.add((Component)component);
                    }
                    bookTooltipExtraList.add(new BookTooltipExtra(color, hex_color, string, string_type));
                }
                return new BookItemsAndFluids(x, y, stack, show_slot, textComponentsList, bookTooltipExtraList);
            }
            case "tag": {
                JsonArray yourJson = GsonHelper.m_13832_((JsonObject)object, (String)"extra_tooltips", (JsonArray)new JsonArray());
                ArrayList<Component> textComponentsList = new ArrayList<Component>();
                ArrayList<BookTooltipExtra> bookTooltipExtraList = new ArrayList<BookTooltipExtra>();
                TranslatableComponent component = new TranslatableComponent("");
                for (int i = 0; i < yourJson.size(); ++i) {
                    JsonObject extraItemObject = yourJson.get(i).getAsJsonObject();
                    int color = GsonHelper.m_13824_((JsonObject)extraItemObject, (String)"color", (int)0xFFFFFF);
                    String string = GsonHelper.m_13851_((JsonObject)extraItemObject, (String)"text", (String)"empty");
                    String string_type = GsonHelper.m_13851_((JsonObject)extraItemObject, (String)"type", (String)"append");
                    String hex_color = GsonHelper.m_13851_((JsonObject)extraItemObject, (String)"color_hex", (String)"");
                    if (!hex_color.equals("")) {
                        color = (int)Long.parseLong(hex_color, 16);
                    }
                    if (string_type.equals("trail")) {
                        textComponentsList.add((Component)component);
                        component = new TranslatableComponent(string).m_130948_(Style.f_131099_.m_178520_(color));
                    } else if (string_type.equals("append")) {
                        component.m_7360_().add(new TranslatableComponent(string).m_130948_(Style.f_131099_.m_178520_(color)));
                    }
                    if (i + 1 >= yourJson.size() && !component.getString().equals("")) {
                        textComponentsList.add((Component)component);
                    }
                    bookTooltipExtraList.add(new BookTooltipExtra(color, hex_color, string, string_type));
                }
                return new BookItemsAndFluids(x, y, GsonHelper.m_13851_((JsonObject)object, (String)"name", (String)"null"), show_slot, textComponentsList, bookTooltipExtraList);
            }
            case "fluid": {
                String loc = GsonHelper.m_13851_((JsonObject)object, (String)"name", (String)"minecraft:water");
                float fluid_height = GsonHelper.m_13820_((JsonObject)object, (String)"fluid_height", (float)16.0f);
                float fluid_width = GsonHelper.m_13820_((JsonObject)object, (String)"fluid_width", (float)16.0f);
                float fluid_offset_x = GsonHelper.m_13820_((JsonObject)object, (String)"fluid_offset_x", (float)0.0f);
                float fluid_offset_y = GsonHelper.m_13820_((JsonObject)object, (String)"fluid_offset_y", (float)0.0f);
                Fluid fluid = (Fluid)Registry.f_122822_.m_6612_(new ResourceLocation(loc)).orElseThrow(() -> new JsonSyntaxException("Expected " + loc + " to be an item, was unknown string '" + loc + "'"));
                int amount = GsonHelper.m_13824_((JsonObject)object, (String)"amount", (int)0);
                int capacity = GsonHelper.m_13824_((JsonObject)object, (String)"capacity", (int)0);
                FluidStack fluidStack = new FluidStack(fluid, amount <= 0 ? 1000 : amount);
                if (object.has("tag")) {
                    String tagString = GsonHelper.m_13851_((JsonObject)object, (String)"tag", (String)"");
                    CompoundTag tag = TagParser.m_129359_((String)tagString);
                    fluidStack.setTag(tag);
                }
                JsonArray yourJson = GsonHelper.m_13832_((JsonObject)object, (String)"extra_tooltips", (JsonArray)new JsonArray());
                ArrayList<Component> textComponentsList = new ArrayList<Component>();
                TranslatableComponent component = new TranslatableComponent("");
                ArrayList<BookTooltipExtra> bookTooltipExtraList = new ArrayList<BookTooltipExtra>();
                for (int i = 0; i < yourJson.size(); ++i) {
                    JsonObject extraItemObject = yourJson.get(i).getAsJsonObject();
                    int color = GsonHelper.m_13824_((JsonObject)extraItemObject, (String)"color", (int)0xFFFFFF);
                    String string = GsonHelper.m_13851_((JsonObject)extraItemObject, (String)"text", (String)"empty");
                    String string_type = GsonHelper.m_13851_((JsonObject)extraItemObject, (String)"type", (String)"append");
                    String hex_color = GsonHelper.m_13851_((JsonObject)extraItemObject, (String)"color_hex", (String)"");
                    if (!hex_color.equals("")) {
                        color = (int)Long.parseLong(hex_color, 16);
                    }
                    if (string_type.equals("trail")) {
                        textComponentsList.add((Component)component);
                        component = new TranslatableComponent(string).m_130948_(Style.f_131099_.m_178520_(color));
                    } else if (string_type.equals("append")) {
                        component.m_7360_().add(new TranslatableComponent(string).m_130948_(Style.f_131099_.m_178520_(color)));
                    }
                    if (i + 1 >= yourJson.size() && !component.getString().equals("")) {
                        textComponentsList.add((Component)component);
                    }
                    bookTooltipExtraList.add(new BookTooltipExtra(color, hex_color, string, string_type));
                }
                return new BookItemsAndFluids(x, y, fluidStack, amount, capacity, show_slot, fluid_height, fluid_width, fluid_offset_x, fluid_offset_y, textComponentsList, bookTooltipExtraList);
            }
        }
        return new BookItemsAndFluids(x, y, ItemStack.f_41583_, show_slot);
    }
}

