/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.LinkedList;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.FloweringLilyPadBlock;
import net.joefoxe.hexerei.block.custom.PickableDoubleFlower;
import net.joefoxe.hexerei.block.custom.PickableFlower;
import net.joefoxe.hexerei.client.renderer.CrowPerchRenderer;
import net.joefoxe.hexerei.client.renderer.entity.ModEntityTypes;
import net.joefoxe.hexerei.config.HexConfig;
import net.joefoxe.hexerei.config.ModKeyBindings;
import net.joefoxe.hexerei.container.ModContainers;
import net.joefoxe.hexerei.data.books.PageDrawing;
import net.joefoxe.hexerei.data.recipes.HexereiRecipeProvider;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.joefoxe.hexerei.events.CrowFluteEvent;
import net.joefoxe.hexerei.events.GlassesZoomKeyPressEvent;
import net.joefoxe.hexerei.events.SageBurningPlateEvent;
import net.joefoxe.hexerei.events.WitchArmorEvent;
import net.joefoxe.hexerei.fluid.ModFluids;
import net.joefoxe.hexerei.integration.HexereiModNameTooltipCompat;
import net.joefoxe.hexerei.integration.jei.HexereiJeiCompat;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.BroomItem;
import net.joefoxe.hexerei.item.custom.CofferItem;
import net.joefoxe.hexerei.item.custom.FlowerOutputItem;
import net.joefoxe.hexerei.item.custom.HerbJarItem;
import net.joefoxe.hexerei.particle.ModParticleTypes;
import net.joefoxe.hexerei.screen.BroomScreen;
import net.joefoxe.hexerei.screen.CofferScreen;
import net.joefoxe.hexerei.screen.CrowFluteScreen;
import net.joefoxe.hexerei.screen.CrowScreen;
import net.joefoxe.hexerei.screen.HerbJarScreen;
import net.joefoxe.hexerei.screen.MixingCauldronScreen;
import net.joefoxe.hexerei.screen.tooltip.ClientBroomToolTip;
import net.joefoxe.hexerei.screen.tooltip.ClientCofferToolTip;
import net.joefoxe.hexerei.screen.tooltip.ClientHerbJarToolTip;
import net.joefoxe.hexerei.sounds.ModSounds;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.ClientProxy;
import net.joefoxe.hexerei.util.HexereiConstants;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.ServerProxy;
import net.joefoxe.hexerei.util.SidedProxy;
import net.joefoxe.hexerei.world.biome.ModBiomes;
import net.joefoxe.hexerei.world.gen.ModBiomeGeneration;
import net.joefoxe.hexerei.world.gen.ModFeatures;
import net.joefoxe.hexerei.world.processor.DarkCovenLegProcessor;
import net.joefoxe.hexerei.world.processor.MangroveTreeLegProcessor;
import net.joefoxe.hexerei.world.processor.WitchHutLegProcessor;
import net.joefoxe.hexerei.world.structure.ModStructures;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="hexerei")
public class Hexerei {
    public static SidedProxy proxy = (SidedProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static final String MOD_ID = "hexerei";
    public static GlassesZoomKeyPressEvent glassesZoomKeyPressEvent;
    public static boolean entityClicked;
    public static final Gson GSON;
    public static final Logger LOGGER;
    public static final SimpleChannel HANDLER;
    public static StructureProcessorType<WitchHutLegProcessor> WITCH_HUT_LEG_PROCESSOR;
    public static StructureProcessorType<DarkCovenLegProcessor> DARK_COVEN_LEG_PROCESSOR;
    public static StructureProcessorType<MangroveTreeLegProcessor> MANGROVE_TREE_LEG_PROCESSOR;
    public static LinkedList<BlockPos> sageBurningPlateTileList;
    static float clientTicks;
    static float clientTicksPartial;

    public Hexerei() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addGenericListener(RecipeSerializer.class, ModItems::registerRecipeSerializers);
        ModItems.register(eventBus);
        ModBlocks.register(eventBus);
        ModFluids.register(eventBus);
        ModTileEntities.register(eventBus);
        ModContainers.register(eventBus);
        ModRecipeTypes.register(eventBus);
        ModParticleTypes.PARTICLES.register(eventBus);
        ModFeatures.register(eventBus);
        ModStructures.DEFERRED_REGISTRY_STRUCTURE.register(eventBus);
        ModBiomes.register(eventBus);
        ModSounds.register(eventBus);
        ModEntityTypes.register(eventBus);
        HexereiJeiCompat.init();
        HexereiModNameTooltipCompat.init();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(this::loadComplete);
        eventBus.addListener(this::setup);
        eventBus.addListener(this::enqueueIMC);
        eventBus.addListener(this::processIMC);
        eventBus.addListener(this::doClientStuff);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)HexConfig.CLIENT_CONFIG, "Hexerei-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)HexConfig.COMMON_CONFIG, "Hexerei-common.toml");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        gen.m_123914_((DataProvider)new HexereiRecipeProvider(gen));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setupCrowPerchRenderer() {
        MinecraftForge.EVENT_BUS.register(CrowPerchRenderer.class);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModBiomeGeneration.generateBiomes();
            AxeItem.f_150683_ = new ImmutableMap.Builder().putAll(AxeItem.f_150683_).put((Object)((Block)ModBlocks.MAHOGANY_LOG.get()), (Object)((Block)ModBlocks.STRIPPED_MAHOGANY_LOG.get())).put((Object)((Block)ModBlocks.MAHOGANY_WOOD.get()), (Object)((Block)ModBlocks.STRIPPED_MAHOGANY_WOOD.get())).put((Object)((Block)ModBlocks.WILLOW_LOG.get()), (Object)((Block)ModBlocks.STRIPPED_WILLOW_LOG.get())).put((Object)((Block)ModBlocks.WILLOW_WOOD.get()), (Object)((Block)ModBlocks.STRIPPED_WILLOW_WOOD.get())).build();
            Registry.m_122965_((Registry)Registry.f_122891_, (ResourceLocation)new ResourceLocation(MOD_ID, "witch_hut_leg_processor"), WITCH_HUT_LEG_PROCESSOR);
            Registry.m_122965_((Registry)Registry.f_122891_, (ResourceLocation)new ResourceLocation(MOD_ID, "dark_coven_leg_processor"), DARK_COVEN_LEG_PROCESSOR);
            Registry.m_122965_((Registry)Registry.f_122891_, (ResourceLocation)new ResourceLocation(MOD_ID, "mangrove_tree_leg_processor"), MANGROVE_TREE_LEG_PROCESSOR);
            HexereiPacketHandler.register();
            SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.CROW.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_27577_);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.MANDRAKE_FLOWER.getId(), ModBlocks.POTTED_MANDRAKE_FLOWER);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.BELLADONNA_FLOWER.getId(), ModBlocks.POTTED_BELLADONNA_FLOWER);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.YELLOW_DOCK_BUSH.getId(), ModBlocks.POTTED_YELLOW_DOCK_BUSH);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.MUGWORT_BUSH.getId(), ModBlocks.POTTED_MUGWORT_BUSH);
            ComposterBlock.f_51914_.put((Object)((Block)ModBlocks.WILLOW_VINES.get()).m_5456_(), 0.5f);
            ComposterBlock.f_51914_.put((Object)((LeavesBlock)ModBlocks.WILLOW_LEAVES.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((LeavesBlock)ModBlocks.MAHOGANY_LEAVES.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((SaplingBlock)ModBlocks.WILLOW_SAPLING.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((SaplingBlock)ModBlocks.MAHOGANY_SAPLING.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((PickableFlower)((Object)((Object)ModBlocks.MANDRAKE_FLOWER.get()))).m_5456_(), 1.0f);
            ComposterBlock.f_51914_.put((Object)((PickableFlower)((Object)((Object)ModBlocks.BELLADONNA_FLOWER.get()))).m_5456_(), 1.0f);
            ComposterBlock.f_51914_.put((Object)((PickableDoubleFlower)((Object)((Object)ModBlocks.MUGWORT_BUSH.get()))).m_5456_(), 1.0f);
            ComposterBlock.f_51914_.put((Object)((PickableDoubleFlower)((Object)((Object)ModBlocks.YELLOW_DOCK_BUSH.get()))).m_5456_(), 1.0f);
            ComposterBlock.f_51914_.put((Object)((FloweringLilyPadBlock)((Object)((Object)ModBlocks.LILY_PAD_BLOCK.get()))).m_5456_(), 1.0f);
            ComposterBlock.f_51914_.put((Object)((FlowerOutputItem)((Object)((Object)ModItems.BELLADONNA_BERRIES.get()))).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((FlowerOutputItem)((Object)((Object)ModItems.BELLADONNA_FLOWERS.get()))).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((FlowerOutputItem)((Object)((Object)ModItems.MANDRAKE_FLOWERS.get()))).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((FlowerOutputItem)((Object)((Object)ModItems.MANDRAKE_ROOT.get()))).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((FlowerOutputItem)((Object)((Object)ModItems.MUGWORT_FLOWERS.get()))).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((FlowerOutputItem)((Object)((Object)ModItems.MUGWORT_LEAVES.get()))).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((FlowerOutputItem)((Object)((Object)ModItems.YELLOW_DOCK_FLOWERS.get()))).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((FlowerOutputItem)((Object)((Object)ModItems.YELLOW_DOCK_LEAVES.get()))).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Item)ModItems.DRIED_BELLADONNA_FLOWERS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Item)ModItems.DRIED_MANDRAKE_FLOWERS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Item)ModItems.DRIED_MUGWORT_FLOWERS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Item)ModItems.DRIED_MUGWORT_LEAVES.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Item)ModItems.DRIED_YELLOW_DOCK_FLOWERS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Item)ModItems.DRIED_YELLOW_DOCK_LEAVES.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Item)ModItems.SAGE.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Item)ModItems.SAGE_SEED.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Item)ModItems.DRIED_SAGE.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Item)ModItems.TALLOW_IMPURITY.get()).m_5456_(), 0.3f);
        });
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        this.setupCrowPerchRenderer();
        ModKeyBindings.init();
        event.enqueueWork(() -> {
            MinecraftForgeClient.registerTooltipComponentFactory(HerbJarItem.HerbJarToolTip.class, ClientHerbJarToolTip::new);
            MinecraftForgeClient.registerTooltipComponentFactory(CofferItem.CofferItemToolTip.class, ClientCofferToolTip::new);
            MinecraftForgeClient.registerTooltipComponentFactory(BroomItem.BroomItemToolTip.class, ClientBroomToolTip::new);
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.QUICKSILVER_FLUID.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.QUICKSILVER_FLOWING.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModFluids.QUICKSILVER_BLOCK.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.BLOOD_FLUID.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.BLOOD_FLOWING.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModFluids.BLOOD_BLOCK.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.TALLOW_FLUID.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.TALLOW_FLOWING.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModFluids.TALLOW_BLOCK.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.MAHOGANY_DOOR.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.MAHOGANY_TRAPDOOR.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.MAHOGANY_TRAPDOOR.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WILLOW_DOOR.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WILLOW_TRAPDOOR.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.MIXING_CAULDRON.get()), (RenderType)RenderType.m_110457_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.CRYSTAL_BALL.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.CRYSTAL_BALL_ORB.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.CRYSTAL_BALL_LARGE_RING.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.CRYSTAL_BALL_SMALL_RING.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.HERB_JAR.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.HERB_DRYING_RACK_FULL.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.HERB_DRYING_RACK.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.MAHOGANY_SAPLING.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WILLOW_SAPLING.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.MANDRAKE_FLOWER.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.POTTED_MANDRAKE_FLOWER.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.BELLADONNA_FLOWER.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.POTTED_BELLADONNA_FLOWER.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.MUGWORT_BUSH.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.POTTED_MUGWORT_BUSH.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.YELLOW_DOCK_BUSH.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.POTTED_YELLOW_DOCK_BUSH.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.CANDELABRA.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SAGE.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LILY_PAD_BLOCK.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WILLOW_VINES.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WILLOW_VINES_PLANT.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.COFFER.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SELENITE_BLOCK.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SELENITE_CLUSTER.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.BUDDING_SELENITE.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LARGE_SELENITE_BUD.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.MEDIUM_SELENITE_BUD.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SMALL_SELENITE_BUD.get()), (RenderType)RenderType.m_110466_());
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.MIXING_CAULDRON_CONTAINER.get()), MixingCauldronScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.COFFER_CONTAINER.get()), CofferScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.HERB_JAR_CONTAINER.get()), HerbJarScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.BROOM_CONTAINER.get()), BroomScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.CROW_CONTAINER.get()), CrowScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.CROW_FLUTE_CONTAINER.get()), CrowFluteScreen::new);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderLast(RenderLevelLastEvent event) {
        clientTicksPartial = event.getPartialTick();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void clientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.type == TickEvent.Type.CLIENT) {
            clientTicks += 1.0f;
        }
    }

    public static float getClientTicks() {
        return clientTicks + clientTicksPartial;
    }

    public static float getClientTicksWithoutPartial() {
        return clientTicks;
    }

    public static float getPartial() {
        return clientTicksPartial;
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)MOD_ID, (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new SageBurningPlateEvent());
        MinecraftForge.EVENT_BUS.register((Object)new WitchArmorEvent());
        MinecraftForge.EVENT_BUS.register((Object)new CrowFluteEvent());
        MinecraftForge.EVENT_BUS.register((Object)new PageDrawing());
        glassesZoomKeyPressEvent = new GlassesZoomKeyPressEvent();
        MinecraftForge.EVENT_BUS.register((Object)glassesZoomKeyPressEvent);
    }

    static {
        entityClicked = false;
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        LOGGER = LogManager.getLogger();
        HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)HexereiConstants.CHANNEL_NAME).clientAcceptedVersions(HexereiConstants.PROTOCOL_VERSION::equals).serverAcceptedVersions(HexereiConstants.PROTOCOL_VERSION::equals).networkProtocolVersion(HexereiConstants.PROTOCOL_VERSION::toString).simpleChannel();
        WITCH_HUT_LEG_PROCESSOR = () -> WitchHutLegProcessor.CODEC;
        DARK_COVEN_LEG_PROCESSOR = () -> DarkCovenLegProcessor.CODEC;
        MANGROVE_TREE_LEG_PROCESSOR = () -> MangroveTreeLegProcessor.CODEC;
        sageBurningPlateTileList = new LinkedList();
        clientTicks = 0.0f;
        clientTicksPartial = 0.0f;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            LOGGER.info("HELLO from Register Block");
        }
    }
}

