/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.util.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.registry.block.BlockProperties;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Material;
import party.lemons.biomemakeover.block.BMBlock;
import party.lemons.biomemakeover.block.BMButtonBlock;
import party.lemons.biomemakeover.block.BMDoorBlock;
import party.lemons.biomemakeover.block.BMFenceBlock;
import party.lemons.biomemakeover.block.BMFenceGateBlock;
import party.lemons.biomemakeover.block.BMPillarBlock;
import party.lemons.biomemakeover.block.BMPressurePlateBlock;
import party.lemons.biomemakeover.block.BMSlabBlock;
import party.lemons.biomemakeover.block.BMStairBlock;
import party.lemons.biomemakeover.block.BMTrapdoorBlock;
import party.lemons.biomemakeover.block.modifier.FlammableModifier;
import party.lemons.biomemakeover.block.modifier.RTypeModifier;
import party.lemons.biomemakeover.block.modifier.StrippableModifier;
import party.lemons.biomemakeover.init.BMSigns;
import party.lemons.biomemakeover.item.BMBoatItem;
import party.lemons.biomemakeover.util.access.BlockEntityTypeAccess;
import party.lemons.biomemakeover.util.registry.RType;
import party.lemons.biomemakeover.util.registry.boat.BoatType;

public class WoodTypeInfo {
    private final List<Type> types = Lists.newArrayList();
    private final List<Type> itemTypes = Lists.newArrayList();
    private final Map<Type, Supplier<Block>> blocks = Maps.newHashMap();
    private final Map<Type, Supplier<Item>> items = Maps.newHashMap();
    private final WoodType woodType;
    private final String name;
    private final BlockBehaviour.Properties properties;
    private final Consumer<Supplier<Block>> callback;
    private final String modid;
    private final CreativeModeTab tab;
    private Supplier<BoatType> boatType;

    public WoodTypeInfo(String modid, CreativeModeTab group, String name) {
        this(modid, group, name, BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), null);
    }

    public WoodTypeInfo(String modid, CreativeModeTab group, String name, BlockBehaviour.Properties settings, Consumer<Supplier<Block>> callback) {
        this.modid = modid;
        this.name = name;
        this.properties = settings;
        this.callback = callback;
        this.tab = group;
        this.woodType = BMSigns.getSignType("bm_" + name);
        this.types.add(Type.LOG);
        this.types.add(Type.STRIPPED_LOG);
        this.types.add(Type.PLANK);
    }

    public WoodTypeInfo slab() {
        this.types.add(Type.SLAB);
        return this;
    }

    public WoodTypeInfo stair() {
        this.types.add(Type.STAIR);
        return this;
    }

    public WoodTypeInfo fence() {
        this.types.add(Type.FENCE);
        this.types.add(Type.FENCE_GATE);
        return this;
    }

    public WoodTypeInfo wood() {
        this.types.add(Type.WOOD);
        this.types.add(Type.STRIPPED_WOOD);
        return this;
    }

    public WoodTypeInfo pressure_plate() {
        this.types.add(Type.PRESSURE_PLATE);
        return this;
    }

    public WoodTypeInfo button() {
        this.types.add(Type.BUTTON);
        return this;
    }

    public WoodTypeInfo trapdoor() {
        this.types.add(Type.TRAP_DOOR);
        return this;
    }

    public WoodTypeInfo door() {
        this.types.add(Type.DOOR);
        return this;
    }

    public WoodTypeInfo sign() {
        this.types.add(Type.SIGN);
        this.types.add(Type.SIGN_WALL);
        this.itemTypes.add(Type.SIGN_ITEM);
        return this;
    }

    public WoodTypeInfo boat(Supplier<BoatType> boatType) {
        this.boatType = boatType;
        this.itemTypes.add(Type.BOAT);
        return this;
    }

    public Item.Properties properties() {
        return new Item.Properties().m_41491_(this.tab);
    }

    public WoodTypeInfo all(Supplier<BoatType> boatType) {
        return this.slab().stair().fence().wood().pressure_plate().button().trapdoor().door().sign().boat(boatType);
    }

    private void set(Type type, Supplier<Block> block) {
        this.blocks.put(type, block);
    }

    private void setItem(Type type, Supplier<Item> item) {
        this.items.put(type, item);
    }

    public Supplier<Block> getBlock(Type type) {
        return this.blocks.get((Object)type);
    }

    public Supplier<Item> getItem(Type type) {
        return this.items.get((Object)type);
    }

    public WoodTypeInfo register(DeferredRegister<Block> blockRegister, DeferredRegister<Item> itemRegister) {
        for (Type type : this.types) {
            Supplier<Block> blockSupplier = type.blockSupplier.getSupplier(this);
            if (blockSupplier == null) continue;
            ResourceLocation id = type.make(this.modid, this.name);
            RegistrySupplier regBlock = blockRegister.register(id, blockSupplier);
            this.set(type, (Supplier<Block>)regBlock);
            if (type.hasBlockItem) {
                itemRegister.register(id, () -> new BlockItem((Block)regBlock.get(), this.properties()));
            }
            if (this.callback == null) continue;
            this.callback.accept((Supplier<Block>)regBlock);
        }
        for (Type type : this.itemTypes) {
            Supplier<Item> itemSupplier = type.itemSupplier.getSupplier(this);
            if (itemSupplier == null) continue;
            RegistrySupplier item = itemRegister.register(type.make(this.modid, this.name), itemSupplier);
            this.setItem(type, (Supplier<Item>)item);
        }
        if (this.types.contains((Object)Type.SIGN)) {
            LifecycleEvent.SETUP.register(() -> ((BlockEntityTypeAccess)BlockEntityType.f_58924_).bm_addBlockTypes(this.blocks.get((Object)Type.SIGN).get(), this.blocks.get((Object)Type.SIGN_WALL).get()));
        }
        return this;
    }

    public static enum Type {
        STRIPPED_WOOD("stripped", "wood", true, f -> () -> new BMPillarBlock(BlockProperties.copy((BlockBehaviour.Properties)f.properties).m_155956_(2.0f)).modifiers(FlammableModifier.WOOD)),
        STRIPPED_LOG("stripped", "log", true, f -> () -> new BMPillarBlock(BlockProperties.copy((BlockBehaviour.Properties)f.properties).m_155956_(2.0f)).modifiers(FlammableModifier.WOOD)),
        PLANK("", "planks", true, f -> () -> new BMBlock((BlockBehaviour.Properties)BlockProperties.copy((BlockBehaviour.Properties)f.properties)).modifiers(FlammableModifier.WOOD)),
        LOG("", "log", true, f -> () -> new BMPillarBlock(BlockProperties.copy((BlockBehaviour.Properties)f.properties).m_155956_(2.0f)).modifiers(FlammableModifier.WOOD, new StrippableModifier(() -> f.getBlock(STRIPPED_LOG).get()))),
        WOOD("", "wood", true, f -> () -> new BMPillarBlock(BlockProperties.copy((BlockBehaviour.Properties)f.properties).m_155956_(2.0f)).modifiers(FlammableModifier.WOOD, new StrippableModifier(() -> f.getBlock(STRIPPED_WOOD).get()))),
        SLAB("", "slab", true, f -> () -> new BMSlabBlock((BlockBehaviour.Properties)BlockProperties.copy((BlockBehaviour.Properties)f.properties)).modifiers(FlammableModifier.WOOD)),
        STAIR("", "stairs", true, f -> () -> new BMStairBlock(f.getBlock(PLANK).get().m_49966_(), (BlockBehaviour.Properties)BlockProperties.copy((BlockBehaviour.Properties)f.properties)).modifiers(FlammableModifier.WOOD)),
        FENCE("", "fence", true, f -> () -> new BMFenceBlock((BlockBehaviour.Properties)BlockProperties.copy((BlockBehaviour.Properties)f.properties)).modifiers(FlammableModifier.WOOD)),
        FENCE_GATE("", "fence_gate", true, f -> () -> new BMFenceGateBlock((BlockBehaviour.Properties)BlockProperties.copy((BlockBehaviour.Properties)f.properties)).modifiers(FlammableModifier.WOOD)),
        PRESSURE_PLATE("", "pressure_plate", true, f -> () -> new BMPressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockProperties.copy((BlockBehaviour.Properties)f.properties).m_60978_(0.5f).m_60910_())),
        BUTTON("", "button", true, f -> () -> new BMButtonBlock(BlockProperties.copy((BlockBehaviour.Properties)f.properties).m_60978_(0.5f).m_60910_())),
        TRAP_DOOR("", "trapdoor", true, f -> () -> new BMTrapdoorBlock(BlockProperties.copy((BlockBehaviour.Properties)f.properties).m_60978_(3.0f).m_60955_()).modifiers(RTypeModifier.create(RType.CUTOUT))),
        DOOR("", "door", true, f -> () -> new BMDoorBlock(BlockProperties.copy((BlockBehaviour.Properties)f.properties).m_60978_(3.0f).m_60955_()).modifiers(RTypeModifier.create(RType.CUTOUT))),
        SIGN("", "sign", false, f -> () -> new StandingSignBlock(BlockProperties.of((Material)Material.f_76320_).m_60978_(1.0f).m_60918_(SoundType.f_56736_).m_60910_(), f.woodType)),
        SIGN_WALL("", "wall_sign", false, f -> () -> new WallSignBlock(BlockProperties.of((Material)Material.f_76320_).m_60978_(1.0f).m_60918_(SoundType.f_56736_).m_60910_(), f.woodType)),
        SIGN_ITEM("", "sign", false, null, f -> () -> new SignItem(f.properties().m_41487_(16), f.getBlock(SIGN).get(), f.getBlock(SIGN_WALL).get())),
        BOAT("", "boat", false, null, f -> () -> new BMBoatItem(f.boatType, f.properties().m_41487_(1)));

        private final String postfix;
        private final String prefix;
        private final boolean hasBlockItem;
        private final TypeBlockSupplier<Block> blockSupplier;
        private final TypeBlockSupplier<Item> itemSupplier;

        private Type(String prefix, String postfix, boolean hasBlockItem, TypeBlockSupplier<Block> blockSupplier) {
            this(prefix, postfix, hasBlockItem, blockSupplier, null);
        }

        private Type(String prefix, String postfix, boolean hasBlockItem, TypeBlockSupplier<Block> blockSupplier, TypeBlockSupplier<Item> itemSupplier) {
            this.postfix = postfix;
            this.prefix = prefix;
            this.hasBlockItem = hasBlockItem;
            this.blockSupplier = blockSupplier;
            this.itemSupplier = itemSupplier;
        }

        public ResourceLocation make(String modid, String name) {
            Object s = "";
            if (!this.prefix.isEmpty()) {
                s = (String)s + this.prefix + "_";
            }
            s = (String)s + name;
            if (!this.postfix.isEmpty()) {
                s = (String)s + "_" + this.postfix;
            }
            return new ResourceLocation(modid, (String)s);
        }
    }

    @FunctionalInterface
    private static interface TypeBlockSupplier<T> {
        public Supplier<T> getSupplier(WoodTypeInfo var1);
    }
}

