/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.util.data.wiki;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.util.Pair;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.block.modifier.CompostModifier;
import party.lemons.biomemakeover.block.modifier.FlammableModifier;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.util.data.wiki.BlockModifiersWiki;
import party.lemons.biomemakeover.util.data.wiki.BlockPage;
import party.lemons.biomemakeover.util.data.wiki.BlockSettingsWiki;
import party.lemons.biomemakeover.util.data.wiki.BlockTagsWiki;
import party.lemons.biomemakeover.util.data.wiki.EffectWiki;
import party.lemons.biomemakeover.util.data.wiki.FoodWiki;
import party.lemons.biomemakeover.util.data.wiki.ItemPage;

public final class WikiGenerator {
    private static final List<ItemPage> ITEMS = Lists.newArrayList();
    private static final List<BlockPage> BLOCKS = Lists.newArrayList();
    private static String ITEM_TEMPLATE;
    private static String BLOCK_TEMPLATE;

    public static void generate() {
        for (Item item : Registry.f_122827_) {
            if (!WikiGenerator.isValidItem(item)) continue;
            WikiGenerator.generateItem(item);
        }
        for (Block block : Registry.f_122824_) {
            if (!WikiGenerator.isValidBlock(block)) continue;
            WikiGenerator.generateBlock(block);
        }
        WikiGenerator.doOutput();
    }

    private static void doOutput() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            Files.createDirectories(Paths.get("wiki/template/", new String[0]), new FileAttribute[0]);
            StringBuilder builder = new StringBuilder();
            Files.readAllLines(Paths.get("wiki/template/item_template.md", new String[0])).forEach(s -> builder.append((String)s).append("\n"));
            ITEM_TEMPLATE = builder.toString();
            Files.createDirectories(Paths.get("wiki/items/pages/", new String[0]), new FileAttribute[0]);
            StringBuilder blockBuilder = new StringBuilder();
            Files.readAllLines(Paths.get("wiki/template/block_template.md", new String[0])).forEach(s -> blockBuilder.append((String)s).append("\n"));
            BLOCK_TEMPLATE = blockBuilder.toString();
            Files.createDirectories(Paths.get("wiki/blocks/pages/", new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ITEMS.forEach(i -> {
            try {
                FileWriter writer = new FileWriter("wiki/items/" + WikiGenerator.idToFileName(i.id()) + ".json");
                gson.toJson(i, (Appendable)writer);
                writer.flush();
                writer.close();
                FileWriter fileWriter = new FileWriter("wiki/items/pages/" + WikiGenerator.idToFileName(i.id()) + ".md");
                PrintWriter printWriter = new PrintWriter(fileWriter);
                String pageString = ITEM_TEMPLATE.replace("[ITEM_NAME]", i.name()).replace("[ITEM_FILE]", WikiGenerator.idToFileName(i.id()));
                printWriter.println(pageString);
                fileWriter.flush();
                printWriter.close();
                fileWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        BLOCKS.forEach(i -> {
            try {
                FileWriter writer = new FileWriter("wiki/blocks/" + WikiGenerator.idToFileName(i.id()) + ".json");
                gson.toJson(i, (Appendable)writer);
                writer.flush();
                writer.close();
                FileWriter fileWriter = new FileWriter("wiki/blocks/pages/" + WikiGenerator.idToFileName(i.id()) + ".md");
                PrintWriter printWriter = new PrintWriter(fileWriter);
                String pageString = BLOCK_TEMPLATE.replace("[BLOCK_NAME]", i.name()).replace("[BLOCK_FILE]", WikiGenerator.idToFileName(i.id()));
                printWriter.println(pageString);
                fileWriter.flush();
                printWriter.close();
                fileWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private static String getItemDescription() {
        return "This item does not have a description yet!";
    }

    private static String getBlockDescription() {
        return "This block does not have a description yet!";
    }

    private static void generateItem(Item item) {
        if (item instanceof RecordItem) {
            RecordItem record = (RecordItem)item;
            ITEMS.add(new RecordItemPageImpl(record));
        } else {
            ITEMS.add(new ItemPageImpl(item));
        }
    }

    private static void generateBlock(Block block) {
        BLOCKS.add(new BlockPageImpl(block));
    }

    private static boolean isValidItem(Item item) {
        return Registry.f_122827_.m_7981_((Object)item).m_135827_().equals("biomemakeover") && item.getClass() != BlockItem.class && !(item instanceof StandingAndWallBlockItem);
    }

    private static boolean isValidBlock(Block block) {
        return Registry.f_122824_.m_7981_((Object)block).m_135827_().equals("biomemakeover") && !BMBlocks.TAPESTRY_WALL_BLOCKS.contains(block);
    }

    private static String idToFileName(String id) {
        return id.split(":")[1];
    }

    private WikiGenerator() {
    }

    private static class RecordItemPageImpl
    extends ItemPageImpl {
        public RecordItemPageImpl(RecordItem record) {
            super((Item)record);
            this.name = this.name() + " (" + I18n.m_118938_((String)(record.m_5524_() + ".desc"), (Object[])new Object[0]) + ")";
        }
    }

    public static class ItemPageImpl
    implements ItemPage {
        protected String name;
        protected String id;
        protected String description;
        @Nullable
        protected FoodWiki food;
        @Nullable
        protected ArmorWikiImpl armor;
        protected List<String> tags = Lists.newArrayList();

        public ItemPageImpl(Item item) {
            this.name = I18n.m_118938_((String)item.m_5524_(), (Object[])new Object[0]);
            this.id = Registry.f_122827_.m_7981_((Object)item).toString();
            this.description = WikiGenerator.getItemDescription();
            if (item.m_41473_() != null) {
                this.food = new FoodWikiImpl(item.m_41473_());
                this.tags.add("food");
            }
            if (item instanceof ArmorItem) {
                ArmorItem armor = (ArmorItem)item;
                this.armor = new ArmorWikiImpl(armor);
                this.tags.add("armor");
                this.tags.add(armor.m_40401_().m_6082_());
            }
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public String description() {
            return this.description;
        }

        @Override
        @Nullable
        public FoodWiki food() {
            return this.food;
        }

        @Override
        public List<String> getTags() {
            return this.tags;
        }
    }

    private static class BlockPageImpl
    implements BlockPage {
        protected String name;
        protected String id;
        protected String description;
        protected BlockSettingsWiki settings;
        protected BlockTagsWiki blockTags;
        protected BlockModifiersWiki modifiers;
        protected List<String> tags = Lists.newArrayList();

        public BlockPageImpl(Block block) {
            this.name = I18n.m_118938_((String)block.m_7705_(), (Object[])new Object[0]);
            this.id = Registry.f_122824_.m_7981_((Object)block).toString();
            this.description = WikiGenerator.getBlockDescription();
            this.settings = new BlockSettingsWikiImpl(block);
            this.blockTags = new BlockTagsWikiImpl(block);
            this.modifiers = new BlockModifiersWikiImpl(block);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public String description() {
            return this.description;
        }

        @Override
        public BlockSettingsWiki settings() {
            return this.settings;
        }

        @Override
        public BlockTagsWiki tags() {
            return this.blockTags;
        }

        @Override
        public BlockModifiersWiki modifiers() {
            return this.modifiers;
        }

        @Override
        public List<String> getTags() {
            return this.tags;
        }
    }

    private static class BlockModifiersWikiImpl
    implements BlockModifiersWiki {
        private float compostChance = 0.0f;
        private int flameCatchChance = 0;
        private int flameBurnChance = 0;

        public BlockModifiersWikiImpl(Block block) {
            for (CompostModifier.CompostValue compostValue : BMBlocks.COMPOSTABLES) {
                if (compostValue.block() != block) continue;
                this.compostChance = compostValue.chance();
            }
            if (FlammableModifier.CATCH_ODDS.containsKey(block)) {
                this.flameCatchChance = FlammableModifier.CATCH_ODDS.get(block);
                this.flameBurnChance = FlammableModifier.BURN_ODDS.get(block);
            }
        }

        @Override
        public float compostChance() {
            return this.compostChance;
        }

        @Override
        public int flameCatchChance() {
            return this.flameCatchChance;
        }

        @Override
        public int flameBurnChance() {
            return this.flameBurnChance;
        }
    }

    private static class BlockTagsWikiImpl
    implements BlockTagsWiki {
        List<String> tags = Lists.newArrayList();

        public BlockTagsWikiImpl(Block block) {
        }

        @Override
        public List<String> blocktags() {
            return this.tags;
        }
    }

    private static class BlockSettingsWikiImpl
    implements BlockSettingsWiki {
        private float explosionResistance;
        private float destroyTime;
        private boolean requiresTool;

        public BlockSettingsWikiImpl(Block block) {
            this.explosionResistance = block.m_7325_();
            this.destroyTime = block.m_155943_();
            this.requiresTool = block.m_49966_().m_60834_();
        }

        @Override
        public float explosionResistance() {
            return this.explosionResistance;
        }

        @Override
        public float destroyTime() {
            return this.destroyTime;
        }

        @Override
        public boolean requiresTool() {
            return this.requiresTool;
        }
    }

    private static class ArmorWikiImpl {
        protected String armorName;
        protected float defence;
        protected float toughness;
        protected float enchantment;
        protected float knockbackResistance;
        protected String slot;
        protected String[] repairItems;

        public ArmorWikiImpl(ArmorItem armor) {
            ArmorMaterial material = armor.m_40401_();
            this.armorName = WordUtils.capitalize((String)material.m_6082_());
            this.defence = armor.m_40404_();
            this.toughness = armor.m_6473_();
            this.knockbackResistance = material.m_6649_();
            this.slot = WordUtils.capitalize((String)armor.m_40402_().m_20751_());
            int repairLength = material.m_6230_().m_43908_().length;
            if (repairLength != 0) {
                this.repairItems = new String[repairLength];
                for (int i = 0; i < repairLength; ++i) {
                    this.repairItems[i] = I18n.m_118938_((String)material.m_6230_().m_43908_()[i].m_41778_(), (Object[])new Object[0]);
                }
            }
        }
    }

    private static class EffectWikiImpl
    implements EffectWiki {
        protected String name;
        protected float length;
        protected int level;
        protected float chance;

        public EffectWikiImpl(MobEffectInstance first, Float chance) {
            this.name = I18n.m_118938_((String)first.m_19576_(), (Object[])new Object[0]);
            this.length = first.m_19557_();
            this.level = first.m_19564_();
            this.chance = chance.floatValue();
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public float length() {
            return this.length;
        }

        @Override
        public int level() {
            return this.level;
        }

        @Override
        public float chance() {
            return this.chance;
        }
    }

    private static class FoodWikiImpl
    implements FoodWiki {
        protected float saturation;
        protected float nutrition;
        protected EffectWiki[] effects;
        protected boolean alwaysEat;

        public FoodWikiImpl(FoodProperties food) {
            this.alwaysEat = food.m_38747_();
            this.saturation = food.m_38745_();
            this.nutrition = food.m_38744_();
            if (!food.m_38749_().isEmpty()) {
                this.effects = new EffectWiki[food.m_38749_().size()];
                for (int i = 0; i < food.m_38749_().size(); ++i) {
                    Pair effect = (Pair)food.m_38749_().get(i);
                    this.effects[i] = new EffectWikiImpl((MobEffectInstance)effect.getFirst(), (Float)effect.getSecond());
                }
            }
        }

        @Override
        public float saturation() {
            return this.saturation;
        }

        @Override
        public float nutrition() {
            return this.nutrition;
        }

        @Override
        public boolean alwaysEat() {
            return this.alwaysEat;
        }
    }
}

