/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.util.color;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.util.MathUtils;
import party.lemons.biomemakeover.util.color.FoliageBlockColorProvider;

public class FoliageShiftBlockColorProvider
extends FoliageBlockColorProvider {
    protected final int rShift;
    protected final int gShift;
    protected final int bShift;

    public FoliageShiftBlockColorProvider(int rShift, int gShift, int bShift) {
        this.rShift = rShift;
        this.gShift = gShift;
        this.bShift = bShift;
    }

    @Override
    public int m_92566_(BlockState state, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex == 0) {
            int color = super.m_92566_(state, world, pos, tintIndex);
            int[] boosts = this.getColorBoosts(world, state, pos, tintIndex);
            return MathUtils.colourBoost(color, boosts[0], boosts[1], boosts[2]);
        }
        return 0xFFFFFF;
    }

    protected int[] getColorBoosts(BlockAndTintGetter world, BlockState state, BlockPos pos, int tintIndex) {
        return new int[]{this.rShift, this.gShift, this.bShift};
    }

    public static class Willow
    extends FoliageShiftBlockColorProvider {
        public Willow() {
            super(0, 0, 0);
        }

        @Override
        protected int[] getColorBoosts(BlockAndTintGetter world, BlockState state, BlockPos pos, int tintIndex) {
            if (world instanceof ClientLevel && ((ClientLevel)world).m_204166_(pos).m_203656_(BiomeTags.f_207589_)) {
                return new int[]{-10, 15, -10};
            }
            return super.getColorBoosts(world, state, pos, tintIndex);
        }
    }

    public static class Lillies
    extends FoliageShiftBlockColorProvider {
        public Lillies() {
            super(-10, 10, -10);
        }

        @Override
        protected int[] getColorBoosts(BlockAndTintGetter world, BlockState state, BlockPos pos, int tintIndex) {
            if (world instanceof ClientLevel && pos != null && ((ClientLevel)world).m_204166_(pos).m_203656_(BiomeTags.f_207589_)) {
                return new int[]{-20, 40, -20};
            }
            return super.getColorBoosts(world, state, pos, tintIndex);
        }
    }
}

