/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.util;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.core.BlockPos;

public class Grid<V> {
    private final HashMap<GridPosition, V> entries = Maps.newHashMap();
    private int minX = 0;
    private int minY = 0;
    private int minZ = 0;
    private int maxX = 0;
    private int maxY = 0;
    private int maxZ = 0;

    public void put(int x, int y, int z, V entry) {
        GridPosition pos = new GridPosition(x, y, z);
        this.entries.put(pos, entry);
        if (x < this.minX) {
            this.minX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (z < this.minZ) {
            this.minZ = z;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        if (z > this.maxZ) {
            this.maxZ = z;
        }
    }

    public void put(BlockPos pos, V entry) {
        this.put(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), entry);
    }

    public boolean contains(int x, int y, int z) {
        return this.entries.containsKey(new GridPosition(x, y, z));
    }

    public boolean contains(BlockPos pos) {
        return this.contains(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public V get(int x, int y, int z) {
        return this.entries.get(new GridPosition(x, y, z));
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public V get(BlockPos pos) {
        return this.get(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public Collection<V> getEntries() {
        return this.entries.values();
    }

    private record GridPosition(int x, int y, int z) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GridPosition that = (GridPosition)o;
            return this.x == that.x && this.y == that.y && this.z == that.z;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.x, this.y, this.z);
        }
    }
}

