/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import party.lemons.biomemakeover.init.BMNetwork;
import party.lemons.biomemakeover.util.RandomUtil;

public class S2C_DoEntityParticle
extends BaseS2CMessage {
    private int entityID;
    private ParticleOptions effect;
    private int count;
    private float offset;
    private float velX;
    private float velY;
    private float velZ;

    public S2C_DoEntityParticle(Entity entity, ParticleOptions effect, int count, float offset) {
        this.entityID = entity.m_142049_();
        this.effect = effect;
        this.count = count;
        this.offset = offset;
    }

    public S2C_DoEntityParticle(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        ResourceLocation particleID = buf.m_130281_();
        this.effect = (ParticleOptions)Registry.f_122829_.m_7745_(particleID);
        this.count = buf.readInt();
        this.offset = buf.readFloat();
        this.velX = buf.readFloat();
        this.velY = buf.readFloat();
        this.velZ = buf.readFloat();
    }

    public MessageType getType() {
        return BMNetwork.ENTITY_PARTICLE;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.m_130085_(Registry.f_122829_.m_7981_((Object)((ParticleType)this.effect)));
        buf.writeInt(this.count);
        buf.writeFloat(this.offset);
        buf.writeDouble(RandomUtil.RANDOM.nextGaussian() * 0.02);
        buf.writeDouble(RandomUtil.RANDOM.nextGaussian() * 0.02);
        buf.writeDouble(RandomUtil.RANDOM.nextGaussian() * 0.02);
    }

    public void handle(NetworkManager.PacketContext context) {
        Entity entity = context.getPlayer().f_19853_.m_6815_(this.entityID);
        if (entity == null) {
            return;
        }
        if (this.effect == null) {
            return;
        }
        context.queue(() -> {
            for (int i = 0; i < this.count; ++i) {
                AABB bb = entity.m_142469_();
                double xx = RandomUtil.randomRange(bb.f_82288_ - (double)this.offset, bb.f_82291_ + (double)this.offset);
                double yy = RandomUtil.randomRange(bb.f_82289_ - (double)this.offset, bb.f_82292_ + (double)this.offset);
                double zz = RandomUtil.randomRange(bb.f_82290_ - (double)this.offset, bb.f_82293_ + (double)this.offset);
                entity.f_19853_.m_7106_(this.effect, xx, yy, zz, (double)this.velX, (double)this.velY, (double)this.velZ);
            }
        });
    }
}

